/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.ifelse.AndOperation;
import org.jboss.as.cli.handlers.ifelse.BaseOperation;
import org.jboss.as.cli.handlers.ifelse.ComparisonOperation;
import org.jboss.as.cli.handlers.ifelse.EqualsOperation;
import org.jboss.as.cli.handlers.ifelse.GreaterThanOperation;
import org.jboss.as.cli.handlers.ifelse.LesserThanOperation;
import org.jboss.as.cli.handlers.ifelse.MatchOperation;
import org.jboss.as.cli.handlers.ifelse.ModelNodePathOperand;
import org.jboss.as.cli.handlers.ifelse.NotEqualsOperation;
import org.jboss.as.cli.handlers.ifelse.NotGreaterThanOperation;
import org.jboss.as.cli.handlers.ifelse.NotLesserThanOperation;
import org.jboss.as.cli.handlers.ifelse.Operand;
import org.jboss.as.cli.handlers.ifelse.Operation;
import org.jboss.as.cli.handlers.ifelse.OrOperation;
import org.jboss.as.cli.handlers.ifelse.StringValueOperand;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.DefaultStateWithEndCharacter;
import org.jboss.as.cli.parsing.EscapeCharacterState;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.QuotesState;
import org.jboss.as.cli.parsing.StateParser;

public class ConditionArgument
extends ArgumentWithValue {
    private static final ParsingState AND = new OperationParsingState("&&"){

        @Override
        BaseOperation createOperation() {
            return new AndOperation();
        }
    };
    private static final ParsingState OR = new OperationParsingState("||"){

        @Override
        BaseOperation createOperation() {
            return new OrOperation();
        }
    };
    private static final ParsingState GT = new OperationParsingState(">"){

        @Override
        BaseOperation createOperation() {
            return new GreaterThanOperation();
        }
    };
    private static final ParsingState LT = new OperationParsingState("<"){

        @Override
        BaseOperation createOperation() {
            return new LesserThanOperation();
        }
    };
    private static final ParsingState NEQ = new OperationParsingState("!="){

        @Override
        BaseOperation createOperation() {
            return new NotEqualsOperation();
        }
    };
    private static final ParsingState EQ = new OperationParsingState("=="){

        @Override
        BaseOperation createOperation() {
            return new EqualsOperation();
        }
    };
    private static final ParsingState NGT = new OperationParsingState("<="){

        @Override
        BaseOperation createOperation() {
            return new NotGreaterThanOperation();
        }
    };
    private static final ParsingState NLT = new OperationParsingState(">="){

        @Override
        BaseOperation createOperation() {
            return new NotLesserThanOperation();
        }
    };
    private static final ParsingState MCH = new OperationParsingState("~="){

        @Override
        BaseOperation createOperation() {
            return new MatchOperation();
        }
    };
    private DefaultParsingState parenthesisState;
    private ExpressionBaseState exprState;

    public ConditionArgument(CommandHandlerWithArguments handler) {
        super(handler, 0, "--condition");
    }

    @Override
    protected ParsingState initParsingState() {
        CharacterHandler defaultHandler = new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                char c = ctx.getCharacter();
                if (c == '&' && this.isFollowingChar(ctx, '&')) {
                    this.signalState(ctx, AND, true);
                } else if (c == '|' && this.isFollowingChar(ctx, '|')) {
                    this.signalState(ctx, OR, true);
                } else if (c == '=' && this.isFollowingChar(ctx, '=')) {
                    this.signalState(ctx, EQ, true);
                } else if (c == '~' && this.isFollowingChar(ctx, '=')) {
                    this.signalState(ctx, MCH, true);
                } else if (c == '!' && this.isFollowingChar(ctx, '=')) {
                    this.signalState(ctx, NEQ, true);
                } else if (c == '>' && this.isFollowingChar(ctx, '=')) {
                    this.signalState(ctx, NLT, true);
                } else if (c == '<' && this.isFollowingChar(ctx, '=')) {
                    this.signalState(ctx, NGT, true);
                } else if (c == '>' && !this.isFollowingChar(ctx, '=')) {
                    this.signalState(ctx, GT, false);
                } else if (c == '<' && !this.isFollowingChar(ctx, '=')) {
                    this.signalState(ctx, LT, false);
                } else {
                    ctx.getCallbackHandler().character(ctx);
                }
            }

            protected void signalState(ParsingContext ctx, ParsingState state, boolean advance) throws CommandFormatException {
                ctx.enterState(state);
                if (advance) {
                    ctx.advanceLocation(1);
                }
                ctx.leaveState();
            }

            protected boolean isFollowingChar(ParsingContext ctx, char c) {
                if (ctx.getLocation() + 1 < ctx.getInput().length()) {
                    return ctx.getInput().charAt(ctx.getLocation() + 1) == c;
                }
                return false;
            }
        };
        this.exprState = new ExpressionBaseState("EXPR", true, false);
        this.exprState.setEnterHandler(GlobalCharacterHandlers.CONTENT_CHARACTER_HANDLER);
        this.exprState.setDefaultHandler(defaultHandler);
        this.exprState.enterState('\"', QuotesState.QUOTES_INCLUDED);
        this.exprState.enterState('\\', EscapeCharacterState.INSTANCE);
        this.exprState.putHandler(')', new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                ctx.leaveState();
                if (ctx.getState() == ConditionArgument.this.parenthesisState) {
                    ctx.leaveState();
                }
            }
        });
        this.parenthesisState = new DefaultStateWithEndCharacter("PARENTHESIS", ')', true, true);
        this.parenthesisState.enterState('\\', EscapeCharacterState.INSTANCE);
        this.parenthesisState.enterState('\"', QuotesState.QUOTES_INCLUDED);
        this.parenthesisState.enterState('(', this.parenthesisState);
        this.exprState.enterState('(', this.parenthesisState);
        this.parenthesisState.setDefaultHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                ctx.enterState(ConditionArgument.this.exprState);
            }
        });
        DefaultParsingState initial = new DefaultParsingState("EXPR_INITIAL");
        initial.enterState('(', this.parenthesisState);
        initial.setDefaultHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                ctx.enterState(ConditionArgument.this.exprState);
            }
        });
        return initial;
    }

    @Override
    public String getResolvedValue(ParsedCommandLine parsedLine, boolean required) throws CommandFormatException {
        String value = this.getOriginalValue(parsedLine, required);
        if (value == null) {
            return null;
        }
        final StringBuilder buf = new StringBuilder();
        StateParser.parse(value, new ParsingStateCallbackHandler(){

            @Override
            public void enteredState(ParsingContext ctx) throws CommandFormatException {
            }

            @Override
            public void leavingState(ParsingContext ctx) throws CommandFormatException {
            }

            @Override
            public void character(ParsingContext ctx) throws CommandFormatException {
                buf.append(ctx.getCharacter());
            }
        }, this.initialState);
        return buf.toString();
    }

    public Operation resolveOperation(ParsedCommandLine parsedLine) throws CommandFormatException {
        String value = this.getOriginalValue(parsedLine, true);
        if (value == null) {
            return null;
        }
        ConditionOperationCallback callback = new ConditionOperationCallback();
        StateParser.parse(value, callback, this.initialState);
        return callback.expr.getExpression();
    }

    private static abstract class OperationParsingState
    extends DefaultParsingState {
        public OperationParsingState(String id) {
            super(id);
        }

        abstract BaseOperation createOperation();
    }

    private static class ExpressionParsingState {
        final ExpressionParsingState parent;
        BaseOperation root;
        BaseOperation lastParsed;
        BaseOperation nestedExpression;

        ExpressionParsingState() {
            this(null);
        }

        ExpressionParsingState(ExpressionParsingState expr) {
            this.parent = expr;
        }

        BaseOperation getExpression() {
            return this.root == null ? this.nestedExpression : this.root;
        }

        protected void place(Operand nextOperand, BaseOperation nextOperation) throws CommandLineException {
            BaseOperation parent = this.lastParsed;
            nextOperation.setParent(parent);
            this.lastParsed = nextOperation;
            if (parent == null) {
                this.root = this.lastParsed;
            }
            if (parent == null) {
                this.lastParsed.addOperand(nextOperand);
            } else if (parent.getPriority() >= this.lastParsed.getPriority()) {
                if (parent.allowsMoreArguments()) {
                    BaseOperation targetParent;
                    parent.addOperand(nextOperand);
                    for (targetParent = parent; targetParent != null; targetParent = targetParent.getParent()) {
                        if (targetParent.getPriority() > this.lastParsed.getPriority()) continue;
                        parent = targetParent;
                        break;
                    }
                    if (targetParent == null) {
                        this.lastParsed.addOperand(this.root);
                        this.root = this.lastParsed;
                    } else if (parent.getName().equals(this.lastParsed.getName())) {
                        this.lastParsed = parent;
                    } else {
                        this.lastParsed.addOperand(parent.getLastOperand());
                        parent.replaceLastOperand(this.lastParsed);
                    }
                } else {
                    this.lastParsed.addOperand(nextOperand);
                    for (BaseOperation targetParent = parent.getParent(); targetParent != null; targetParent = targetParent.getParent()) {
                        if (!targetParent.allowsMoreArguments()) continue;
                        parent = targetParent;
                        break;
                    }
                    if (!parent.allowsMoreArguments()) {
                        throw new IllegalStateException();
                    }
                    parent.addOperand(this.lastParsed);
                }
            } else {
                this.lastParsed.addOperand(nextOperand);
                for (BaseOperation targetParent = parent; targetParent != null; targetParent = targetParent.getParent()) {
                    if (!targetParent.allowsMoreArguments()) continue;
                    parent = targetParent;
                    break;
                }
                if (!parent.allowsMoreArguments()) {
                    throw new IllegalStateException();
                }
                parent.addOperand(this.lastParsed);
            }
        }
    }

    private final class ConditionOperationCallback
    implements ParsingStateCallbackHandler {
        final StringBuilder buf = new StringBuilder();
        ExpressionParsingState expr = new ExpressionParsingState();

        private ConditionOperationCallback() {
        }

        @Override
        public void enteredState(ParsingContext ctx) throws CommandFormatException {
            if (ctx.getState() == ConditionArgument.this.parenthesisState) {
                this.expr = new ExpressionParsingState(this.expr);
            }
        }

        @Override
        public void leavingState(ParsingContext ctx) throws CommandFormatException {
            ParsingState state = ctx.getState();
            try {
                if (state instanceof OperationParsingState) {
                    Operand nextOperand;
                    BaseOperation nextOperation = ((OperationParsingState)state).createOperation();
                    if (this.expr.nestedExpression != null) {
                        nextOperand = this.expr.nestedExpression;
                        this.expr.nestedExpression = null;
                    } else {
                        nextOperand = nextOperation instanceof ComparisonOperation ? new ModelNodePathOperand(this.buf.toString()) : new StringValueOperand(this.buf.toString());
                    }
                    this.expr.place(nextOperand, nextOperation);
                    this.buf.setLength(0);
                } else if (state == ConditionArgument.this.exprState) {
                    if (this.buf.length() > 0) {
                        if (this.expr.lastParsed == null) {
                            throw new CommandFormatException("The operation is missing in front of '" + this.buf.toString() + "'");
                        }
                        StringValueOperand operand = new StringValueOperand(this.buf.toString());
                        this.expr.lastParsed.addOperand(operand);
                        this.buf.setLength(0);
                    } else if (this.expr.nestedExpression != null) {
                        if (this.expr.lastParsed == null) {
                            throw new CommandFormatException("The operation is missing in front of '" + this.expr.nestedExpression + "'");
                        }
                        this.expr.lastParsed.addOperand(this.expr.nestedExpression);
                        this.expr.nestedExpression = null;
                    }
                } else if (state == ConditionArgument.this.parenthesisState && this.expr.parent != null) {
                    this.expr.parent.nestedExpression = this.expr.root;
                    this.expr = this.expr.parent;
                }
            }
            catch (CommandLineException e) {
                throw new CommandFormatException("Failed to parse if condition", e);
            }
        }

        @Override
        public void character(ParsingContext ctx) throws CommandFormatException {
            if (ConditionArgument.this.parenthesisState != ctx.getState() && (!Character.isWhitespace(ctx.getCharacter()) || ctx.getState().getId().equals("QUOTES") || ctx.getState().getId().equals("ESCAPED_CHARACTER"))) {
                this.buf.append(ctx.getCharacter());
            }
        }
    }
}

