/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server._private;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.AuthorizationFailureException;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=3, max=3), @ValidIdRange(min=8, max=8), @ValidIdRange(min=1000, max=1156), @ValidIdRange(min=8510, max=8511), @ValidIdRange(min=16000, max=16999)})
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=3, value="This builder has already been built")
    public IllegalStateException builderAlreadyBuilt();

    @Message(id=8, value="The given credential is not supported here")
    public IllegalArgumentException credentialNotSupported();

    @Message(id=1000, value="Authentication name was already set on this context")
    public IllegalStateException nameAlreadySet();

    @Message(id=1003, value="No authentication is in progress")
    public IllegalStateException noAuthenticationInProgress();

    @Message(id=1005, value="Realm map does not contain mapping for default realm '%s'")
    public IllegalArgumentException realmMapDoesNotContainDefault(String var1);

    @Message(id=1019, value="Unable to obtain exclusive access to backing identity")
    public RealmUnavailableException unableToObtainExclusiveAccess();

    @Message(id=1033, value="User does not exist")
    public IllegalStateException userDoesNotExist();

    @Message(id=1034, value="Invalid credential type specified")
    public IllegalStateException invalidCredentialTypeSpecified();

    @Message(id=1064, value="Invalid identity name")
    public IllegalArgumentException invalidName();

    @Message(id=1088, value="Attempting to run as \"%s\" authorization operation failed")
    public AuthorizationFailureException runAsAuthorizationFailed(@Param Principal var1, Principal var2, @Cause Throwable var3);

    @Message(id=1092, value="Invalid mechanism realm selection \"%s\"")
    public IllegalArgumentException invalidMechRealmSelection(String var1);

    @Message(id=1093, value="Mechanism realm was already selected")
    public IllegalStateException mechRealmAlreadySelected();

    @Message(id=1095, value="Unable to create identity")
    public RealmUnavailableException unableToCreateIdentity();

    @Message(id=1096, value="No such identity")
    public RealmUnavailableException noSuchIdentity();

    @Message(id=1112, value="Authentication cannot succeed; not authorized")
    public IllegalStateException cannotSucceedNotAuthorized();

    @Message(id=1119, value="Unable to resolve MechanismConfiguration for mechanismType='%s', mechanismName='%s', hostName='%s', protocol='%s'.")
    public IllegalStateException unableToSelectMechanismConfiguration(String var1, String var2, String var3, String var4);

    @Message(id=1120, value="Too late to set mechanism information as authentication has already begun.")
    public IllegalStateException tooLateToSetMechanismInformation();

    @Message(id=1124, value="The security realm does not support updating a credential")
    public UnsupportedOperationException credentialUpdateNotSupportedByRealm();

    @Message(id=1148, value="A SecurityDomain has already been associated with the specified ClassLoader")
    public IllegalStateException classLoaderSecurityDomainExists();

    @Message(id=1149, value="Can not use SecurityIdentity with SecurityIdentity from same SecurityDomain")
    public IllegalArgumentException cantWithSameSecurityDomainDomain();

    @Message(id=1151, value="Evidence Verification Failed.")
    public SecurityException authenticationFailedEvidenceVerification();

    @Message(id=1152, value="Authorization Check Failed.")
    public SecurityException authenticationFailedAuthorization();

    @Message(id=1155, value="Security domain mismatch")
    public IllegalArgumentException securityDomainMismatch();

    @Message(id=1156, value="Cannot obtain a credential from a security factory")
    public IOException cannotObtainCredentialFromFactory(@Cause GeneralSecurityException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1094, value="An event handler threw an exception")
    public void eventHandlerFailed(@Cause Throwable var1);

    @Message(id=8510, value="Role mapper has already been initialized.")
    public IllegalStateException roleMappedAlreadyInitialized();

    @Message(id=8511, value="Role mapper hasn't been initialized yet.")
    public IllegalStateException roleMappedNotInitialized();

    @Message(id=16000, value="Invalid replacement in regex role mapper.")
    public IllegalArgumentException invalidReplacementInRegexRoleMapper();

    @Message(id=16001, value="Invalid pattern in regex role mapper.")
    public IllegalArgumentException invalidPatternInRegexRoleMapper();

    @Message(id=16002, value="Can not handle SecurityEvent with SecurityIdentity from other SecurityDomain")
    public IllegalArgumentException securityEventIdentityWrongDomain();
}

