/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.security.permission.AbstractActionSetPermission;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.AbstractPermissionCollection;
import org.wildfly.security.permission.ElytronMessages;
import org.wildfly.security.util.ArrayIterator;

public final class SimpleActionBitsPermissionCollection
extends AbstractPermissionCollection {
    private static final AbstractActionSetPermission<?>[] NO_PERMS = new AbstractActionSetPermission[0];
    private final AtomicReference<AbstractActionSetPermission<?>[]> permissionsRef = new AtomicReference<AbstractActionSetPermission<?>[]>(NO_PERMS);

    public SimpleActionBitsPermissionCollection(AbstractActionSetPermission<?> sourcePermission) {
        super(sourcePermission);
    }

    @Override
    public int size() {
        return this.permissionsRef.get().length;
    }

    @Override
    protected void doAdd(AbstractPermission<?> permission) {
        if (permission instanceof AbstractActionSetPermission) {
            this.doAdd((AbstractActionSetPermission)permission);
        }
        throw ElytronMessages.log.invalidPermissionType(AbstractActionSetPermission.class, permission);
    }

    protected void doAdd(AbstractActionSetPermission<?> permission) {
        AbstractActionSetPermission[] newVal;
        AbstractActionSetPermission<?>[] oldVal;
        AtomicReference<AbstractActionSetPermission<?>[]> permissionsRef = this.permissionsRef;
        do {
            AbstractActionSetPermission<?>[] readVal = permissionsRef.get();
            int count = 0;
            do {
                oldVal = readVal;
                AbstractActionSetPermission<?> merged = permission;
                while (true) {
                    for (AbstractActionSetPermission<?> test : oldVal) {
                        if (test.implies(merged)) {
                            return;
                        }
                        if (test.nameEquals(merged)) {
                            merged = merged.withActionBits(permission.getActionBits());
                            count = 0;
                            continue;
                        }
                        if (merged.implies(test)) continue;
                        ++count;
                    }
                    break;
                }
            } while ((readVal = permissionsRef.get()) != oldVal);
            newVal = new AbstractActionSetPermission[count + 1];
            int i = 0;
            for (AbstractActionSetPermission<?> test : oldVal) {
                if (permission.implies(test)) continue;
                newVal[i++] = test;
            }
            newVal[i] = permission;
        } while (!permissionsRef.compareAndSet(oldVal, newVal));
    }

    @Override
    public boolean implies(Permission permission) {
        for (AbstractActionSetPermission<?> test : this.permissionsRef.get()) {
            if (!((Permission)test).implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Permission> iterator() {
        return new ArrayIterator<Permission>((Permission[])this.permissionsRef.get());
    }

    @Override
    public Enumeration<Permission> elements() {
        return new ArrayIterator<Permission>((Permission[])this.permissionsRef.get());
    }
}

