/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionExpireMessage
extends PacketImpl {
    private long consumerID;
    private long messageID;

    public SessionExpireMessage(long consumerID, long messageID) {
        super((byte)42);
        this.consumerID = consumerID;
        this.messageID = messageID;
    }

    public SessionExpireMessage() {
        super((byte)42);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.messageID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.messageID = buffer.readLong();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        result = 31 * result + (int)(this.messageID ^ this.messageID >>> 32);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", consumerID=" + this.consumerID);
        buff.append(", messageID=" + this.messageID);
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionExpireMessage)) {
            return false;
        }
        SessionExpireMessage other = (SessionExpireMessage)obj;
        if (this.consumerID != other.consumerID) {
            return false;
        }
        return this.messageID == other.messageID;
    }
}

