/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.DB2TableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.GenericTableManager;
import org.infinispan.persistence.jdbc.impl.table.H2TableManager;
import org.infinispan.persistence.jdbc.impl.table.MyTableOperations;
import org.infinispan.persistence.jdbc.impl.table.OracleTableManager;
import org.infinispan.persistence.jdbc.impl.table.PostgresTableManager;
import org.infinispan.persistence.jdbc.impl.table.SQLiteTableManager;
import org.infinispan.persistence.jdbc.impl.table.SybaseTableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableOperations;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.logging.LogFactory;

public class TableManagerFactory {
    private static final Log log = (Log)LogFactory.getLog(TableManagerFactory.class, Log.class);
    public static final String UPSERT_DISABLED = "infinispan.jdbc.upsert.disabled";
    public static final String INDEXING_DISABLED = "infinispan.jdbc.indexing.disabled";

    public static <K, V> TableManager<K, V> getManager(InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, String cacheName) {
        DbMetaData metaData = TableManagerFactory.getDbMetaData(connectionFactory, config.dialect(), config.dbMajorVersion(), config.dbMinorVersion(), TableManagerFactory.isPropertyDisabled(config, UPSERT_DISABLED), TableManagerFactory.isPropertyDisabled(config, INDEXING_DISABLED), !config.segmented());
        return TableManagerFactory.getManager(metaData, ctx, connectionFactory, config, cacheName);
    }

    public static <K, V> TableManager<K, V> getManager(DbMetaData metaData, InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, String cacheName) {
        switch (metaData.getType()) {
            case DB2: 
            case DB2_390: {
                return new DB2TableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case H2: {
                return new H2TableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case MARIA_DB: 
            case MYSQL: {
                return new MyTableOperations(ctx, connectionFactory, config, metaData, cacheName);
            }
            case ORACLE: {
                return new OracleTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case POSTGRES: {
                return new PostgresTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case SQLITE: {
                return new SQLiteTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case SYBASE: {
                return new SybaseTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case SQL_SERVER: {
                return new TableOperations(ctx, connectionFactory, config, metaData, cacheName);
            }
        }
        return new GenericTableManager(ctx, connectionFactory, config, metaData, cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DbMetaData getDbMetaData(ConnectionFactory connectionFactory, DatabaseType databaseType, Integer majorVersion, Integer minorVersion, boolean disableUpsert, boolean disableIndexing, boolean disableSegmented) {
        DbMetaData dbMetaData;
        if (databaseType != null && majorVersion != null && minorVersion != null) {
            return new DbMetaData(databaseType, majorVersion, minorVersion, disableUpsert, disableIndexing, disableSegmented);
        }
        Connection connection = null;
        if (majorVersion == null || minorVersion == null) {
            try {
                connection = connectionFactory.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                majorVersion = metaData.getDatabaseMajorVersion();
                minorVersion = metaData.getDatabaseMinorVersion();
                String version = majorVersion + "." + minorVersion;
                if (log.isDebugEnabled()) {
                    log.debugf("Guessing database version as '%s'.  If this is incorrect, please specify both the correct major and minor version of your database using the 'databaseMajorVersion' and 'databaseMinorVersion' attributes in your configuration.", (Object)version);
                }
                if (databaseType != null) {
                    DbMetaData dbMetaData2 = new DbMetaData(databaseType, majorVersion, minorVersion, disableUpsert, disableIndexing, disableSegmented);
                    return dbMetaData2;
                }
            }
            catch (SQLException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to retrieve DB Major and Minor versions from JDBC metadata.", (Throwable)e);
                }
            }
            finally {
                connectionFactory.releaseConnection(connection);
            }
        }
        try {
            connection = connectionFactory.getConnection();
            String dbProduct = connection.getMetaData().getDatabaseProductName();
            dbMetaData = new DbMetaData(DatabaseType.guessDialect((String)dbProduct), majorVersion, minorVersion, disableUpsert, disableIndexing, disableSegmented);
            return dbMetaData;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to guess dialect from JDBC metadata.", (Throwable)e);
            }
        }
        finally {
            connectionFactory.releaseConnection(connection);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unable to detect database dialect using connection metadata.  Attempting to guess on driver name.");
        }
        try {
            connection = connectionFactory.getConnection();
            String dbProduct = connectionFactory.getConnection().getMetaData().getDriverName();
            dbMetaData = new DbMetaData(DatabaseType.guessDialect((String)dbProduct), majorVersion, minorVersion, disableUpsert, disableIndexing, disableSegmented);
            return dbMetaData;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to guess database dialect from JDBC driver name.", (Throwable)e);
            }
        }
        finally {
            connectionFactory.releaseConnection(connection);
        }
        if (databaseType == null) {
            throw new CacheConfigurationException("Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are " + Arrays.toString(DatabaseType.values()));
        }
        if (log.isDebugEnabled()) {
            log.debugf("Guessing database dialect as '%s'.  If this is incorrect, please specify the correct dialect using the 'dialect' attribute in your configuration.  Supported database dialect strings are %s", (Object)databaseType, (Object)Arrays.toString(DatabaseType.values()));
        }
        return new DbMetaData(databaseType, majorVersion, minorVersion, disableUpsert, disableIndexing, disableSegmented);
    }

    private static boolean isPropertyDisabled(AbstractJdbcStoreConfiguration config, String propertyName) {
        String property = config.properties().getProperty(propertyName);
        return property != null && Boolean.parseBoolean(property);
    }
}

