/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import java.io.IOException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.aesh.cmd.security.HttpServerCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.HTTPServer;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="disable-ssl-http-server", description="", activator=HttpServerCommandActivator.class)
public class HTTPServerDisableSSLCommand
implements Command<CLICommandInvocation>,
DMRCommand {
    @Option(name="no-reload", hasValue=false)
    boolean noReload;
    @Option(name="server-name", completer=SecurityCommand.OptionCompleters.ServerNameCompleter.class)
    String serverName;
    @Option(name="remove-https-listener", hasValue=false)
    boolean removeHttpsListener;
    @Option(name="https-listener-name", completer=SecurityCommand.OptionCompleters.HTTPSListenerCompleter.class, defaultValue={"https"})
    String httpsListener;
    @Option(name="default-server-ssl-context", hasValue=true, defaultValue={"applicationSSC"})
    String defaultAppSSLContext;

    public String getServerName(CommandContext ctx) {
        String sName = this.serverName;
        if (sName == null) {
            sName = DefaultResourceNames.getDefaultServerName(ctx);
        }
        return sName;
    }

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        ModelNode request;
        CommandContext ctx = commandInvocation.getCommandContext();
        try {
            this.serverName = this.getServerName(ctx);
            if (!HTTPServer.hasHttpsListener(ctx, this.serverName, this.httpsListener)) {
                throw new CommandException("No HTTPS Listener named " + this.httpsListener + " found in " + this.serverName);
            }
        }
        catch (IOException | OperationFormatException ex) {
            throw new CommandException((Throwable)ex);
        }
        try {
            request = this.buildRequest(ctx);
        }
        catch (CommandFormatException ex) {
            throw new CommandException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        SecurityCommand.execute(ctx, request, SecurityCommand.DEFAULT_FAILURE_CONSUMER, this.noReload);
        ctx.printLine("SSL disabled for " + this.serverName);
        if (this.removeHttpsListener) {
            ctx.printLine("HTTPS listener " + this.httpsListener + " has been removed");
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        try {
            if (!HTTPServer.isLegacySecurityRealmSupported(context) && !this.removeHttpsListener && this.defaultAppSSLContext.equals(HTTPServer.getSSLContextName(this.serverName, this.httpsListener, context))) {
                throw new CommandFormatException("The SSL Context " + this.defaultAppSSLContext + " is already set on " + this.httpsListener + " HTTPS listener");
            }
            this.serverName = HTTPServer.disableSSL(context, this.serverName, this.removeHttpsListener, this.httpsListener, this.defaultAppSSLContext, composite.get("steps"));
        }
        catch (Exception ex) {
            throw new CommandFormatException(ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage(), ex);
        }
        return composite;
    }
}

