/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.orm.loading.impl.LoadingTypeContext;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.massindexing.impl.ConditionalExpression;
import org.hibernate.search.util.common.AssertionFailure;

public abstract class AbstractHibernateOrmLoadingStrategy<E, I>
implements HibernateOrmEntityLoadingStrategy<E, I> {
    private final SessionFactoryImplementor sessionFactory;
    private final EntityPersister rootEntityPersister;
    private final TypeQueryFactory<E, I> queryFactory;

    AbstractHibernateOrmLoadingStrategy(SessionFactoryImplementor sessionFactory, EntityPersister rootEntityPersister, TypeQueryFactory<E, I> queryFactory) {
        this.sessionFactory = sessionFactory;
        this.rootEntityPersister = rootEntityPersister;
        this.queryFactory = queryFactory;
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(List<LoadingTypeContext<? extends E>> typeContexts, Optional<ConditionalExpression> conditionalExpression) {
        Set<Class<Class>> includedTypesFilter;
        if (HibernateOrmUtils.targetsAllConcreteSubTypes(this.sessionFactory, this.rootEntityPersister, typeContexts)) {
            includedTypesFilter = Collections.emptySet();
        } else {
            includedTypesFilter = new HashSet(typeContexts.size());
            for (LoadingTypeContext<E> typeContext : typeContexts) {
                includedTypesFilter.add(typeContext.typeIdentifier().javaClass());
            }
        }
        if (conditionalExpression.isPresent()) {
            if (typeContexts.size() != 1) {
                throw new AssertionFailure("conditional expression is always defined on a single type");
            }
            EntityPersister entityPersister = typeContexts.get(0).entityPersister();
            return new HibernateOrmQueryLoader(this.queryFactory, entityPersister, includedTypesFilter, conditionalExpression.get());
        }
        return new HibernateOrmQueryLoader(this.queryFactory, includedTypesFilter);
    }
}

