/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.as.ee.concurrent.handle.EE10ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ThreadContextProviderContextHandleFactory
implements EE10ContextHandleFactory {
    private static final int BASE_PRIORITY = 1000;
    private final ThreadContextProvider threadContextProvider;
    private final int priority;

    public ThreadContextProviderContextHandleFactory(ThreadContextProvider threadContextProvider, int priority) {
        this.threadContextProvider = threadContextProvider;
        this.priority = 1000 + priority;
    }

    @Override
    public String getContextType() {
        return this.threadContextProvider.getThreadContextType();
    }

    @Override
    public SetupContextHandle clearedContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new ContextHandle(this.threadContextProvider, contextObjectProperties, true);
    }

    @Override
    public SetupContextHandle propagatedContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new ContextHandle(this.threadContextProvider, contextObjectProperties, false);
    }

    @Override
    public String getName() {
        return this.getContextType();
    }

    @Override
    public int getChainPriority() {
        return this.priority;
    }

    @Override
    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
        out.writeObject(contextHandle);
    }

    @Override
    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return (ContextHandle)in.readObject();
    }

    public static Collection<ThreadContextProviderContextHandleFactory> fromServiceLoader(ClassLoader classLoader) {
        if (WildFlySecurityManager.isChecking()) {
            return (Collection)WildFlySecurityManager.doUnchecked(() -> ThreadContextProviderContextHandleFactory.fromServiceLoaderUnchecked(classLoader));
        }
        return ThreadContextProviderContextHandleFactory.fromServiceLoaderUnchecked(classLoader);
    }

    private static Collection<ThreadContextProviderContextHandleFactory> fromServiceLoaderUnchecked(ClassLoader classLoader) {
        HashSet<ThreadContextProviderContextHandleFactory> factories = new HashSet<ThreadContextProviderContextHandleFactory>();
        ServiceLoader<ThreadContextProvider> threadContextProviderServiceLoader = ServiceLoader.load(ThreadContextProvider.class, classLoader);
        Iterator<ThreadContextProvider> threadContextProviderIterator = threadContextProviderServiceLoader.iterator();
        int count = 0;
        while (threadContextProviderIterator.hasNext()) {
            ThreadContextProvider threadContextProvider = threadContextProviderIterator.next();
            factories.add(new ThreadContextProviderContextHandleFactory(threadContextProvider, count));
            ++count;
        }
        return factories;
    }

    private static class ContextHandle
    implements SetupContextHandle {
        private static final long serialVersionUID = 842115413317072688L;
        private final String factoryName;
        private final ThreadContextSnapshot savedContextSnapshot;

        private ContextHandle(ThreadContextProvider threadContextProvider, Map<String, String> contextObjectProperties, boolean cleared) {
            this.factoryName = threadContextProvider.getThreadContextType();
            this.savedContextSnapshot = cleared ? threadContextProvider.clearedContext(contextObjectProperties) : threadContextProvider.currentContext(contextObjectProperties);
        }

        @Override
        public String getFactoryName() {
            return this.factoryName;
        }

        @Override
        public ResetContextHandle setup() throws IllegalStateException {
            final ThreadContextRestorer threadContextRestorer = this.savedContextSnapshot.begin();
            return new ResetContextHandle(){

                @Override
                public void reset() {
                    threadContextRestorer.endContext();
                }

                @Override
                public String getFactoryName() {
                    return this.getFactoryName();
                }
            };
        }
    }
}

