/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.SortedNumericDoubleDocValues;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.JoinChildrenIdIterator;

public enum MultiValueMode {
    SUM{

        @Override
        long pick(SortedNumericDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            long result = 0L;
            for (int index = 0; index < valueCount; ++index) {
                result += values.nextValue();
            }
            return result;
        }

        @Override
        long pick(SortedNumericDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            long result = 0L;
            while (joinIterator.advanceValuesToNextChild()) {
                int valueCountForChild = values.docValueCount();
                for (int index = 0; index < valueCountForChild; ++index) {
                    result += values.nextValue();
                }
            }
            return result;
        }

        @Override
        double pick(SortedNumericDoubleDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            double result = 0.0;
            for (int index = 0; index < valueCount; ++index) {
                result += values.nextValue();
            }
            return result;
        }

        @Override
        double pick(SortedNumericDoubleDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            double result = 0.0;
            while (joinIterator.advanceValuesToNextChild()) {
                int valueCountForChild = values.docValueCount();
                for (int index = 0; index < valueCountForChild; ++index) {
                    result += values.nextValue();
                }
            }
            return result;
        }
    }
    ,
    AVG{

        @Override
        long pick(SortedNumericDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            long result = 0L;
            for (int index = 0; index < valueCount; ++index) {
                result += values.nextValue();
            }
            return result /= (long)valueCount;
        }

        @Override
        long pick(SortedNumericDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            long returnValue = 0L;
            int valueCount = 0;
            while (joinIterator.advanceValuesToNextChild()) {
                int valueCountForChild = values.docValueCount();
                for (int index = 0; index < valueCountForChild; ++index) {
                    returnValue += values.nextValue();
                }
                valueCount += valueCountForChild;
            }
            returnValue = valueCount > 0 ? (returnValue /= (long)valueCount) : 0L;
            return returnValue;
        }

        @Override
        double pick(SortedNumericDoubleDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            double result = 0.0;
            for (int index = 0; index < valueCount; ++index) {
                result += values.nextValue();
            }
            return result /= (double)valueCount;
        }

        @Override
        double pick(SortedNumericDoubleDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            double result = 0.0;
            int valueCount = 0;
            while (joinIterator.advanceValuesToNextChild()) {
                int valueCountForChild = values.docValueCount();
                for (int index = 0; index < valueCountForChild; ++index) {
                    result += values.nextValue();
                }
                valueCount += valueCountForChild;
            }
            result = valueCount > 0 ? (result /= (double)valueCount) : 0.0;
            return result;
        }
    }
    ,
    MIN{

        @Override
        long pick(SortedNumericDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        long pick(SortedNumericDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            long result = Long.MAX_VALUE;
            while (joinIterator.advanceValuesToNextChild()) {
                result = Math.min(result, values.nextValue());
            }
            return result;
        }

        @Override
        double pick(SortedNumericDoubleDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        double pick(SortedNumericDoubleDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            double result = Double.POSITIVE_INFINITY;
            while (joinIterator.advanceValuesToNextChild()) {
                result = Math.min(result, values.nextValue());
            }
            return result;
        }

        @Override
        long pick(SortedSetDocValues values) throws IOException {
            long ord;
            long result = Long.MAX_VALUE;
            while ((ord = values.nextOrd()) != -1L) {
                result = Math.min(result, ord);
            }
            return result;
        }

        @Override
        long pick(SortedSetDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            long result = Long.MAX_VALUE;
            while (joinIterator.advanceValuesToNextChild()) {
                long ord;
                while ((ord = values.nextOrd()) != -1L) {
                    result = Math.min(result, ord);
                }
            }
            return result;
        }
    }
    ,
    MAX{

        @Override
        long pick(SortedNumericDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            for (int index = 0; index < valueCount - 1; ++index) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        long pick(SortedNumericDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            long result = Long.MIN_VALUE;
            while (joinIterator.advanceValuesToNextChild()) {
                int valueCountForChild = values.docValueCount();
                for (int index = 0; index < valueCountForChild - 1; ++index) {
                    values.nextValue();
                }
                result = Math.max(result, values.nextValue());
            }
            return result;
        }

        @Override
        double pick(SortedNumericDoubleDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            for (int index = 0; index < valueCount - 1; ++index) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        double pick(SortedNumericDoubleDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            double result = Double.NEGATIVE_INFINITY;
            while (joinIterator.advanceValuesToNextChild()) {
                int valueCountForChild = values.docValueCount();
                for (int index = 0; index < valueCountForChild - 1; ++index) {
                    values.nextValue();
                }
                result = Math.max(result, values.nextValue());
            }
            return result;
        }

        @Override
        long pick(SortedSetDocValues values) throws IOException {
            long ord;
            long result = Long.MIN_VALUE;
            while ((ord = values.nextOrd()) != -1L) {
                result = Math.max(result, ord);
            }
            return result;
        }

        @Override
        long pick(SortedSetDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
            long returnValue = Long.MIN_VALUE;
            while (joinIterator.advanceValuesToNextChild()) {
                long ord;
                while ((ord = values.nextOrd()) != -1L) {
                    returnValue = Math.max(returnValue, ord);
                }
            }
            return returnValue;
        }
    }
    ,
    MEDIAN{

        @Override
        long pick(SortedNumericDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            for (int i = 0; i < (valueCount - 1) / 2; ++i) {
                values.nextValue();
            }
            long result = valueCount % 2 == 0 ? (values.nextValue() + values.nextValue()) / 2L : values.nextValue();
            return result;
        }

        @Override
        double pick(SortedNumericDoubleDocValues values) throws IOException {
            int valueCount = values.docValueCount();
            for (int i = 0; i < (valueCount - 1) / 2; ++i) {
                values.nextValue();
            }
            double result = valueCount % 2 == 0 ? (values.nextValue() + values.nextValue()) / 2.0 : values.nextValue();
            return result;
        }
    };


    abstract long pick(SortedNumericDocValues var1) throws IOException;

    long pick(SortedNumericDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
        throw this.unsupportedSortMode();
    }

    abstract double pick(SortedNumericDoubleDocValues var1) throws IOException;

    double pick(SortedNumericDoubleDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
        throw this.unsupportedSortMode();
    }

    long pick(SortedSetDocValues values) throws IOException {
        throw this.unsupportedSortMode();
    }

    long pick(SortedSetDocValues values, JoinChildrenIdIterator joinIterator) throws IOException {
        throw this.unsupportedSortMode();
    }

    IllegalArgumentException unsupportedSortMode() {
        return new IllegalArgumentException("Unsupported sort mode: " + (Object)((Object)this));
    }
}

