/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public interface TypeContributions {
    public TypeConfiguration getTypeConfiguration();

    default public void contributeJavaType(JavaType<?> descriptor) {
        this.getTypeConfiguration().getJavaTypeRegistry().addDescriptor(descriptor);
    }

    default public void contributeJdbcType(JdbcType descriptor) {
        this.getTypeConfiguration().getJdbcTypeRegistry().addDescriptor(descriptor);
    }

    default public <T> void contributeType(UserType<T> type) {
        this.contributeType(type, type.returnedClass().getName());
    }

    @Deprecated(since="6.0")
    default public void contributeType(BasicType<?> type) {
        this.getTypeConfiguration().getBasicTypeRegistry().register(type);
        JavaType<?> javaType = type.getJavaTypeDescriptor();
        this.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(javaType.getJavaType(), () -> javaType);
    }

    @Deprecated(since="5.3")
    default public void contributeType(BasicType<?> type, String ... keys) {
        this.getTypeConfiguration().getBasicTypeRegistry().register(type, keys);
        JavaType<?> javaType = type.getJavaTypeDescriptor();
        this.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(javaType.getJavaType(), () -> javaType);
    }

    @Deprecated(since="5.3")
    default public void contributeType(UserType<?> type, String ... keys) {
        CustomType<?> customType = this.getTypeConfiguration().getBasicTypeRegistry().register(type, keys);
        JavaType<?> javaType = customType.getJavaTypeDescriptor();
        this.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(javaType.getJavaType(), () -> javaType);
    }
}

