/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.BinderHelper;

public class AnnotatedDiscriminatorColumn
extends AnnotatedColumn {
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "DTYPE";
    public static final String DEFAULT_DISCRIMINATOR_TYPE = "string";
    private static final long DEFAULT_DISCRIMINATOR_LENGTH = 31L;
    private String discriminatorTypeName;

    public AnnotatedDiscriminatorColumn() {
        this.setLogicalColumnName(DEFAULT_DISCRIMINATOR_COLUMN_NAME);
        this.setNullable(false);
        this.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        this.setLength(31L);
    }

    public String getDiscriminatorTypeName() {
        return this.discriminatorTypeName;
    }

    public void setDiscriminatorTypeName(String discriminatorTypeName) {
        this.discriminatorTypeName = discriminatorTypeName;
    }

    public static AnnotatedDiscriminatorColumn buildDiscriminatorColumn(DiscriminatorType type, DiscriminatorColumn discAnn, DiscriminatorFormula discFormulaAnn, MetadataBuildingContext context) {
        AnnotatedDiscriminatorColumn discriminatorColumn = new AnnotatedDiscriminatorColumn();
        discriminatorColumn.setBuildingContext(context);
        discriminatorColumn.setImplicit(true);
        if (discFormulaAnn != null) {
            discriminatorColumn.setImplicit(false);
            discriminatorColumn.setFormula(discFormulaAnn.value());
        } else if (discAnn != null) {
            discriminatorColumn.setImplicit(false);
            if (!BinderHelper.isEmptyAnnotationValue(discAnn.columnDefinition())) {
                discriminatorColumn.setSqlType(discAnn.columnDefinition());
            }
            if (!BinderHelper.isEmptyAnnotationValue(discAnn.name())) {
                discriminatorColumn.setLogicalColumnName(discAnn.name());
            }
            discriminatorColumn.setNullable(false);
        }
        if (DiscriminatorType.CHAR.equals((Object)type)) {
            discriminatorColumn.setDiscriminatorTypeName("character");
            discriminatorColumn.setImplicit(false);
        } else if (DiscriminatorType.INTEGER.equals((Object)type)) {
            discriminatorColumn.setDiscriminatorTypeName("integer");
            discriminatorColumn.setImplicit(false);
        } else if (DiscriminatorType.STRING.equals((Object)type) || type == null) {
            if (discAnn != null) {
                discriminatorColumn.setLength(Long.valueOf(discAnn.length()));
            }
            discriminatorColumn.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        } else {
            throw new AssertionFailure("Unknown discriminator type: " + type);
        }
        discriminatorColumn.bind();
        return discriminatorColumn;
    }

    @Override
    public String toString() {
        return String.format("DiscriminatorColumn{logicalColumnName'%s', discriminatorTypeName='%s'}", this.getLogicalColumnName(), this.discriminatorTypeName);
    }
}

