/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Index;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.IdGeneratorStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.BasicValueBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public class BinderHelper {
    private static final Logger log = CoreLogging.logger(BinderHelper.class);
    public static final Set<String> PRIMITIVE_NAMES = Set.of(Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.TYPE.getName());

    private BinderHelper() {
    }

    public static Property shallowCopy(Property property) {
        Property clone = new Property();
        clone.setCascade(property.getCascade());
        clone.setInsertable(property.isInsertable());
        clone.setLazy(property.isLazy());
        clone.setName(property.getName());
        clone.setNaturalIdentifier(property.isNaturalIdentifier());
        clone.setOptimisticLocked(property.isOptimisticLocked());
        clone.setOptional(property.isOptional());
        clone.setPersistentClass(property.getPersistentClass());
        clone.setPropertyAccessorName(property.getPropertyAccessorName());
        clone.setSelectable(property.isSelectable());
        clone.setUpdateable(property.isUpdateable());
        clone.setValue(property.getValue());
        return clone;
    }

    public static void createSyntheticPropertyReference(AnnotatedJoinColumn[] columns, PersistentClass ownerEntity, PersistentClass associatedEntity, Value value, boolean inverse, MetadataBuildingContext context) {
        PersistentClass associatedClass;
        if (columns[0].isImplicit() || StringHelper.isNotEmpty(columns[0].getMappedBy())) {
            return;
        }
        int fkEnum = AnnotatedJoinColumn.checkReferencedColumnsType(columns, ownerEntity, context);
        PersistentClass persistentClass = associatedClass = columns[0].getPropertyHolder() != null ? columns[0].getPropertyHolder().getPersistentClass() : null;
        if (2 == fkEnum) {
            Component embeddedComp;
            String syntheticPropertyName = "_" + associatedClass.getEntityName().replace('.', '_') + "_" + columns[0].getPropertyName().replace('.', '_');
            Object columnOwner = BinderHelper.findColumnOwner(ownerEntity, columns[0].getReferencedColumn(), context);
            List<Property> properties = BinderHelper.findPropertiesByColumns(columnOwner, columns, context);
            if (properties != null) {
                embeddedComp = columnOwner instanceof PersistentClass ? new Component(context, (PersistentClass)columnOwner) : new Component(context, (Join)columnOwner);
                embeddedComp.setEmbedded(true);
                embeddedComp.setComponentClassName(embeddedComp.getOwner().getClassName());
                for (Property property : properties) {
                    Property clone = BinderHelper.shallowCopy(property);
                    clone.setInsertable(false);
                    clone.setUpdateable(false);
                    clone.setNaturalIdentifier(false);
                    clone.setValueGenerationStrategy(property.getValueGenerationStrategy());
                    embeddedComp.addProperty(clone);
                }
            } else {
                StringBuilder columnsList = new StringBuilder();
                columnsList.append("referencedColumnNames(");
                for (AnnotatedJoinColumn column : columns) {
                    columnsList.append(column.getReferencedColumn()).append(", ");
                }
                columnsList.setLength(columnsList.length() - 2);
                columnsList.append(") ");
                if (associatedEntity != null) {
                    columnsList.append("of ").append(associatedEntity.getEntityName()).append(".").append(columns[0].getPropertyName()).append(" ");
                } else if (columns[0].getPropertyHolder() != null) {
                    columnsList.append("of ").append(columns[0].getPropertyHolder().getEntityName()).append(".").append(columns[0].getPropertyName()).append(" ");
                }
                columnsList.append("referencing ").append(ownerEntity.getEntityName()).append(" not mapped to a single property");
                throw new AnnotationException(columnsList.toString());
            }
            embeddedComp.sortProperties();
            SyntheticProperty synthProp = new SyntheticProperty();
            synthProp.setName(syntheticPropertyName);
            synthProp.setPersistentClass(ownerEntity);
            synthProp.setUpdateable(false);
            synthProp.setInsertable(false);
            synthProp.setValue(embeddedComp);
            synthProp.setPropertyAccessorName("embedded");
            ownerEntity.addProperty(synthProp);
            embeddedComp.createUniqueKey();
            if (value instanceof ToOne) {
                ((ToOne)value).setReferencedPropertyName(syntheticPropertyName);
                ((ToOne)value).setReferenceToPrimaryKey(false);
                context.getMetadataCollector().addUniquePropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
            } else if (value instanceof Collection) {
                ((Collection)value).setReferencedPropertyName(syntheticPropertyName);
                context.getMetadataCollector().addPropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
            } else {
                throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
            }
            context.getMetadataCollector().addPropertyReferencedAssociation((inverse ? "inverse__" : "") + associatedClass.getEntityName(), columns[0].getPropertyName(), syntheticPropertyName);
        }
    }

    private static List<Property> findPropertiesByColumns(Object columnOwner, AnnotatedJoinColumn[] columns, MetadataBuildingContext context) {
        Table referencedTable;
        HashMap<org.hibernate.mapping.Column, Set<Property>> columnsToProperty = new HashMap<org.hibernate.mapping.Column, Set<Property>>();
        ArrayList<org.hibernate.mapping.Column> orderedColumns = new ArrayList<org.hibernate.mapping.Column>(columns.length);
        if (columnOwner instanceof PersistentClass) {
            referencedTable = ((PersistentClass)columnOwner).getTable();
        } else if (columnOwner instanceof Join) {
            referencedTable = ((Join)columnOwner).getTable();
        } else {
            throw new AssertionFailure((String)(columnOwner == null ? "columnOwner is null" : "columnOwner neither PersistentClass nor Join: " + columnOwner.getClass()));
        }
        for (AnnotatedJoinColumn column1 : columns) {
            org.hibernate.mapping.Column column = new org.hibernate.mapping.Column(context.getMetadataCollector().getPhysicalColumnName(referencedTable, column1.getReferencedColumn()));
            orderedColumns.add(column);
            columnsToProperty.put(column, new HashSet());
        }
        boolean isPersistentClass = columnOwner instanceof PersistentClass;
        List<Property> properties = isPersistentClass ? ((PersistentClass)columnOwner).getProperties() : ((Join)columnOwner).getProperties();
        for (Property property : properties) {
            BinderHelper.matchColumnsByProperty(property, columnsToProperty);
        }
        if (isPersistentClass) {
            BinderHelper.matchColumnsByProperty(((PersistentClass)columnOwner).getIdentifierProperty(), columnsToProperty);
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        for (org.hibernate.mapping.Column column : orderedColumns) {
            boolean found = false;
            for (Property property : (Set)columnsToProperty.get(column)) {
                if (property.getColumnSpan() != 1) continue;
                orderedProperties.add(property);
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return orderedProperties;
    }

    private static void matchColumnsByProperty(Property property, Map<org.hibernate.mapping.Column, Set<Property>> columnsToProperty) {
        if (property == null) {
            return;
        }
        if ("noop".equals(property.getPropertyAccessorName()) || "embedded".equals(property.getPropertyAccessorName())) {
            return;
        }
        for (Selectable selectable : property.getSelectables()) {
            if (!columnsToProperty.containsKey(selectable)) continue;
            columnsToProperty.get(selectable).add(property);
        }
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.length() == 0 || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static Property findPropertyByName(Component component, String propertyName) {
        Property property = null;
        try {
            if (propertyName == null || propertyName.length() == 0) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(propertyName, ".", false);
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                if (property == null) {
                    property = component.getProperty(element);
                    continue;
                }
                if (!property.isComposite()) {
                    return null;
                }
                property = ((Component)property.getValue()).getProperty(element);
            }
        }
        catch (MappingException e) {
            try {
                if (component.getOwner().getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = component.getOwner().getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static String getRelativePath(PropertyHolder propertyHolder, String propertyName) {
        if (propertyHolder == null) {
            return propertyName;
        }
        String path = propertyHolder.getPath();
        String entityName = propertyHolder.getPersistentClass().getEntityName();
        if (path.length() == entityName.length()) {
            return propertyName;
        }
        return StringHelper.qualify(path.substring(entityName.length() + 1), propertyName);
    }

    public static Object findColumnOwner(PersistentClass persistentClass, String columnName, MetadataBuildingContext context) {
        AttributeContainer result;
        if (StringHelper.isEmpty(columnName)) {
            return persistentClass;
        }
        PersistentClass current = persistentClass;
        boolean found = false;
        do {
            result = current;
            Table currentTable = current.getTable();
            try {
                context.getMetadataCollector().getPhysicalColumnName(currentTable, columnName);
                found = true;
            }
            catch (MappingException mappingException) {
                // empty catch block
            }
            Iterator<Join> joins = current.getJoinIterator();
            while (!found && joins.hasNext()) {
                result = joins.next();
                currentTable = ((Join)result).getTable();
                try {
                    context.getMetadataCollector().getPhysicalColumnName(currentTable, columnName);
                    found = true;
                }
                catch (MappingException mappingException) {}
            }
            current = current.getSuperclass();
        } while (!found && current != null);
        return found ? result : null;
    }

    public static void makeIdGenerator(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext, Map<String, IdentifierGeneratorDefinition> localGenerators) {
        log.debugf("#makeIdGenerator(%s, %s, %s, %s, ...)", new Object[]{id, idXProperty, generatorType, generatorName});
        Table table = id.getTable();
        table.setIdentifierValue(id);
        id.setIdentifierGeneratorStrategy(generatorType);
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        if (id.getColumnSpan() == 1) {
            params.setProperty("target_column", id.getColumns().get(0).getName());
        }
        params.put("identifier_normalizer", buildingContext.getObjectNameNormalizer());
        params.put("GENERATOR_NAME", generatorName);
        if (!BinderHelper.isEmptyAnnotationValue(generatorName)) {
            boolean avoidOverriding;
            IdentifierGeneratorDefinition gen = BinderHelper.getIdentifierGenerator(generatorName, idXProperty, localGenerators, buildingContext);
            if (gen == null) {
                throw new AnnotationException("Unknown named generator (@GeneratedValue#generatorName): " + generatorName);
            }
            String identifierGeneratorStrategy = gen.getStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("seqhilo");
            if (generatorType == null || !avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
            }
            for (Map.Entry<String, String> elt : gen.getParameters().entrySet()) {
                if (elt.getKey() == null) continue;
                params.setProperty(elt.getKey(), elt.getValue());
            }
        }
        if ("assigned".equals(generatorType)) {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorProperties(params);
    }

    public static void makeIdGenerator(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext, IdentifierGeneratorDefinition foreignKGeneratorDefinition) {
        HashMap<String, IdentifierGeneratorDefinition> localIdentifiers = null;
        if (foreignKGeneratorDefinition != null) {
            localIdentifiers = new HashMap<String, IdentifierGeneratorDefinition>();
            localIdentifiers.put(foreignKGeneratorDefinition.getName(), foreignKGeneratorDefinition);
        }
        BinderHelper.makeIdGenerator(id, idXProperty, generatorType, generatorName, buildingContext, localIdentifiers);
    }

    private static IdentifierGeneratorDefinition getIdentifierGenerator(final String name, final XProperty idXProperty, Map<String, IdentifierGeneratorDefinition> localGenerators, final MetadataBuildingContext buildingContext) {
        IdentifierGeneratorDefinition result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        IdentifierGeneratorDefinition globalDefinition = buildingContext.getMetadataCollector().getIdentifierGenerator(name);
        if (globalDefinition != null) {
            return globalDefinition;
        }
        log.debugf("Could not resolve explicit IdentifierGeneratorDefinition - using implicit interpretation (%s)", (Object)name);
        final GeneratedValue generatedValueAnn = (GeneratedValue)idXProperty.getAnnotation(GeneratedValue.class);
        if (generatedValueAnn == null) {
            return new IdentifierGeneratorDefinition("assigned", "assigned");
        }
        IdGeneratorStrategyInterpreter generationInterpreter = buildingContext.getBuildingOptions().getIdGenerationTypeInterpreter();
        GenerationType generationType = BinderHelper.interpretGenerationType(generatedValueAnn);
        if (generationType == null || generationType == GenerationType.SEQUENCE) {
            log.debugf("Building implicit sequence-based IdentifierGeneratorDefinition (%s)", (Object)name);
            IdentifierGeneratorDefinition.Builder builder = new IdentifierGeneratorDefinition.Builder();
            generationInterpreter.interpretSequenceGenerator(new SequenceGenerator(){

                public String name() {
                    return name;
                }

                public String sequenceName() {
                    return "";
                }

                public String catalog() {
                    return "";
                }

                public String schema() {
                    return "";
                }

                public int initialValue() {
                    return 1;
                }

                public int allocationSize() {
                    return 50;
                }

                public Class<? extends Annotation> annotationType() {
                    return SequenceGenerator.class;
                }
            }, builder);
            return builder.build();
        }
        if (generationType == GenerationType.TABLE) {
            log.debugf("Building implicit table-based IdentifierGeneratorDefinition (%s)", (Object)name);
            IdentifierGeneratorDefinition.Builder builder = new IdentifierGeneratorDefinition.Builder();
            generationInterpreter.interpretTableGenerator(new TableGenerator(){

                public String name() {
                    return name;
                }

                public String table() {
                    return "";
                }

                public int initialValue() {
                    return 0;
                }

                public int allocationSize() {
                    return 50;
                }

                public String catalog() {
                    return "";
                }

                public String schema() {
                    return "";
                }

                public String pkColumnName() {
                    return "";
                }

                public String valueColumnName() {
                    return "";
                }

                public String pkColumnValue() {
                    return "";
                }

                public UniqueConstraint[] uniqueConstraints() {
                    return new UniqueConstraint[0];
                }

                public Index[] indexes() {
                    return new Index[0];
                }

                public Class<? extends Annotation> annotationType() {
                    return TableGenerator.class;
                }
            }, builder);
            return builder.build();
        }
        String strategyName = generationType == GenerationType.IDENTITY ? "identity" : generationInterpreter.determineGeneratorName(generationType, new IdGeneratorStrategyInterpreter.GeneratorNameDeterminationContext(){

            @Override
            public Class<?> getIdType() {
                return buildingContext.getBootstrapContext().getReflectionManager().toClass(idXProperty.getType());
            }

            @Override
            public String getGeneratedValueGeneratorName() {
                return generatedValueAnn.generator();
            }
        });
        log.debugf("Building implicit generic IdentifierGeneratorDefinition (%s) : %s", (Object)name, (Object)strategyName);
        return new IdentifierGeneratorDefinition(name, strategyName, Collections.singletonMap("GENERATOR_NAME", name));
    }

    private static GenerationType interpretGenerationType(GeneratedValue generatedValueAnn) {
        if (generatedValueAnn.strategy() == null) {
            return GenerationType.AUTO;
        }
        return generatedValueAnn.strategy();
    }

    public static boolean isEmptyAnnotationValue(String annotationString) {
        return annotationString != null && annotationString.length() == 0;
    }

    public static boolean isEmptyOrNullAnnotationValue(String annotationString) {
        return annotationString == null || annotationString.length() == 0;
    }

    public static String getAnnotationValueStringOrNull(String value) {
        return BinderHelper.isEmptyOrNullAnnotationValue(value) ? null : value;
    }

    public static Any buildAnyValue(Column discriminatorColumn, Formula discriminatorFormula, AnnotatedJoinColumn[] keyColumns, PropertyData inferredData, boolean cascadeOnDelete, boolean lazy, Nullability nullability, PropertyHolder propertyHolder, EntityBinder entityBinder, boolean optional, MetadataBuildingContext context) {
        XProperty xProperty = inferredData.getProperty();
        Any value = new Any(context, keyColumns[0].getTable(), true);
        value.setLazy(lazy);
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        BasicValueBinder discriminatorValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_DISCRIMINATOR, context);
        AnnotatedColumn[] discriminatorColumns = AnnotatedColumn.buildColumnOrFormulaFromAnnotation(discriminatorColumn, discriminatorFormula, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), context);
        assert (discriminatorColumns.length == 1);
        discriminatorColumns[0].setTable(value.getTable());
        discriminatorValueBinder.setColumns(discriminatorColumns);
        discriminatorValueBinder.setReturnedClassName(inferredData.getTypeName());
        discriminatorValueBinder.setType(xProperty, xProperty.getType(), null, null);
        BasicValue discriminatorDescriptor = discriminatorValueBinder.make();
        value.setDiscriminator(discriminatorDescriptor);
        discriminatorValueBinder.fillSimpleValue();
        discriminatorColumns[0].linkWithValue(discriminatorDescriptor);
        JavaType<?> discriminatorJavaType = discriminatorDescriptor.resolve().getRelationalJavaType();
        HashMap discriminatorValueMappings = new HashMap();
        BinderHelper.processAnyDiscriminatorValues(inferredData.getProperty(), valueMapping -> discriminatorValueMappings.put(discriminatorJavaType.wrap(valueMapping.discriminator(), null), valueMapping.entity()));
        value.setDiscriminatorValueMappings(discriminatorValueMappings);
        BasicValueBinder keyValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_KEY, context);
        assert (keyColumns.length == 1);
        keyColumns[0].setTable(value.getTable());
        keyValueBinder.setColumns(keyColumns);
        if (!optional) {
            for (AnnotatedJoinColumn column : keyColumns) {
                column.setNullable(false);
            }
        }
        keyValueBinder.setType(xProperty, xProperty.getType(), null, null);
        BasicValue keyDescriptor = keyValueBinder.make();
        value.setKey(keyDescriptor);
        keyValueBinder.fillSimpleValue();
        AnnotatedColumn.checkPropertyConsistency(keyColumns, propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
        keyColumns[0].linkWithValue(keyDescriptor);
        return value;
    }

    private static void processAnyDiscriminatorValues(XProperty property, Consumer<AnyDiscriminatorValue> consumer) {
        AnyDiscriminatorValue[] valueAnns;
        AnyDiscriminatorValue valueAnn = (AnyDiscriminatorValue)property.getAnnotation(AnyDiscriminatorValue.class);
        if (valueAnn != null) {
            consumer.accept(valueAnn);
            return;
        }
        AnyDiscriminatorValues valuesAnn = (AnyDiscriminatorValues)property.getAnnotation(AnyDiscriminatorValues.class);
        if (valuesAnn != null && (valueAnns = valuesAnn.value()) != null && valueAnns.length > 0) {
            for (AnyDiscriminatorValue ann : valueAnns) {
                consumer.accept(ann);
            }
        }
    }

    public static MappedSuperclass getMappedSuperclassOrNull(XClass declaringClass, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) {
        boolean retrieve = false;
        if (declaringClass != null) {
            InheritanceState inheritanceState = inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + declaringClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                retrieve = true;
            }
        }
        if (retrieve) {
            return context.getMetadataCollector().getMappedSuperclass(context.getBootstrapContext().getReflectionManager().toClass(declaringClass));
        }
        return null;
    }

    public static String getPath(PropertyHolder holder, PropertyData property) {
        return StringHelper.qualify(holder.getPath(), property.getPropertyName());
    }

    static PropertyData getPropertyOverriddenByMapperOrMapsId(boolean isId, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        XClass persistentXClass = buildingContext.getBootstrapContext().getReflectionManager().toXClass(propertyHolder.getPersistentClass().getMappedClass());
        if (propertyHolder.isInIdClass()) {
            PropertyData pd = buildingContext.getMetadataCollector().getPropertyAnnotatedWithIdAndToOne(persistentXClass, propertyName);
            if (pd == null && buildingContext.getBuildingOptions().isSpecjProprietarySyntaxEnabled()) {
                pd = buildingContext.getMetadataCollector().getPropertyAnnotatedWithMapsId(persistentXClass, propertyName);
            }
            return pd;
        }
        return buildingContext.getMetadataCollector().getPropertyAnnotatedWithMapsId(persistentXClass, isId ? "" : propertyName);
    }

    public static Map<String, String> toAliasTableMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SqlFragmentAlias aliase : aliases) {
            if (!StringHelper.isNotEmpty(aliase.table())) continue;
            ret.put(aliase.alias(), aliase.table());
        }
        return ret;
    }

    public static Map<String, String> toAliasEntityMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SqlFragmentAlias aliase : aliases) {
            if (aliase.entity() == Void.TYPE) continue;
            ret.put(aliase.alias(), aliase.entity().getName());
        }
        return ret;
    }
}

