/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public class InflightRuntimeMetamodel {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(InflightRuntimeMetamodel.class);
    private final TypeConfiguration typeConfiguration;
    private final Map<String, EntityPersister> entityPersisterMap = new ConcurrentHashMap<String, EntityPersister>();
    private final Map<Class, String> entityProxyInterfaceMap = new ConcurrentHashMap<Class, String>();
    private final Map<String, CollectionPersister> collectionPersisterMap = new ConcurrentHashMap<String, CollectionPersister>();
    private final Map<String, Set<String>> collectionRolesByEntityParticipant = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, String> nameToImportNameMap = new HashMap<String, String>();
    private final Set<EntityNameResolver> entityNameResolvers = new CopyOnWriteArraySet<EntityNameResolver>();
    private final Map<String, String> imports = new ConcurrentHashMap<String, String>();

    public InflightRuntimeMetamodel(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public void processBootMetaModel(MetadataImplementor bootMetamodel, CacheImplementor cacheImplementor, PersisterFactory persisterFactory, RuntimeModelCreationContext modelCreationContext) {
        this.imports.putAll(bootMetamodel.getImports());
        this.processBootEntities(bootMetamodel.getEntityBindings(), cacheImplementor, persisterFactory, modelCreationContext);
        this.processBootCollections(bootMetamodel.getCollectionBindings(), cacheImplementor, persisterFactory, modelCreationContext);
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public Map<String, EntityPersister> getEntityPersisterMap() {
        return this.entityPersisterMap;
    }

    public Map<Class, String> getEntityProxyInterfaceMap() {
        return this.entityProxyInterfaceMap;
    }

    public Map<String, CollectionPersister> getCollectionPersisterMap() {
        return this.collectionPersisterMap;
    }

    public Map<String, Set<String>> getCollectionRolesByEntityParticipant() {
        return this.collectionRolesByEntityParticipant;
    }

    public Map<String, String> getNameToImportNameMap() {
        return this.nameToImportNameMap;
    }

    public Set<EntityNameResolver> getEntityNameResolvers() {
        return this.entityNameResolvers;
    }

    public EntityPersister getEntityDescriptor(String entityName) {
        EntityPersister entityPersister = this.entityPersisterMap.get(entityName);
        if (entityPersister == null) {
            throw new IllegalArgumentException("Unable to locate persister: " + entityName);
        }
        return entityPersister;
    }

    public EntityPersister findEntityDescriptor(String entityName) {
        return this.entityPersisterMap.get(entityName);
    }

    private void processBootEntities(Collection<PersistentClass> entityBindings, CacheImplementor cacheImplementor, PersisterFactory persisterFactory, RuntimeModelCreationContext modelCreationContext) {
        for (PersistentClass model : entityBindings) {
            NavigableRole rootEntityRole = new NavigableRole(model.getRootClass().getEntityName());
            EntityDataAccess accessStrategy = cacheImplementor.getEntityRegionAccess(rootEntityRole);
            NaturalIdDataAccess naturalIdAccessStrategy = cacheImplementor.getNaturalIdCacheRegionAccessStrategy(rootEntityRole);
            EntityPersister cp = persisterFactory.createEntityPersister(model, accessStrategy, naturalIdAccessStrategy, modelCreationContext);
            this.entityPersisterMap.put(model.getEntityName(), cp);
            if (cp.getConcreteProxyClass() == null || !cp.getConcreteProxyClass().isInterface() || Map.class.isAssignableFrom(cp.getConcreteProxyClass()) || cp.getMappedClass() == cp.getConcreteProxyClass()) continue;
            if (cp.getMappedClass().equals(cp.getConcreteProxyClass())) {
                if (!log.isDebugEnabled()) continue;
                log.debugf("Entity [%s] mapped same interface [%s] as class and proxy", cp.getEntityName(), cp.getMappedClass());
                continue;
            }
            String old = this.entityProxyInterfaceMap.put(cp.getConcreteProxyClass(), cp.getEntityName());
            if (old == null) continue;
            throw new HibernateException(String.format(Locale.ENGLISH, "Multiple entities [%s, %s] named the same interface [%s] as their proxy which is not supported", old, cp.getEntityName(), cp.getConcreteProxyClass().getName()));
        }
    }

    private void processBootCollections(Collection<org.hibernate.mapping.Collection> collectionBindings, CacheImplementor cacheImplementor, PersisterFactory persisterFactory, PersisterCreationContext persisterCreationContext) {
        for (org.hibernate.mapping.Collection model : collectionBindings) {
            Type elementType;
            NavigableRole navigableRole = new NavigableRole(model.getRole());
            CollectionDataAccess accessStrategy = cacheImplementor.getCollectionRegionAccess(navigableRole);
            CollectionPersister persister = persisterFactory.createCollectionPersister(model, accessStrategy, persisterCreationContext);
            this.collectionPersisterMap.put(model.getRole(), persister);
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isEntityType() && !indexType.isAnyType()) {
                String entityName = ((EntityType)indexType).getAssociatedEntityName();
                Set<String> roles = this.collectionRolesByEntityParticipant.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    this.collectionRolesByEntityParticipant.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isEntityType() || elementType.isAnyType()) continue;
            String entityName = ((EntityType)elementType).getAssociatedEntityName();
            Set<String> roles = this.collectionRolesByEntityParticipant.get(entityName);
            if (roles == null) {
                roles = new HashSet<String>();
                this.collectionRolesByEntityParticipant.put(entityName, roles);
            }
            roles.add(persister.getRole());
        }
    }

    public Map<String, String> getImports() {
        return this.imports;
    }
}

