/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class MappingModelHelper {
    private MappingModelHelper() {
    }

    public static Expression buildColumnReferenceExpression(ModelPart modelPart, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        return MappingModelHelper.buildColumnReferenceExpression(null, modelPart, sqlExpressionResolver, sessionFactory);
    }

    public static Expression buildColumnReferenceExpression(TableGroup tableGroup, ModelPart modelPart, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        int jdbcTypeCount = modelPart.getJdbcTypeCount();
        if (modelPart instanceof EmbeddableValuedModelPart) {
            ArrayList columnReferences = new ArrayList(jdbcTypeCount);
            modelPart.forEachSelectable((columnIndex, selection) -> {
                String qualifier = tableGroup == null ? selection.getContainingTableExpression() : tableGroup.resolveTableReference(selection.getContainingTableExpression()).getIdentificationVariable();
                ColumnReference colRef = sqlExpressionResolver == null ? new ColumnReference(qualifier, selection, sessionFactory) : (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(qualifier, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(qualifier, selection, sessionFactory));
                columnReferences.add(colRef);
            });
            return new SqlTuple(columnReferences, modelPart);
        }
        assert (modelPart instanceof BasicValuedModelPart);
        BasicValuedModelPart basicPart = (BasicValuedModelPart)modelPart;
        String qualifier = tableGroup == null ? basicPart.getContainingTableExpression() : tableGroup.resolveTableReference(basicPart.getContainingTableExpression()).getIdentificationVariable();
        if (sqlExpressionResolver == null) {
            return new ColumnReference(qualifier, (SelectableMapping)basicPart, sessionFactory);
        }
        return sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(qualifier, basicPart.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(qualifier, (SelectableMapping)basicPart, sessionFactory));
    }

    public static boolean isCompatibleModelPart(ModelPart attribute1, ModelPart attribute2) {
        if (attribute1 == attribute2) {
            return true;
        }
        if (attribute1.getClass() != attribute2.getClass() || attribute1.getJavaType() != attribute2.getJavaType()) {
            return false;
        }
        if (attribute1 instanceof Association) {
            Association association1 = (Association)attribute1;
            Association association2 = (Association)attribute2;
            return association1.getForeignKeyDescriptor().getAssociationKey().equals(association2.getForeignKeyDescriptor().getAssociationKey());
        }
        if (attribute1 instanceof PluralAttributeMapping) {
            PluralAttributeMapping plural1 = (PluralAttributeMapping)attribute1;
            PluralAttributeMapping plural2 = (PluralAttributeMapping)attribute2;
            CollectionPart element1 = plural1.getElementDescriptor();
            CollectionPart element2 = plural2.getElementDescriptor();
            CollectionPart index1 = plural1.getIndexDescriptor();
            CollectionPart index2 = plural2.getIndexDescriptor();
            return plural1.getKeyDescriptor().getAssociationKey().equals(plural2.getKeyDescriptor().getAssociationKey()) && (index1 == null && index2 == null || MappingModelHelper.isCompatibleModelPart(index1, index2)) && MappingModelHelper.isCompatibleModelPart(element1, element2);
        }
        if (attribute1 instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embedded1 = (EmbeddableValuedModelPart)attribute1;
            EmbeddableValuedModelPart embedded2 = (EmbeddableValuedModelPart)attribute2;
            List<AttributeMapping> attrs1 = embedded1.getEmbeddableTypeDescriptor().getAttributeMappings();
            List<AttributeMapping> attrs2 = embedded2.getEmbeddableTypeDescriptor().getAttributeMappings();
            if (attrs1.size() != attrs2.size()) {
                return false;
            }
            for (int i = 0; i < attrs1.size(); ++i) {
                if (MappingModelHelper.isCompatibleModelPart(attrs1.get(i), attrs2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (attribute1 instanceof BasicValuedModelPart) {
            BasicValuedModelPart basic1 = (BasicValuedModelPart)attribute1;
            BasicValuedModelPart basic2 = (BasicValuedModelPart)attribute2;
            if (!basic1.getSelectionExpression().equals(basic2.getSelectionExpression())) {
                return false;
            }
            if (basic1.getContainingTableExpression().equals(basic2.getContainingTableExpression())) {
                return true;
            }
            return attribute1.findContainingEntityMapping().getEntityPersister() instanceof UnionSubclassEntityPersister;
        }
        return false;
    }
}

