/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadataAccess;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractEmbeddableMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.IdClassRepresentationStrategy;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.internal.VirtualIdEmbeddable;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class IdClassEmbeddable
extends AbstractEmbeddableMapping
implements NonAggregatedIdentifierMapping.IdentifierValueMapper {
    private final NavigableRole navigableRole;
    private final NonAggregatedIdentifierMapping idMapping;
    private final VirtualIdEmbeddable virtualIdEmbeddable;
    private final JavaType<?> javaType;
    private final IdClassRepresentationStrategy representationStrategy;
    private final EmbeddableValuedModelPart embedded;
    private final List<SingularAttributeMapping> attributeMappings;
    private SelectableMappings selectableMappings;

    public IdClassEmbeddable(Component idClassSource, RootClass bootEntityDescriptor, NonAggregatedIdentifierMapping idMapping, EntityMappingType identifiedEntityMapping, String idTable, String[] idColumns, VirtualIdEmbeddable virtualIdEmbeddable, MappingModelCreationProcess creationProcess) {
        super(creationProcess);
        this.navigableRole = idMapping.getNavigableRole().append("_identifierMapper");
        this.idMapping = idMapping;
        this.virtualIdEmbeddable = virtualIdEmbeddable;
        this.javaType = this.sessionFactory.getTypeConfiguration().getJavaTypeRegistry().resolveManagedTypeDescriptor(idClassSource.getComponentClass());
        this.representationStrategy = new IdClassRepresentationStrategy(this);
        this.attributeMappings = CollectionHelper.arrayList(idClassSource.getPropertySpan());
        PropertyAccess propertyAccess = PropertyAccessStrategyMapImpl.INSTANCE.buildPropertyAccess((Class)null, "{id}", true);
        AttributeMetadataAccess attributeMetadataAccess = MappingModelCreationHelper.getAttributeMetadataAccess(propertyAccess);
        this.embedded = new EmbeddedAttributeMapping("_identifierMapper", identifiedEntityMapping.getNavigableRole().append("{id}").append("_identifierMapper"), -1, idTable, attributeMetadataAccess, (PropertyAccess)null, FetchTiming.IMMEDIATE, FetchStyle.JOIN, (EmbeddableMappingType)this, (ManagedMappingType)identifiedEntityMapping, propertyAccess, null);
        CompositeType idClassType = (CompositeType)idClassSource.getType();
        ((CompositeTypeImplementor)idClassType).injectMappingModelPart(this.embedded, creationProcess);
        creationProcess.registerInitializationCallback("IdClassEmbeddable(" + this.navigableRole.getFullPath() + ")#finishInitialization", () -> this.finishInitialization(idClassSource, idClassType, idTable, idColumns, creationProcess));
    }

    public IdClassEmbeddable(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, IdClassEmbeddable inverseMappingType, MappingModelCreationProcess creationProcess) {
        super(creationProcess);
        this.navigableRole = inverseMappingType.getNavigableRole();
        this.idMapping = (NonAggregatedIdentifierMapping)((Object)valueMapping);
        this.virtualIdEmbeddable = (VirtualIdEmbeddable)valueMapping.getEmbeddableTypeDescriptor();
        this.javaType = inverseMappingType.javaType;
        this.representationStrategy = new IdClassRepresentationStrategy(this);
        this.attributeMappings = CollectionHelper.arrayList(inverseMappingType.attributeMappings.size());
        this.embedded = valueMapping;
        this.selectableMappings = selectableMappings;
        creationProcess.registerInitializationCallback("IdClassEmbeddable(" + inverseMappingType.getNavigableRole().getFullPath() + ".{inverse})#finishInitialization", () -> IdClassEmbeddable.inverseInitializeCallback(declaringTableGroupProducer, selectableMappings, inverseMappingType, creationProcess, valueMapping.getDeclaringType(), this.attributeMappings));
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedPart() {
        return this.embedded;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        Object id = this.representationStrategy.getInstantiator().instantiate(null, this.sessionFactory);
        List<AttributeMapping> virtualIdAttribute = this.virtualIdEmbeddable.getAttributeMappings();
        List<AttributeMapping> idClassAttribute = this.getAttributeMappings();
        Object[] propertyValues = new Object[virtualIdAttribute.size()];
        for (int i = 0; i < propertyValues.length; ++i) {
            AttributeMapping attributeMapping = virtualIdAttribute.get(i);
            Object o = attributeMapping.getPropertyAccess().getGetter().get(entity);
            if (o == null) {
                AttributeMapping idClassAttributeMapping = idClassAttribute.get(i);
                if (idClassAttributeMapping.getPropertyAccess().getGetter().getReturnTypeClass().isPrimitive()) {
                    propertyValues[i] = idClassAttributeMapping.getExpressibleJavaType().getDefaultValue();
                    continue;
                }
                propertyValues[i] = null;
                continue;
            }
            if (attributeMapping instanceof ToOneAttributeMapping && !(idClassAttribute.get(i) instanceof ToOneAttributeMapping)) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                ModelPart targetPart = toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature().inverse());
                if (targetPart instanceof EntityIdentifierMapping) {
                    propertyValues[i] = ((EntityIdentifierMapping)targetPart).getIdentifier(o);
                    continue;
                }
                propertyValues[i] = o;
                assert (false);
                continue;
            }
            propertyValues[i] = o;
        }
        this.setValues(id, propertyValues);
        return id;
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        EntityPersister entityDescriptor = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entity.getClass());
        Object[] propertyValues = new Object[this.attributeMappings.size()];
        this.virtualIdEmbeddable.forEachAttribute((position, virtualIdAttribute) -> {
            AttributeMapping idClassAttribute = this.attributeMappings.get(position);
            Object o = idClassAttribute.getPropertyAccess().getGetter().get(id);
            if (virtualIdAttribute instanceof ToOneAttributeMapping && !(idClassAttribute instanceof ToOneAttributeMapping)) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)virtualIdAttribute;
                EntityPersister entityPersister = toOneAttributeMapping.getEntityMappingType().getEntityPersister();
                EntityKey entityKey = session.generateEntityKey(o, entityPersister);
                PersistenceContext persistenceContext = session.getPersistenceContext();
                propertyValues[position] = persistenceContext.getProxy(entityKey);
                if (propertyValues[position] == null) {
                    propertyValues[position] = persistenceContext.getEntity(entityKey);
                    if (propertyValues[position] == null) {
                        propertyValues[position] = entityDescriptor.getPropertyValue(entity, toOneAttributeMapping.getAttributeName());
                    }
                }
            } else {
                propertyValues[position] = o;
            }
        });
        this.virtualIdEmbeddable.setValues(entity, propertyValues);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getPartName() {
        return "_identifierMapper";
    }

    @Override
    public EmbeddableRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.javaType;
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.embedded;
    }

    @Override
    public int getNumberOfAttributeMappings() {
        return this.attributeMappings.size();
    }

    @Override
    public AttributeMapping getAttributeMapping(int position) {
        return this.attributeMappings.get(position);
    }

    @Override
    public boolean isCreateEmptyCompositesEnabled() {
        return false;
    }

    @Override
    public SingularAttributeMapping findAttributeMapping(String name) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            SingularAttributeMapping attribute = this.attributeMappings.get(i);
            if (!attribute.getAttributeName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public List<AttributeMapping> getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    public void visitAttributeMappings(Consumer<? super AttributeMapping> action) {
        this.forEachAttribute((index, attribute) -> action.accept((AttributeMapping)attribute));
    }

    @Override
    public void forEachAttributeMapping(IndexedConsumer<AttributeMapping> consumer) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            consumer.accept(i, this.attributeMappings.get(i));
        }
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getNumberOfAttributeMappings();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.idMapping.findContainingEntityMapping();
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.attributeMappings.forEach(consumer);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            SingularAttributeMapping attribute = this.attributeMappings.get(i);
            if (!attribute.getAttributeName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.attributeMappings.forEach(attribute -> {
            Object attributeValue = attribute.getValue(domainValue);
            attribute.breakDownJdbcValues(attributeValue, valueConsumer, session);
        });
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.selectableMappings.getSelectable(columnIndex);
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return this.selectableMappings.forEachSelectable(0, consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.selectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public int getJdbcTypeCount() {
        return this.selectableMappings.getJdbcTypeCount();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return this.selectableMappings.getJdbcMappings();
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            if (attributeMapping instanceof PluralAttributeMapping) continue;
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            span += attributeMapping.forEachJdbcValue(o, clause, span + offset, valuesConsumer, session);
        }
        return span;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        List<AttributeMapping> attributeMappings = this.getAttributeMappings();
        Object[] result = new Object[attributeMappings.size()];
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = attributeMappings.get(i);
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            result[i] = attributeMapping.disassemble(o, session);
        }
        return result;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.selectableMappings.forEachSelectable(offset, (index, selectable) -> action.accept(index, selectable.getJdbcMapping()));
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public EmbeddableMappingType createInverseMappingType(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new IdClassEmbeddable(valueMapping, declaringTableGroupProducer, selectableMappings, this, creationProcess);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, MappingModelCreationProcess creationProcess) {
        this.attributeMappings.clear();
        return IdClassEmbeddable.finishInitialization(this.navigableRole, bootDescriptor, compositeType, rootTableExpression, rootTableKeyColumnNames, this, this.representationStrategy, (attributeName, attributeType) -> {
            if (attributeType instanceof CollectionType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("An IdClass cannot define collection attributes : " + attributeName);
            }
            if (attributeType instanceof AnyType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("An IdClass cannot define <any/> attributes : " + attributeName);
            }
        }, (column, jdbcEnvironment) -> MappingModelCreationHelper.getTableIdentifierExpression(column.getValue().getTable(), creationProcess), this::addAttribute, () -> creationProcess.registerInitializationCallback("IdClassEmbeddable(" + this.getNavigableRole() + ")#initColumnMappings", this::initColumnMappings), creationProcess);
    }

    private boolean initColumnMappings() {
        this.selectableMappings = SelectableMappingsImpl.from(this);
        return true;
    }

    private void addAttribute(AttributeMapping attributeMapping) {
        this.addAttribute((SingularAttributeMapping)attributeMapping);
    }

    private void addAttribute(SingularAttributeMapping attributeMapping) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping previous = this.attributeMappings.get(i);
            if (!attributeMapping.getAttributeName().equals(previous.getAttributeName())) continue;
            this.attributeMappings.set(i, attributeMapping);
            return;
        }
        this.attributeMappings.add(attributeMapping);
    }
}

