/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultBuilderEntityValued;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitModelPartResultBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitModelPartResultBuilderEntity
implements ImplicitModelPartResultBuilder,
ResultBuilderEntityValued {
    private final NavigablePath navigablePath;
    private final EntityValuedModelPart modelPart;

    public ImplicitModelPartResultBuilderEntity(NavigablePath navigablePath, EntityValuedModelPart modelPart) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
    }

    public ImplicitModelPartResultBuilderEntity(EntityMappingType entityMappingType) {
        this(new NavigablePath(entityMappingType.getEntityName()), entityMappingType);
    }

    @Override
    public Class<?> getJavaType() {
        return this.modelPart.getJavaType().getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        creationStateImpl.disallowPositionalSelections();
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().resolveTableGroup(this.navigablePath, np -> {
            if (this.navigablePath.getParent() != null) {
                return creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
            }
            return this.modelPart.getEntityMappingType().createRootTableGroup(true, this.navigablePath, null, null, creationStateImpl, creationStateImpl.getCreationContext());
        });
        return (EntityResult)this.modelPart.createDomainResult(this.navigablePath, tableGroup, null, domainResultCreationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitModelPartResultBuilderEntity that = (ImplicitModelPartResultBuilderEntity)o;
        if (!this.navigablePath.equals(that.navigablePath)) {
            return false;
        }
        return this.modelPart.equals(that.modelPart);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.modelPart.hashCode();
        return result;
    }
}

