/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.QueryException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;

public class SQLQueryParser {
    private static final Pattern PREPARED_STATEMENT_PATTERN = Pattern.compile("^\\{.*?\\}$");
    private static final String HIBERNATE_PLACEHOLDER_PREFIX = "h-";
    private static final String DOMAIN_PLACEHOLDER = "h-domain";
    private static final String CATALOG_PLACEHOLDER = "h-catalog";
    private static final String SCHEMA_PLACEHOLDER = "h-schema";
    private final SessionFactoryImplementor factory;
    private final String originalQueryString;
    private final ParserContext context;
    private long aliasesFound;

    public SQLQueryParser(String queryString, ParserContext context, SessionFactoryImplementor factory) {
        this.originalQueryString = queryString;
        this.context = context;
        this.factory = factory;
    }

    public boolean queryHasAliases() {
        return this.aliasesFound > 0L;
    }

    protected String getOriginalQueryString() {
        return this.originalQueryString;
    }

    public String process() {
        return this.substituteBrackets(this.originalQueryString);
    }

    protected String substituteBrackets(String sqlQuery) throws QueryException {
        if (PREPARED_STATEMENT_PATTERN.matcher(sqlQuery.trim()).matches()) {
            return sqlQuery;
        }
        StringBuilder result = new StringBuilder(sqlQuery.length() + 20);
        SqlStringGenerationContext sqlStringGenerationContext = this.factory.getSqlStringGenerationContext();
        int curr = 0;
        while (curr < sqlQuery.length()) {
            int right;
            block29: {
                String aliasPath;
                block28: {
                    int left = sqlQuery.indexOf(123, curr);
                    if (left < 0) {
                        result.append(sqlQuery.substring(curr));
                        break;
                    }
                    result.append(sqlQuery, curr, left);
                    right = sqlQuery.indexOf(125, left + 1);
                    if (right < 0) {
                        throw new QueryException("Unmatched braces for alias path", sqlQuery);
                    }
                    aliasPath = sqlQuery.substring(left + 1, right);
                    boolean isPlaceholder = aliasPath.startsWith(HIBERNATE_PLACEHOLDER_PREFIX);
                    if (!isPlaceholder) break block28;
                    switch (aliasPath) {
                        case "h-domain": {
                            Identifier schemaName;
                            Identifier catalogName = sqlStringGenerationContext.getDefaultCatalog();
                            if (catalogName != null) {
                                result.append(catalogName.render(sqlStringGenerationContext.getDialect()));
                                result.append(".");
                            }
                            if ((schemaName = sqlStringGenerationContext.getDefaultSchema()) != null) {
                                result.append(schemaName.render(sqlStringGenerationContext.getDialect()));
                                result.append(".");
                                break;
                            }
                            break block29;
                        }
                        case "h-schema": {
                            Identifier schemaName = sqlStringGenerationContext.getDefaultSchema();
                            if (schemaName != null) {
                                result.append(schemaName.render(sqlStringGenerationContext.getDialect()));
                                result.append(".");
                                break;
                            }
                            break block29;
                        }
                        case "h-catalog": {
                            Identifier catalogName = sqlStringGenerationContext.getDefaultCatalog();
                            if (catalogName != null) {
                                result.append(catalogName.render(sqlStringGenerationContext.getDialect()));
                                result.append(".");
                                break;
                            }
                            break block29;
                        }
                        default: {
                            throw new QueryException("Unknown placeholder ", aliasPath);
                        }
                    }
                    break block29;
                }
                if (this.context != null) {
                    int firstDot = aliasPath.indexOf(46);
                    if (firstDot == -1) {
                        if (this.context.isEntityAlias(aliasPath)) {
                            result.append(aliasPath);
                            ++this.aliasesFound;
                        } else {
                            result.append('{').append(aliasPath).append('}');
                        }
                    } else {
                        String propertyName;
                        String aliasName = aliasPath.substring(0, firstDot);
                        if (this.context.isCollectionAlias(aliasName)) {
                            propertyName = aliasPath.substring(firstDot + 1);
                            result.append(this.resolveCollectionProperties(aliasName, propertyName));
                            ++this.aliasesFound;
                        } else if (this.context.isEntityAlias(aliasName)) {
                            propertyName = aliasPath.substring(firstDot + 1);
                            result.append(this.resolveProperties(aliasName, propertyName));
                            ++this.aliasesFound;
                        } else {
                            result.append('{').append(aliasPath).append('}');
                        }
                    }
                } else {
                    result.append('{').append(aliasPath).append('}');
                }
            }
            curr = right + 1;
        }
        return result.toString();
    }

    private String resolveCollectionProperties(String aliasName, String propertyName) {
        Map<String, String[]> fieldResults = this.context.getPropertyResultsMap(aliasName);
        SQLLoadableCollection collectionPersister = this.context.getCollectionPersister(aliasName);
        String collectionSuffix = this.context.getCollectionSuffix(aliasName);
        switch (propertyName) {
            case "*": {
                if (!fieldResults.isEmpty()) {
                    throw new QueryException("Using return-propertys together with * syntax is not supported.");
                }
                String selectFragment = collectionPersister.selectFragment(aliasName, collectionSuffix);
                ++this.aliasesFound;
                return selectFragment + ", " + this.resolveProperties(aliasName, propertyName);
            }
            case "element.*": {
                return this.resolveProperties(aliasName, "*");
            }
        }
        String[] columnAliases = fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = collectionPersister.getCollectionPropertyColumnAliases(propertyName, collectionSuffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.originalQueryString);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.originalQueryString);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String resolveProperties(String aliasName, String propertyName) {
        Map<String, String[]> fieldResults = this.context.getPropertyResultsMap(aliasName);
        SQLLoadable persister = this.context.getEntityPersister(aliasName);
        String suffix = this.context.getEntitySuffix(aliasName);
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            ++this.aliasesFound;
            return persister.selectFragment(aliasName, suffix);
        }
        String[] columnAliases = fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = persister.getSubclassPropertyColumnAliases(propertyName, suffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.originalQueryString);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.originalQueryString);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    public static interface ParserContext {
        public boolean isEntityAlias(String var1);

        public SQLLoadable getEntityPersister(String var1);

        public String getEntitySuffix(String var1);

        public boolean isCollectionAlias(String var1);

        public SQLLoadableCollection getCollectionPersister(String var1);

        public String getCollectionSuffix(String var1);

        public Map<String, String[]> getPropertyResultsMap(String var1);
    }
}

