/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class JdbcParameterBindingsImpl
implements JdbcParameterBindings {
    private Map<JdbcParameter, JdbcParameterBinding> bindingMap;

    public JdbcParameterBindingsImpl(int expectedParameterCount) {
        if (expectedParameterCount > 0) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>(expectedParameterCount);
        }
    }

    @Override
    public void addBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        if (this.bindingMap == null) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>();
        }
        this.bindingMap.put(parameter, binding);
    }

    @Override
    public Collection<JdbcParameterBinding> getBindings() {
        return this.bindingMap == null ? Collections.emptyList() : this.bindingMap.values();
    }

    @Override
    public JdbcParameterBinding getBinding(JdbcParameter parameter) {
        if (this.bindingMap == null) {
            return null;
        }
        return this.bindingMap.get(parameter);
    }

    @Override
    public void visitBindings(BiConsumer<JdbcParameter, JdbcParameterBinding> action) {
        for (Map.Entry<JdbcParameter, JdbcParameterBinding> entry : this.bindingMap.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        if (this.bindingMap != null) {
            this.bindingMap.clear();
        }
    }
}

