/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.type.spi.TypeConfiguration;

public interface JdbcTypeIndicators {
    public static final int NO_COLUMN_LENGTH = -1;
    public static final int NO_COLUMN_PRECISION = -1;
    public static final int NO_COLUMN_SCALE = -1;

    default public boolean isNationalized() {
        return false;
    }

    default public boolean isLob() {
        return false;
    }

    default public EnumType getEnumeratedType() {
        return EnumType.ORDINAL;
    }

    default public TemporalType getTemporalPrecision() {
        return null;
    }

    default public int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    default public int getPreferredSqlTypeCodeForDuration() {
        return 3100;
    }

    default public int getPreferredSqlTypeCodeForUuid() {
        return 3000;
    }

    default public int getPreferredSqlTypeCodeForInstant() {
        return 3003;
    }

    default public long getColumnLength() {
        return -1L;
    }

    default public int getColumnPrecision() {
        return -1;
    }

    default public int getColumnScale() {
        return -1;
    }

    default public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return this.getTypeConfiguration().getSessionFactory().getFastSessionServices().getDefaultTimeZoneStorageStrategy();
    }

    public TypeConfiguration getTypeConfiguration();
}

