/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class JsonJdbcType
implements JdbcType {
    public static final JsonJdbcType INSTANCE = new JsonJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3001;
    }

    public String toString() {
        return "JsonJdbcType";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String json = options.getSessionFactory().getFastSessionServices().getJsonFormatMapper().toString(value, this.getJavaType(), options);
                st.setString(index, json);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String json = options.getSessionFactory().getFastSessionServices().getJsonFormatMapper().toString(value, this.getJavaType(), options);
                st.setString(name, json);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getString(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(name), options);
            }

            private X getObject(String json, WrapperOptions options) throws SQLException {
                if (json == null) {
                    return null;
                }
                return options.getSessionFactory().getFastSessionServices().getJsonFormatMapper().fromString(json, this.getJavaType(), options);
            }
        };
    }
}

