/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class ProtocolConfigurationFactory {
    private static final OptionMap DEFAULT_OPTIONS = OptionMap.EMPTY;

    ProtocolConfigurationFactory() {
    }

    static ProtocolConnectionConfiguration create(ModelControllerClientConfiguration client, Endpoint endpoint) throws URISyntaxException {
        URI connURI;
        if (client.getProtocol() == null) {
            String protocol = client.getPort() == 9999 ? "remote://" : "remote+http://";
            connURI = new URI(protocol + ProtocolConfigurationFactory.formatPossibleIpv6Address(client.getHost()) + ":" + client.getPort());
        } else {
            connURI = new URI(client.getProtocol() + "://" + ProtocolConfigurationFactory.formatPossibleIpv6Address(client.getHost()) + ":" + client.getPort());
        }
        ProtocolConnectionConfiguration configuration = ProtocolConnectionConfiguration.create((Endpoint)endpoint, (URI)connURI, (OptionMap)DEFAULT_OPTIONS);
        configuration.setClientBindAddress(client.getClientBindAddress());
        long timeout = client.getConnectionTimeout();
        if (timeout > 0L) {
            configuration.setConnectionTimeout(timeout);
        }
        return configuration;
    }

    private static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }
}

