/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.jakarta;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import java.util.function.Function;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.clustering.infinispan.jakarta.ExceptionAdapter;
import org.jboss.as.clustering.infinispan.jakarta.TransactionAdapter;

public class TransactionManagerAdapter
implements TransactionManager {
    private static final Function<String, InvalidTransactionException> INVALID_TRANSACTION_EXCEPTION_FACTORY = InvalidTransactionException::new;
    private static final Function<String, javax.transaction.NotSupportedException> NOT_SUPPORTED_EXCEPTION_FACTORY = javax.transaction.NotSupportedException::new;
    private final jakarta.transaction.TransactionManager tm;

    private static InvalidTransactionException adapt(jakarta.transaction.InvalidTransactionException source) {
        return ExceptionAdapter.adapt(source, INVALID_TRANSACTION_EXCEPTION_FACTORY);
    }

    private static javax.transaction.NotSupportedException adapt(NotSupportedException source) {
        return ExceptionAdapter.adapt(source, NOT_SUPPORTED_EXCEPTION_FACTORY);
    }

    public TransactionManagerAdapter(jakarta.transaction.TransactionManager tm) {
        this.tm = tm;
    }

    public void begin() throws javax.transaction.NotSupportedException, SystemException {
        try {
            this.tm.begin();
        }
        catch (NotSupportedException e) {
            throw TransactionManagerAdapter.adapt(e);
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public void commit() throws javax.transaction.RollbackException, javax.transaction.HeuristicMixedException, HeuristicRollbackException, SystemException {
        try {
            this.tm.commit();
        }
        catch (RollbackException e) {
            throw ExceptionAdapter.adapt(e);
        }
        catch (HeuristicMixedException e) {
            throw ExceptionAdapter.adapt(e);
        }
        catch (jakarta.transaction.HeuristicRollbackException e) {
            throw ExceptionAdapter.adapt(e);
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public int getStatus() throws SystemException {
        try {
            return this.tm.getStatus();
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public Transaction getTransaction() throws SystemException {
        try {
            return new TransactionAdapter(this.tm.getTransaction());
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public void resume(Transaction tx) throws InvalidTransactionException, SystemException {
        if (!(tx instanceof TransactionAdapter)) {
            throw new InvalidTransactionException(tx.getClass().getName());
        }
        try {
            this.tm.resume(((TransactionAdapter)tx).unwrap());
        }
        catch (jakarta.transaction.InvalidTransactionException e) {
            throw TransactionManagerAdapter.adapt(e);
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public void rollback() throws SystemException {
        try {
            this.tm.rollback();
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public void setRollbackOnly() throws SystemException {
        try {
            this.tm.setRollbackOnly();
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        try {
            this.tm.setTransactionTimeout(seconds);
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }

    public Transaction suspend() throws SystemException {
        try {
            return new TransactionAdapter(this.tm.suspend());
        }
        catch (jakarta.transaction.SystemException e) {
            throw ExceptionAdapter.adapt(e);
        }
    }
}

