/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.config.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.jboss.modcluster.config.JvmRouteFactory;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.SessionDrainingStrategy;
import org.jboss.modcluster.config.builder.AbstractConfigurationBuilder;
import org.jboss.modcluster.config.builder.ConfigurationBuilder;
import org.jboss.modcluster.config.builder.Creator;
import org.jboss.modcluster.config.impl.MCMPHandlerConfigurationImpl;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.jboss.modcluster.config.impl.SystemPropertyJvmRouteFactory;
import org.jboss.modcluster.config.impl.UUIDJvmRouteFactory;

public class MCMPHandlerConfigurationBuilder
extends AbstractConfigurationBuilder
implements Creator<MCMPHandlerConfiguration> {
    private Collection<ProxyConfiguration> proxyConfigurations = Collections.emptySet();
    private String proxyURL;
    private int socketTimeout = 20000;
    private SocketFactory socketFactory = SocketFactory.getDefault();
    private Map<String, Set<String>> excludedContextsPerHost = Collections.emptyMap();
    private Boolean advertise;
    private boolean autoEnableContexts = true;
    private long stopContextTimeout = 10L;
    private TimeUnit stopContextTimeoutUnit = TimeUnit.SECONDS;
    private JvmRouteFactory jvmRouteFactory = new SystemPropertyJvmRouteFactory(new UUIDJvmRouteFactory());
    private SessionDrainingStrategy sessionDrainingStrategy = SessionDrainingStrategyEnum.DEFAULT;

    MCMPHandlerConfigurationBuilder(ConfigurationBuilder parentBuilder) {
        super(parentBuilder);
    }

    public MCMPHandlerConfigurationBuilder setProxyConfigurations(Collection<ProxyConfiguration> proxyConfigurations) {
        this.proxyConfigurations = proxyConfigurations;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setExcludedContextsPerHost(Map<String, Set<String>> excludedContextsPerHost) {
        this.excludedContextsPerHost = excludedContextsPerHost;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setAdvertise(Boolean advertise) {
        this.advertise = advertise;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setAutoEnableContexts(boolean autoEnableContexts) {
        this.autoEnableContexts = autoEnableContexts;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setStopContextTimeout(long stopContextTimeout) {
        this.stopContextTimeout = stopContextTimeout;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setStopContextTimeoutUnit(TimeUnit stopContextTimeoutUnit) {
        this.stopContextTimeoutUnit = stopContextTimeoutUnit;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setJvmRouteFactory(JvmRouteFactory jvmRouteFactory) {
        this.jvmRouteFactory = jvmRouteFactory;
        return this;
    }

    public MCMPHandlerConfigurationBuilder setSessionDrainingStrategy(SessionDrainingStrategy sessionDrainingStrategy) {
        this.sessionDrainingStrategy = sessionDrainingStrategy;
        return this;
    }

    @Override
    public MCMPHandlerConfiguration create() {
        return new MCMPHandlerConfigurationImpl(this.proxyConfigurations, this.proxyURL, this.socketTimeout, this.socketFactory, this.excludedContextsPerHost, this.advertise, this.autoEnableContexts, this.stopContextTimeout, this.stopContextTimeoutUnit, this.jvmRouteFactory, this.sessionDrainingStrategy);
    }
}

