/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannelConfig;
import org.xnio.Options;
import org.xnio.netty.transport.AbstractXnioSocketChannel;

final class XnioSocketChannelConfig
extends DefaultChannelConfig
implements SocketChannelConfig {
    private final AbstractXnioSocketChannel channel;

    XnioSocketChannelConfig(AbstractXnioSocketChannel channel) {
        super((Channel)channel);
        this.channel = channel;
    }

    public boolean isTcpNoDelay() {
        return (Boolean)this.channel.getOption(Options.TCP_NODELAY);
    }

    public SocketChannelConfig setTcpNoDelay(boolean tcpNoDelay) {
        this.channel.setOption(Options.TCP_NODELAY, tcpNoDelay);
        return this;
    }

    public int getSoLinger() {
        return 0;
    }

    public SocketChannelConfig setSoLinger(int soLinger) {
        throw new UnsupportedOperationException();
    }

    public int getSendBufferSize() {
        return (Integer)this.channel.getOption(Options.SEND_BUFFER);
    }

    public SocketChannelConfig setSendBufferSize(int sendBufferSize) {
        this.channel.setOption(Options.SEND_BUFFER, sendBufferSize);
        return this;
    }

    public int getReceiveBufferSize() {
        return (Integer)this.channel.getOption(Options.RECEIVE_BUFFER);
    }

    public SocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        this.channel.setOption(Options.RECEIVE_BUFFER, receiveBufferSize);
        return this;
    }

    public boolean isKeepAlive() {
        return (Boolean)this.channel.getOption(Options.KEEP_ALIVE);
    }

    public SocketChannelConfig setKeepAlive(boolean keepAlive) {
        this.channel.setOption(Options.KEEP_ALIVE, keepAlive);
        return this;
    }

    public int getTrafficClass() {
        return (Integer)this.channel.getOption(Options.IP_TRAFFIC_CLASS);
    }

    public SocketChannelConfig setTrafficClass(int trafficClass) {
        this.channel.setOption(Options.IP_TRAFFIC_CLASS, trafficClass);
        return this;
    }

    public boolean isReuseAddress() {
        return (Boolean)this.channel.getOption(Options.REUSE_ADDRESSES);
    }

    public SocketChannelConfig setReuseAddress(boolean reuseAddress) {
        this.channel.setOption(Options.REUSE_ADDRESSES, reuseAddress);
        return this;
    }

    public SocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowHalfClosure() {
        return false;
    }

    public SocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
        throw new UnsupportedOperationException();
    }

    public SocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Deprecated
    public SocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    public SocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    public SocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    public SocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    public SocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Deprecated
    public SocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    public SocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }

    @Deprecated
    public SocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    public SocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public SocketChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }
}

