/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.jboss.as.network.SocketBinding;
import org.wildfly.common.Assert;

public interface ManagedBinding
extends Closeable {
    public String getSocketBindingName();

    public InetSocketAddress getBindAddress();

    @Override
    public void close() throws IOException;

    public static final class Factory {
        public static ManagedBinding createSimpleManagedBinding(final String name, final InetSocketAddress socketAddress, final Closeable closeable) {
            Assert.checkNotNullParam((String)"socketAddress", (Object)socketAddress);
            return new ManagedBinding(){

                @Override
                public String getSocketBindingName() {
                    return name;
                }

                @Override
                public InetSocketAddress getBindAddress() {
                    return socketAddress;
                }

                @Override
                public void close() throws IOException {
                    if (closeable != null) {
                        closeable.close();
                    }
                }
            };
        }

        public static ManagedBinding createSimpleManagedBinding(final SocketBinding socketBinding) {
            Assert.checkNotNullParam((String)"socketBinding", (Object)socketBinding);
            return new ManagedBinding(){

                @Override
                public String getSocketBindingName() {
                    return socketBinding.getName();
                }

                @Override
                public InetSocketAddress getBindAddress() {
                    return socketBinding.getSocketAddress();
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }
}

