/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jsp;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.jsp.Attribute;
import org.jboss.metadata.parser.jsp.Element;
import org.jboss.metadata.parser.jsp.FunctionMetaDataParser;
import org.jboss.metadata.parser.jsp.ListenerMetaDataParser;
import org.jboss.metadata.parser.jsp.Location;
import org.jboss.metadata.parser.jsp.TagFileMetaDataParser;
import org.jboss.metadata.parser.jsp.TagMetaDataParser;
import org.jboss.metadata.parser.jsp.TldExtensionMetaDataParser;
import org.jboss.metadata.parser.jsp.ValidatorMetaDataParser;
import org.jboss.metadata.parser.jsp.Version;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldExtensionMetaData;
import org.jboss.metadata.web.spec.TldMetaData;

public class TldMetaDataParser
extends MetaDataElementParser {
    public static TldMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        int i;
        int count;
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            if (reader.getEventType() != 11) continue;
            String dtdLocation = TldMetaDataParser.readDTDLocation((XMLStreamReader)reader);
            if (dtdLocation != null) {
                version = Location.getVersion(dtdLocation);
            }
            if (version != null) continue;
            version = Version.TLD_1_2;
        }
        String schemaLocation = TldMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = Location.getVersion(schemaLocation);
        }
        if (version == null) {
            String versionString = null;
            count = reader.getAttributeCount();
            for (i = 0; i < count; ++i) {
                Attribute attribute;
                if (TldMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            if ("2.0".equals(versionString)) {
                version = Version.TLD_2_0;
            } else if ("2.1".equals(versionString)) {
                version = Version.TLD_2_1;
            } else if ("3.0".equals(versionString)) {
                version = Version.TLD_3_0;
            } else if ("3.1".equals(versionString)) {
                version = Version.TLD_3_1;
            }
        }
        if (version == null) {
            version = Version.TLD_3_1;
        }
        TldMetaData tld = new TldMetaData();
        count = reader.getAttributeCount();
        block24: for (i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (TldMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    tld.setId(value);
                    continue block24;
                }
                case VERSION: {
                    tld.setVersion(value);
                    continue block24;
                }
                default: {
                    throw TldMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block25: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (tld.getDescriptionGroup() != null) continue;
                tld.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TLIB_VERSION: {
                    tld.setTlibVersion(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block25;
                }
                case TLIBVERSION: {
                    if (version == Version.TLD_1_1) {
                        tld.setTlibVersion(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    if (version == Version.TLD_1_2) {
                        tld.setTlibVersion(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case SHORT_NAME: {
                    tld.setShortName(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block25;
                }
                case SHORTNAME: {
                    if (version == Version.TLD_1_1) {
                        tld.setShortName(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    if (version == Version.TLD_1_2) {
                        tld.setShortName(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case JSPVERSION: {
                    if (version == Version.TLD_1_1) {
                        tld.setJspVersion(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    if (version == Version.TLD_1_2) {
                        tld.setJspVersion(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case JSP_VERSION: {
                    if (version == Version.TLD_1_2) {
                        tld.setJspVersion(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    if (version != Version.TLD_1_1) {
                        tld.setJspVersion(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block25;
                    }
                    throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case INFO: {
                    if (version == Version.TLD_1_1) {
                        TldMetaDataParser.getElementText((XMLStreamReader)reader);
                        continue block25;
                    }
                    if (version == Version.TLD_1_2) {
                        TldMetaDataParser.getElementText((XMLStreamReader)reader);
                        continue block25;
                    }
                    throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case SMALL_ICON: {
                    if (version == Version.TLD_1_2) {
                        TldMetaDataParser.getElementText((XMLStreamReader)reader);
                        continue block25;
                    }
                    throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case LARGE_ICON: {
                    if (version == Version.TLD_1_2) {
                        TldMetaDataParser.getElementText((XMLStreamReader)reader);
                        continue block25;
                    }
                    throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case URI: {
                    tld.setUri(TldMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block25;
                }
                case VALIDATOR: {
                    tld.setValidator(ValidatorMetaDataParser.parse(reader));
                    continue block25;
                }
                case LISTENER: {
                    List<ListenerMetaData> listeners = tld.getListeners();
                    if (listeners == null) {
                        listeners = new ArrayList<ListenerMetaData>();
                        tld.setListeners(listeners);
                    }
                    listeners.add(ListenerMetaDataParser.parse(reader));
                    continue block25;
                }
                case TAG: {
                    List<TagMetaData> tags = tld.getTags();
                    if (tags == null) {
                        tags = new ArrayList<TagMetaData>();
                        tld.setTags(tags);
                    }
                    tags.add(TagMetaDataParser.parse(reader, version));
                    continue block25;
                }
                case TAG_FILE: {
                    List<TagFileMetaData> tagfiles = tld.getTagFiles();
                    if (tagfiles == null) {
                        tagfiles = new ArrayList<TagFileMetaData>();
                        tld.setTagFiles(tagfiles);
                    }
                    tagfiles.add(TagFileMetaDataParser.parse(reader));
                    continue block25;
                }
                case FUNCTION: {
                    List<FunctionMetaData> functions = tld.getFunctions();
                    if (functions == null) {
                        functions = new ArrayList<FunctionMetaData>();
                        tld.setFunctions(functions);
                    }
                    functions.add(FunctionMetaDataParser.parse(reader));
                    continue block25;
                }
                case TAGLIB_EXTENSION: {
                    List<TldExtensionMetaData> extensions = tld.getTaglibExtensions();
                    if (extensions == null) {
                        extensions = new ArrayList<TldExtensionMetaData>();
                        tld.setTaglibExtensions(extensions);
                    }
                    extensions.add(TldExtensionMetaDataParser.parse(reader));
                    continue block25;
                }
            }
            throw TldMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return tld;
    }
}

