/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import io.grpc.internal.AbstractReadableBuffer;
import io.grpc.internal.ReadableBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import okio.Buffer;

class OkHttpReadableBuffer
extends AbstractReadableBuffer {
    private final Buffer buffer;

    OkHttpReadableBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public int readableBytes() {
        return (int)this.buffer.size();
    }

    public int readUnsignedByte() {
        try {
            this.fakeEofExceptionMethod();
            return this.buffer.readByte() & 0xFF;
        }
        catch (EOFException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    private void fakeEofExceptionMethod() throws EOFException {
    }

    public void skipBytes(int length) {
        try {
            this.buffer.skip((long)length);
        }
        catch (EOFException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public void readBytes(byte[] dest, int destOffset, int length) {
        while (length > 0) {
            int bytesRead = this.buffer.read(dest, destOffset, length);
            if (bytesRead == -1) {
                throw new IndexOutOfBoundsException("EOF trying to read " + length + " bytes");
            }
            length -= bytesRead;
            destOffset += bytesRead;
        }
    }

    public void readBytes(ByteBuffer dest) {
        throw new UnsupportedOperationException();
    }

    public void readBytes(OutputStream dest, int length) throws IOException {
        this.buffer.writeTo(dest, (long)length);
    }

    public ReadableBuffer readBytes(int length) {
        Buffer buf = new Buffer();
        buf.write(this.buffer, (long)length);
        return new OkHttpReadableBuffer(buf);
    }

    public void close() {
        this.buffer.clear();
    }
}

