/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.ValidateUserState;

public class PromptNewUserState
implements State {
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public PromptNewUserState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        ValidateUserState continuingState = new ValidateUserState(this.theConsole, this.stateValues);
        if (!this.stateValues.isSilentOrNonInteractive()) {
            this.stateValues.setPassword(null);
            String existingUsername = this.stateValues.getUserName();
            String usernamePrompt = existingUsername == null ? DomainManagementLogger.ROOT_LOGGER.usernamePrompt() : DomainManagementLogger.ROOT_LOGGER.usernamePrompt(existingUsername);
            this.theConsole.printf(usernamePrompt, new Object[0]);
            String temp = this.theConsole.readLine(" : ", new Object[0]);
            if (temp != null && temp.length() > 0) {
                existingUsername = temp;
            }
            if (temp == null || existingUsername == null || existingUsername.length() == 0) {
                return new ErrorState(this.theConsole, DomainManagementLogger.ROOT_LOGGER.noUsernameExiting(), this.stateValues);
            }
            this.stateValues.setUserName(existingUsername);
        }
        return continuingState;
    }
}

