/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.jboss.logging.Logger;

final class ReplicationError
implements Interceptor {
    private static final Logger logger = Logger.getLogger(ReplicationError.class);
    private LiveNodeLocator nodeLocator;

    ReplicationError(LiveNodeLocator nodeLocator) {
        this.nodeLocator = nodeLocator;
    }

    public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
        if (packet.getType() != 116) {
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received ReplicationError::" + packet));
        }
        BackupReplicationStartFailedMessage message = (BackupReplicationStartFailedMessage)packet;
        switch (message.getRegistrationProblem()) {
            case ALREADY_REPLICATING: {
                this.tryNext();
                break;
            }
            case AUTHENTICATION: {
                this.failed();
                break;
            }
            case EXCEPTION: {
                this.failed();
                break;
            }
            default: {
                this.failed();
            }
        }
        return false;
    }

    private void failed() throws ActiveMQInternalErrorException {
        ActiveMQServerLogger.LOGGER.errorRegisteringBackup();
        this.nodeLocator.notifyRegistrationFailed(false);
    }

    private void tryNext() {
        this.nodeLocator.notifyRegistrationFailed(true);
    }
}

