/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.protocol.websocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.activemq.artemis.core.server.protocol.websocket.WebSocketFrameEncoder;
import org.apache.activemq.artemis.utils.StringUtil;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private HttpRequest httpRequest;
    private WebSocketServerHandshaker handshaker;
    private List<String> supportedProtocols;
    private int maxFramePayloadLength;

    public WebSocketServerHandler(List<String> supportedProtocols, int maxFramePayloadLength) {
        this.supportedProtocols = supportedProtocols;
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        WebSocketFrame frame;
        boolean handle;
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame && (handle = this.handleWebSocketFrame(ctx, frame = (WebSocketFrame)msg))) {
            ctx.fireChannelRead((Object)frame.content().retain());
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (req.method() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, (HttpRequest)req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        String supportedProtocolsCSV = StringUtil.joinStringList(this.supportedProtocols, (String)",");
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation((HttpRequest)req), supportedProtocolsCSV, false, this.maxFramePayloadLength);
        this.httpRequest = req;
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            ChannelFuture handshake = this.handshaker.handshake(ctx.channel(), req);
            handshake.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        WebSocketFrameEncoder encoder = new WebSocketFrameEncoder(WebSocketServerHandler.this.maxFramePayloadLength);
                        future.channel().pipeline().addAfter("wsencoder", "websocket-frame-encoder", (ChannelHandler)encoder);
                    } else {
                        future.channel().pipeline().fireExceptionCaught(future.cause());
                    }
                }
            });
        }
    }

    private boolean handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), ((CloseWebSocketFrame)frame).retain());
            return false;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return false;
        }
        if (!(frame instanceof TextWebSocketFrame || frame instanceof BinaryWebSocketFrame || frame instanceof ContinuationWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        return true;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, FullHttpResponse res) {
        if (res.status().code() != 200) {
            res.content().writeBytes(res.status().toString().getBytes(StandardCharsets.UTF_8));
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.headers().get((CharSequence)HttpHeaderNames.HOST);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }
}

