/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.as.server.controller.git.GitConfigurationPersistenceResource;
import org.jboss.as.server.controller.git.GitRepository;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class GitConfigurationPersister
extends XmlConfigurationPersister {
    private final AtomicBoolean successfulBoot = new AtomicBoolean();
    private GitRepository gitRepository;
    private final Path root;
    private final File mainFile;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmssSSS");
    private static final String SNAPSHOT_PREFIX = "Snapshot-";

    public GitConfigurationPersister(GitRepository gitRepository, ConfigurationFile file, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser, boolean suppressLoad) {
        super(file.getBootFile(), rootElement, rootParser, rootDeparser, suppressLoad);
        this.root = file.getConfigurationDir().getParentFile().toPath();
        this.mainFile = file.getMainFile();
        this.gitRepository = gitRepository;
        File baseDir = this.root.toFile();
        try {
            File gitDir = new File(baseDir, ".git");
            if (!gitDir.exists()) {
                gitDir.mkdir();
            }
            if (gitRepository.isBare()) {
                Git.init().setDirectory(baseDir).setGitDir(gitDir).call();
                ServerLogger.ROOT_LOGGER.gitRespositoryInitialized(baseDir.getAbsolutePath());
            }
        }
        catch (IllegalStateException | GitAPIException e) {
            ControllerLogger.ROOT_LOGGER.error((Object)e);
        }
    }

    public GitConfigurationPersister(GitRepository gitRepository, ConfigurationFile file, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        this(gitRepository, file, rootElement, rootParser, rootDeparser, false);
    }

    public void successfulBoot() throws ConfigurationPersistenceException {
        this.successfulBoot.compareAndSet(false, true);
    }

    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        if (!this.successfulBoot.get()) {
            return new ConfigurationPersister.PersistenceResource(){

                public void commit() {
                }

                public void rollback() {
                }
            };
        }
        return new GitConfigurationPersistenceResource(model, this.mainFile, this.gitRepository, (AbstractConfigurationPersister)this);
    }

    public String snapshot(String name, String comment) throws ConfigurationPersistenceException {
        boolean noComment = comment == null || comment.isEmpty();
        String message = noComment ? SNAPSHOT_PREFIX + FORMATTER.format(LocalDateTime.now()) : comment;
        Object tagName = name == null || name.isEmpty() ? SNAPSHOT_PREFIX + FORMATTER.format(LocalDateTime.now()) : name;
        try (Git git = this.gitRepository.getGit();){
            Status status = git.status().call();
            List tags = git.tagList().call();
            String refTagName = "refs/tags/" + (String)tagName;
            for (Ref tag : tags) {
                if (!refTagName.equals(tag.getName())) continue;
                throw ControllerLogger.MGMT_OP_LOGGER.snapshotAlreadyExistError((String)tagName);
            }
            if (status.hasUncommittedChanges() || !noComment) {
                git.commit().setMessage(message).setAll(true).setNoVerify(true).call();
            }
            git.tag().setName((String)tagName).setMessage(message).call();
        }
        catch (GitAPIException ex) {
            throw ControllerLogger.MGMT_OP_LOGGER.failedToPersistConfiguration((Throwable)ex, message, ex.getMessage());
        }
        return message;
    }

    public String publish(String name) throws ConfigurationPersistenceException {
        StringBuilder message = new StringBuilder();
        String remoteName = this.gitRepository.getRemoteName(name);
        if (remoteName != null && this.gitRepository.isValidRemoteName(remoteName)) {
            try (Git git = this.gitRepository.getGit();){
                Iterable result = git.push().setRemote(remoteName).setRefSpecs(new RefSpec[]{new RefSpec(this.gitRepository.getBranch() + ":" + this.gitRepository.getBranch())}).setPushTags().call();
                for (PushResult pushResult : result) {
                    for (RemoteRefUpdate refUpdate : pushResult.getRemoteUpdates()) {
                        message.append(refUpdate.getMessage()).append(" ").append(refUpdate.getNewObjectId().name()).append('\n');
                    }
                }
            }
            catch (GitAPIException ex) {
                throw ControllerLogger.MGMT_OP_LOGGER.failedToPublishConfiguration((Throwable)ex, name, ex.getMessage());
            }
        }
        return message.toString();
    }

    public void deleteSnapshot(String name) {
        try (Git git = this.gitRepository.getGit();){
            git.tagDelete().setTags(new String[]{name}).call();
        }
        catch (GitAPIException ex) {
            ControllerLogger.MGMT_OP_LOGGER.failedToDeleteConfigurationSnapshot((Throwable)ex, name);
        }
    }

    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        block13: {
            ConfigurationPersister.SnapshotInfo snapshotInfo;
            block12: {
                Git git = this.gitRepository.getGit();
                try {
                    final ArrayList<Object> snapshots = new ArrayList<Object>();
                    for (Ref ref : git.tagList().call()) {
                        RevWalk revWalk = new RevWalk(git.getRepository());
                        revWalk.sort(RevSort.COMMIT_TIME_DESC, true);
                        try {
                            RevTag annotatedTag = revWalk.parseTag((AnyObjectId)ref.getObjectId());
                            snapshots.add(annotatedTag.getTagName() + " : " + annotatedTag.getFullMessage());
                        }
                        catch (IncorrectObjectTypeException ex) {
                            snapshots.add(ref.getName());
                        }
                        snapshots.add(ref.getName());
                    }
                    snapshotInfo = new ConfigurationPersister.SnapshotInfo(){

                        public String getSnapshotDirectory() {
                            return "";
                        }

                        public List<String> names() {
                            return snapshots;
                        }
                    };
                    if (git == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (GitAPIException ex) {
                        ControllerLogger.MGMT_OP_LOGGER.failedToListConfigurationSnapshot((Throwable)ex, this.mainFile.getName());
                        break block13;
                    }
                    catch (IOException ex) {
                        ControllerLogger.MGMT_OP_LOGGER.failedToListConfigurationSnapshot((Throwable)ex, this.mainFile.getName());
                    }
                }
                git.close();
            }
            return snapshotInfo;
        }
        return NULL_SNAPSHOT_INFO;
    }
}

