/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.dialect.impl;

import java.lang.invoke.MethodHandles;
import java.util.OptionalInt;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch56ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch6ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch7ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.ElasticsearchModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch56ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch60ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch63ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch64ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch67ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch70ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.ElasticsearchProtocolDialect;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDialectFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public ElasticsearchModelDialect createModelDialect(ElasticsearchVersion version) {
        switch (version.distribution()) {
            case ELASTIC: {
                return this.createModelDialectElastic(version);
            }
            case OPENSEARCH: {
                return this.createModelDialectOpenSearch(version);
            }
        }
        throw new AssertionFailure("Unrecognized Elasticsearch distribution: " + (Object)((Object)version.distribution()));
    }

    private ElasticsearchModelDialect createModelDialectElastic(ElasticsearchVersion version) {
        int major = version.major();
        if (major < 5) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 5) {
            return this.createModelDialectElasticV5(version);
        }
        if (major == 6) {
            return new Elasticsearch6ModelDialect();
        }
        return new Elasticsearch7ModelDialect();
    }

    private ElasticsearchModelDialect createModelDialectElasticV5(ElasticsearchVersion version) {
        OptionalInt minorOptional = version.minor();
        if (!minorOptional.isPresent()) {
            throw log.ambiguousElasticsearchVersion(version);
        }
        int minor = minorOptional.getAsInt();
        if (minor < 6) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        return new Elasticsearch56ModelDialect();
    }

    private ElasticsearchModelDialect createModelDialectOpenSearch(ElasticsearchVersion version) {
        int major = version.major();
        if (major < 1) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        return new Elasticsearch7ModelDialect();
    }

    public ElasticsearchProtocolDialect createProtocolDialect(ElasticsearchVersion version) {
        switch (version.distribution()) {
            case ELASTIC: {
                return this.createProtocolDialectElastic(version);
            }
            case OPENSEARCH: {
                return this.createProtocolDialectOpenSearch(version);
            }
        }
        throw new AssertionFailure("Unrecognized Elasticsearch distribution: " + (Object)((Object)version.distribution()));
    }

    private ElasticsearchProtocolDialect createProtocolDialectElastic(ElasticsearchVersion version) {
        int major = version.major();
        OptionalInt minorOptional = version.minor();
        if (!minorOptional.isPresent()) {
            throw new AssertionFailure("The Elasticsearch version is incomplete when creating the protocol dialect.");
        }
        int minor = minorOptional.getAsInt();
        if (major < 5) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 5) {
            return this.createProtocolDialectElasticV5(version, minor);
        }
        if (major == 6) {
            return this.createProtocolDialectElasticV6(version, minor);
        }
        if (major != 7) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch70ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectElasticV5(ElasticsearchVersion version, int minor) {
        if (minor < 6) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (minor != 6) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch56ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectElasticV6(ElasticsearchVersion version, int minor) {
        if (minor < 3) {
            return new Elasticsearch60ProtocolDialect();
        }
        if (minor < 4) {
            return new Elasticsearch63ProtocolDialect();
        }
        if (minor < 7) {
            return new Elasticsearch64ProtocolDialect();
        }
        if (minor > 8) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch67ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectOpenSearch(ElasticsearchVersion version) {
        int major = version.major();
        if (major < 1) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major != 1) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch70ProtocolDialect();
    }
}

