/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.AnalyzerDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.CharFilterDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.NormalizerDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.TokenFilterDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.TokenizerDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.Analysis;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.validation.impl.AnalysisComponentDefinitionValidators;
import org.hibernate.search.backend.elasticsearch.validation.impl.AnalyzerDefinitionValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.LeafValidators;
import org.hibernate.search.backend.elasticsearch.validation.impl.NormalizerDefinitionValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

public class IndexSettingsValidator
implements Validator<IndexSettings> {
    private final Validator<AnalyzerDefinition> analyzerDefinitionValidator = new AnalyzerDefinitionValidator();
    private final Validator<NormalizerDefinition> normalizerDefinitionValidator = new NormalizerDefinitionValidator();
    private final Validator<CharFilterDefinition> charFilterDefinitionValidator = AnalysisComponentDefinitionValidators.charFilterDefinitionValidator();
    private final Validator<TokenizerDefinition> tokenizerDefinitionValidator = AnalysisComponentDefinitionValidators.tokenizerDefinitionValidator();
    private final Validator<TokenFilterDefinition> tokenFilterDefinitionValidator = AnalysisComponentDefinitionValidators.tokenFilterDefinitionValidator();
    private final Validator<JsonElement> extraAttributeValidator = new JsonElementValidator(new JsonElementEquivalence());

    @Override
    public void validate(ValidationErrorCollector errorCollector, IndexSettings expected, IndexSettings actual) {
        Analysis expectedAnalysis = expected.getAnalysis();
        if (expectedAnalysis != null) {
            this.validateAnalysisSettings(errorCollector, expectedAnalysis, actual.getAnalysis());
        }
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.CUSTOM_INDEX_SETTINGS_ATTRIBUTE, "max_result_window", expected.getMaxResultWindow(), actual.getMaxResultWindow(), 10000);
        this.extraAttributeValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.CUSTOM_INDEX_SETTINGS_ATTRIBUTE, ElasticsearchValidationMessages.INSTANCE.customIndexSettingAttributeMissing(), expected.getExtraAttributes(), actual.getExtraAttributes());
    }

    private void validateAnalysisSettings(ValidationErrorCollector errorCollector, Analysis expectedAnalysis, Analysis actualAnalysis) {
        if (expectedAnalysis == null || expectedAnalysis.isEmpty()) {
            return;
        }
        this.analyzerDefinitionValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.ANALYZER, ElasticsearchValidationMessages.INSTANCE.analyzerMissing(), expectedAnalysis.getAnalyzers(), actualAnalysis == null ? null : actualAnalysis.getAnalyzers());
        this.normalizerDefinitionValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.NORMALIZER, ElasticsearchValidationMessages.INSTANCE.normalizerMissing(), expectedAnalysis.getNormalizers(), actualAnalysis == null ? null : actualAnalysis.getNormalizers());
        this.charFilterDefinitionValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.CHAR_FILTER, ElasticsearchValidationMessages.INSTANCE.charFilterMissing(), expectedAnalysis.getCharFilters(), actualAnalysis == null ? null : actualAnalysis.getCharFilters());
        this.tokenizerDefinitionValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.TOKENIZER, ElasticsearchValidationMessages.INSTANCE.tokenizerMissing(), expectedAnalysis.getTokenizers(), actualAnalysis == null ? null : actualAnalysis.getTokenizers());
        this.tokenFilterDefinitionValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.TOKEN_FILTER, ElasticsearchValidationMessages.INSTANCE.tokenFilterMissing(), expectedAnalysis.getTokenFilters(), actualAnalysis == null ? null : actualAnalysis.getTokenFilters());
        this.extraAttributeValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.CUSTOM_INDEX_SETTINGS_ATTRIBUTE, ElasticsearchValidationMessages.INSTANCE.customIndexSettingAttributeMissing(), expectedAnalysis.getExtraAttributes(), actualAnalysis == null ? null : actualAnalysis.getExtraAttributes());
    }
}

