/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Wait;
import org.fusesource.hawtbuf.Buffer;
import org.junit.Test;

public class AmqpProtocolHeaderHandlingTest
extends AmqpClientTestSupport {
    @Override
    protected boolean isSecurityEnabled() {
        return true;
    }

    @Test(timeout=60000L)
    public void testNonSaslHeaderRejectedOnConnect() throws Exception {
        final AmqpHeader header = new AmqpHeader();
        header.setProtocolId(0);
        header.setMajor(1);
        header.setMinor(0);
        header.setRevision(0);
        final ClientConnection connection = new ClientConnection();
        connection.open("localhost", 5672);
        connection.send(header);
        AmqpHeader response = connection.readAmqpHeader();
        AmqpProtocolHeaderHandlingTest.assertNotNull((Object)response);
        AmqpProtocolHeaderHandlingTest.assertEquals((long)3L, (long)response.getProtocolId());
        AmqpProtocolHeaderHandlingTest.assertTrue((String)"Broker should have closed client connection", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                try {
                    connection.send(header);
                    return false;
                }
                catch (Exception e) {
                    return true;
                }
            }
        }, (long)TimeUnit.SECONDS.toMillis(15L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
    }

    private class AmqpHeader {
        final Buffer PREFIX = new Buffer(new byte[]{65, 77, 81, 80});
        private Buffer buffer;

        AmqpHeader() {
            this(new Buffer(new byte[]{65, 77, 81, 80, 0, 1, 0, 0}));
        }

        AmqpHeader(Buffer buffer) {
            this(buffer, true);
        }

        AmqpHeader(Buffer buffer, boolean validate) {
            this.setBuffer(buffer, validate);
        }

        public int getProtocolId() {
            return this.buffer.get(4) & 0xFF;
        }

        public void setProtocolId(int value) {
            this.buffer.data[this.buffer.offset + 4] = (byte)value;
        }

        public int getMajor() {
            return this.buffer.get(5) & 0xFF;
        }

        public void setMajor(int value) {
            this.buffer.data[this.buffer.offset + 5] = (byte)value;
        }

        public int getMinor() {
            return this.buffer.get(6) & 0xFF;
        }

        public void setMinor(int value) {
            this.buffer.data[this.buffer.offset + 6] = (byte)value;
        }

        public int getRevision() {
            return this.buffer.get(7) & 0xFF;
        }

        public void setRevision(int value) {
            this.buffer.data[this.buffer.offset + 7] = (byte)value;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        public void setBuffer(Buffer value) {
            this.setBuffer(value, true);
        }

        public void setBuffer(Buffer value, boolean validate) {
            if (validate && !value.startsWith(this.PREFIX) || value.length() != 8) {
                throw new IllegalArgumentException("Not an AMQP header buffer");
            }
            this.buffer = value.buffer();
        }

        public boolean hasValidPrefix() {
            return this.buffer.startsWith(this.PREFIX);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.buffer.length(); ++i) {
                char value = (char)this.buffer.get(i);
                if (Character.isLetter(value)) {
                    builder.append(value);
                    continue;
                }
                builder.append(",");
                builder.append((int)value);
            }
            return builder.toString();
        }
    }

    private class ClientConnection {
        protected static final long RECEIVE_TIMEOUT = 10000L;
        protected Socket clientSocket;

        private ClientConnection() {
        }

        public void open(String host, int port) throws IOException {
            this.clientSocket = new Socket(host, port);
            this.clientSocket.setTcpNoDelay(true);
        }

        public void send(AmqpHeader header) throws Exception {
            OutputStream outputStream = this.clientSocket.getOutputStream();
            header.getBuffer().writeTo(outputStream);
            outputStream.flush();
        }

        public AmqpHeader readAmqpHeader() throws Exception {
            this.clientSocket.setSoTimeout(10000);
            InputStream is = this.clientSocket.getInputStream();
            byte[] header = new byte[8];
            int read = is.read(header);
            if (read == header.length) {
                return new AmqpHeader(new Buffer(header));
            }
            return null;
        }
    }
}

