/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class CommitRollbackTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString addressB = new SimpleString("addressB");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueB = new SimpleString("queueB");
    public final SimpleString queueC = new SimpleString("queueC");

    @Test
    public void testReceiveWithCommit() throws Exception {
        int i;
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, false, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 100;
        for (i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        session.start();
        for (i = 0; i < numMessages; ++i) {
            ClientMessage cm = cc.receive(5000L);
            Assert.assertNotNull((Object)cm);
            cm.acknowledge();
        }
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        session.commit();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
        session.close();
        sendSession.close();
    }

    @Test
    public void testReceiveWithRollback() throws Exception {
        int i;
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, false, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 100;
        for (i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        session.start();
        for (i = 0; i < numMessages; ++i) {
            ClientMessage cm = cc.receive(5000L);
            Assert.assertNotNull((Object)cm);
            cm.acknowledge();
        }
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        session.rollback();
        for (int i2 = 0; i2 < numMessages; ++i2) {
            ClientMessage cm = cc.receive(5000L);
            Assert.assertNotNull((Object)cm);
            cm.acknowledge();
        }
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        session.close();
        sendSession.close();
    }

    @Test
    public void testReceiveWithRollbackMultipleConsumersDifferentQueues() throws Exception {
        int i;
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, false, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        sendSession.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressB).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientProducer cp2 = sendSession.createProducer(this.addressB);
        ClientConsumer cc = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueB);
        int numMessages = 100;
        for (i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
            cp2.send((Message)sendSession.createMessage(false));
        }
        session.start();
        for (i = 0; i < numMessages; ++i) {
            ClientMessage cm = cc.receive(5000L);
            Assert.assertNotNull((Object)cm);
            cm.acknowledge();
            cm = cc2.receive(5000L);
            Assert.assertNotNull((Object)cm);
            cm.acknowledge();
        }
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Queue q2 = (Queue)server.getPostOffice().getBinding(this.queueB).getBindable();
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        cc.close();
        cc2.close();
        session.rollback();
        Assert.assertEquals((long)0L, (long)q2.getDeliveringCount());
        Assert.assertEquals((long)numMessages, (long)this.getMessageCount(q));
        Assert.assertEquals((long)0L, (long)q2.getDeliveringCount());
        Assert.assertEquals((long)numMessages, (long)this.getMessageCount(q));
        sendSession.close();
        session.close();
    }

    @Test
    public void testAsyncConsumerCommit() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        final ClientSession session = cf.createSession(false, true, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        final CountDownLatch latch = new CountDownLatch(numMessages);
        session.start();
        cc.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException e) {
                    try {
                        session.close();
                    }
                    catch (ActiveMQException e1) {
                        e1.printStackTrace();
                    }
                }
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        Assert.assertEquals((long)numMessages, (long)this.getMessageCount(q));
        session.commit();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
        Assert.assertEquals((long)0L, (long)this.getMessageCount(q));
        sendSession.close();
        session.close();
    }

    @Test
    public void testAsyncConsumerRollback() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, true, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        CountDownLatch latch = new CountDownLatch(numMessages);
        session.start();
        cc.setMessageHandler((MessageHandler)new ackHandler(session, latch));
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        Assert.assertEquals((long)numMessages, (long)this.getMessageCount(q));
        session.stop();
        session.rollback();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
        Assert.assertEquals((long)numMessages, (long)this.getMessageCount(q));
        latch = new CountDownLatch(numMessages);
        cc.setMessageHandler((MessageHandler)new ackHandler(session, latch));
        session.start();
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        sendSession.close();
        session.close();
        cf.close();
    }

    private static class ackHandler
    implements MessageHandler {
        private final ClientSession session;
        private final CountDownLatch latch;

        private ackHandler(ClientSession session, CountDownLatch latch) {
            this.session = session;
            this.latch = latch;
        }

        public void onMessage(ClientMessage message) {
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                try {
                    this.session.close();
                }
                catch (ActiveMQException e1) {
                    e1.printStackTrace();
                }
            }
            this.latch.countDown();
        }
    }
}

