/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class ExpireTestOnRestartTest
extends ActiveMQTestBase {
    ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true);
        AddressSettings setting = new AddressSettings().setExpiryAddress(SimpleString.toSimpleString((String)"exp")).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setPageSizeBytes(102400).setMaxSizeBytes(204800L);
        this.server.getConfiguration().setJournalSyncNonTransactional(false);
        this.server.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server.getConfiguration().setJournalSyncTransactional(false);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)setting);
        this.server.start();
    }

    @Test
    public void testRestartWithExpire() throws Exception {
        ClientMessage msg;
        ClientMessage message;
        int i;
        int NUMBER_OF_EXPIRED_MESSAGES = 1000;
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnDurableSend(false);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(true, true);
        session.createQueue(new QueueConfiguration("test"));
        session.createQueue(new QueueConfiguration("exp"));
        ClientProducer prod = session.createProducer("test");
        for (i = 0; i < 10; ++i) {
            message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(new byte[10240]);
            prod.send((Message)message);
        }
        for (i = 0; i < NUMBER_OF_EXPIRED_MESSAGES; ++i) {
            message = session.createMessage(true);
            message.putIntProperty("i", i);
            message.getBodyBuffer().writeBytes(new byte[10240]);
            message.setExpiration(System.currentTimeMillis() + 5000L);
            prod.send((Message)message);
        }
        session.commit();
        session.close();
        this.server.stop();
        this.server.getConfiguration().setMessageExpiryScanPeriod(1L);
        Thread.sleep(5500L);
        this.server.start();
        Queue queue = this.server.locateQueue(SimpleString.toSimpleString((String)"test"));
        factory = locator.createSessionFactory();
        session = factory.createSession(false, false);
        ClientConsumer cons = session.createConsumer("test");
        session.start();
        for (int i2 = 0; i2 < 10; ++i2) {
            ClientMessage msg2 = cons.receive(5000L);
            ExpireTestOnRestartTest.assertNotNull((Object)msg2);
            msg2.acknowledge();
        }
        ExpireTestOnRestartTest.assertNull((Object)cons.receiveImmediate());
        cons.close();
        long timeout = System.currentTimeMillis() + 60000L;
        while (queue.getPageSubscription().getPagingStore().isPaging() && timeout > System.currentTimeMillis()) {
            Thread.sleep(1L);
        }
        ExpireTestOnRestartTest.assertFalse((boolean)queue.getPageSubscription().getPagingStore().isPaging());
        cons = session.createConsumer("exp");
        for (int i3 = 0; i3 < NUMBER_OF_EXPIRED_MESSAGES; ++i3) {
            msg = cons.receive(5000L);
            ExpireTestOnRestartTest.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        session.commit();
        int extras = 0;
        while ((msg = cons.receiveImmediate()) != null) {
            this.instanceLog.debug((Object)msg);
            ++extras;
        }
        ExpireTestOnRestartTest.assertEquals((String)"Received extra messages on expire address", (long)0L, (long)extras);
        session.commit();
        session.close();
        locator.close();
    }
}

