/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import io.netty.bootstrap.Bootstrap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class NettyConnectorTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultNettyConfig());
        this.server.start();
    }

    @Test
    public void testConnectionTimeoutConfig() throws Exception {
        int timeout = 23456;
        TransportConfiguration transport = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        transport.getParams().put("connect-timeout-millis", 23456);
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transport});
        ClientSessionFactoryImpl factory = (ClientSessionFactoryImpl)locator.createSessionFactory();
        NettyConnector connector = (NettyConnector)factory.getConnector();
        Bootstrap bootstrap = connector.getBootStrap();
        NettyConnectorTest.assertEquals((long)23456L, (long)bootstrap.register().channel().config().getConnectTimeoutMillis());
        factory.close();
        locator.close();
    }
}

