/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.clientcrash.ClientTestBase;
import org.apache.activemq.artemis.tests.integration.clientcrash.CrashClient;
import org.apache.activemq.artemis.tests.integration.clientcrash.CrashClient2;
import org.apache.activemq.artemis.tests.util.SpawnedVMCheck;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ClientCrashTest
extends ClientTestBase {
    private static final Logger log = Logger.getLogger(ClientCrashTest.class);
    @Rule
    public SpawnedVMCheck spawnedVMCheck = new SpawnedVMCheck();
    static final int PING_PERIOD = 100;
    static final int CONNECTION_TTL = 1000;
    public static final SimpleString QUEUE = new SimpleString("ClientCrashTestQueue");
    public static final SimpleString QUEUE2 = new SimpleString("ClientCrashTestQueue2");
    public static final String MESSAGE_TEXT_FROM_SERVER = "ClientCrashTest from server";
    public static final String MESSAGE_TEXT_FROM_CLIENT = "ClientCrashTest from client";
    private ClientSessionFactory sf;
    private ServerLocator locator;
    Process p;

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.p != null) {
            long timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && this.p.isAlive()) {
                this.p.destroy();
            }
        }
    }

    @Test
    public void testCrashClient() throws Exception {
        this.assertActiveConnections(1);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        this.p = SpawnedVMSupport.spawnVM((String)CrashClient.class.getName(), (String[])new String[0]);
        Assert.assertTrue((boolean)this.p.waitFor(1L, TimeUnit.MINUTES));
        Assert.assertEquals((long)CrashClient.OK, (long)this.p.exitValue());
        ClientConsumer consumer = session.createConsumer(QUEUE);
        ClientProducer producer = session.createProducer(QUEUE);
        session.start();
        ClientMessage messageFromClient = consumer.receive(5000L);
        ClientCrashTest.assertNotNull((String)"no message received", (Object)messageFromClient);
        ClientCrashTest.assertEquals((Object)MESSAGE_TEXT_FROM_CLIENT, (Object)messageFromClient.getBodyBuffer().readString());
        this.assertActiveConnections(1);
        this.assertActiveSession(1);
        ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString(MESSAGE_TEXT_FROM_SERVER);
        producer.send((Message)message);
        ClientCrashTest.assertEquals((long)9L, (long)this.p.exitValue());
        long timeout = 11100L;
        this.assertActiveConnections(1, timeout);
        this.assertActiveSession(1, timeout);
        session.close();
        this.assertActiveConnections(1);
        this.assertActiveSession(0);
    }

    @Test
    public void testCrashClient2() throws Exception {
        AddressSettings addressSettings = new AddressSettings().setRedeliveryDelay(1100L);
        this.server.getAddressSettingsRepository().addMatch(QUEUE2.toString(), (Object)addressSettings);
        this.assertActiveConnections(1);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE2).setDurable(Boolean.valueOf(false)));
        this.p = SpawnedVMSupport.spawnVM((String)CrashClient2.class.getName(), (String[])new String[0]);
        log.debug((Object)"waiting for the client VM to crash ...");
        Assert.assertTrue((boolean)this.p.waitFor(1L, TimeUnit.MINUTES));
        ClientCrashTest.assertEquals((long)9L, (long)this.p.exitValue());
        long timeout = 11100L;
        this.assertActiveConnections(1, timeout);
        this.assertActiveSession(1, timeout);
        ClientConsumer consumer = session.createConsumer(QUEUE2);
        session.start();
        ClientMessage messageFromClient = consumer.receive(timeout);
        ClientCrashTest.assertNotNull((String)"no message received", (Object)messageFromClient);
        ClientCrashTest.assertEquals((Object)MESSAGE_TEXT_FROM_CLIENT, (Object)messageFromClient.getBodyBuffer().readString());
        ClientCrashTest.assertEquals((String)"delivery count", (long)2L, (long)messageFromClient.getDeliveryCount());
        consumer.close();
        session.close();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createNettyNonHALocator();
        this.addServerLocator(this.locator);
        this.locator.setClientFailureCheckPeriod(100L);
        this.locator.setConnectionTTL(1000L);
        this.sf = this.createSessionFactory(this.locator);
    }
}

