/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.jboss.logging.Logger;

public class DummyInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(DummyInterceptor.class);
    boolean sendException = false;
    boolean changeMessage = false;
    AtomicInteger syncCounter = new AtomicInteger(0);

    public int getCounter() {
        return this.syncCounter.get();
    }

    public void clearCounter() {
        this.syncCounter.set(0);
    }

    public boolean intercept(Packet packet, RemotingConnection conn) throws ActiveMQException {
        log.debug((Object)("DummyFilter packet = " + packet.getClass().getName()));
        this.syncCounter.addAndGet(1);
        if (this.sendException) {
            throw new ActiveMQInternalErrorException();
        }
        if (this.changeMessage && packet instanceof SessionReceiveMessage) {
            SessionReceiveMessage deliver = (SessionReceiveMessage)packet;
            log.debug((Object)("msg = " + deliver.getMessage().getClass().getName()));
            deliver.getMessage().putStringProperty(new SimpleString("DummyInterceptor"), new SimpleString("was here"));
        }
        return true;
    }
}

