/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.jboss.logging.Logger;

public class GracefulClient {
    private static final Logger log = Logger.getLogger(GracefulClient.class);

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Exception("require 2 arguments: queue name + message text");
        }
        String queueName = args[0];
        String messageText = args[1];
        try {
            ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName())});
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, true, true);
            ClientProducer producer = session.createProducer(queueName);
            ClientConsumer consumer = session.createConsumer(queueName);
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.getBodyBuffer().writeString(messageText);
            producer.send((Message)message);
            session.start();
            consumer.receive(5000L);
            session.close();
            System.exit(0);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            System.exit(1);
        }
    }
}

