/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQUnBlockedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class AsynchronousFailoverTest
extends FailoverTestBase {
    private static final Logger log = Logger.getLogger(AsynchronousFailoverTest.class);
    private volatile CountDownSessionFailureListener listener;
    private volatile ClientSessionFactoryInternal sf;
    private final Object lockFail = new Object();

    @Test
    public void testNonTransactional() throws Throwable {
        this.runTest(new TestRunner(){

            @Override
            public void run() {
                try {
                    AsynchronousFailoverTest.this.doTestNonTransactional(this);
                }
                catch (Throwable e) {
                    log.error((Object)"Test failed", e);
                    this.addException(e);
                }
            }
        });
    }

    @Test
    public void testTransactional() throws Throwable {
        this.runTest(new TestRunner(){
            volatile boolean running = false;

            @Override
            public void run() {
                try {
                    Assert.assertFalse((boolean)this.running);
                    this.running = true;
                    try {
                        AsynchronousFailoverTest.this.doTestTransactional(this);
                    }
                    finally {
                        this.running = false;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Test failed", e);
                    this.addException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(TestRunner runnable) throws Throwable {
        boolean numIts = true;
        for (int i = 0; i < 1; ++i) {
            log.debug((Object)("Iteration " + i));
            ServerLocator locator = this.getServerLocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(30).setRetryInterval(100L).setConfirmationWindowSize(0xA00000).setCallTimeout(10000L).setCallFailoverTimeout(10000L);
            this.sf = this.createSessionFactoryAndWaitForTopology(locator, 2);
            try {
                ClientSession createSession = this.sf.createSession(true, true);
                createSession.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS).setAddress(FailoverTestBase.ADDRESS));
                RemotingConnection conn = ((ClientSessionInternal)createSession).getConnection();
                Thread t = new Thread(runnable);
                t.setName("MainTEST");
                t.start();
                long randomDelay = (long)(2000.0 * Math.random());
                log.debug((Object)("Sleeping " + randomDelay));
                Thread.sleep(randomDelay);
                log.debug((Object)"Failing asynchronously");
                Object object = this.lockFail;
                synchronized (object) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"#test crashing test");
                    }
                    this.crash(createSession);
                }
                runnable.setFailed();
                log.debug((Object)"Fail complete");
                t.join(TimeUnit.SECONDS.toMillis(120L));
                if (t.isAlive()) {
                    System.out.println(AsynchronousFailoverTest.threadDump((String)"Thread still running from the test"));
                    t.interrupt();
                    AsynchronousFailoverTest.fail((String)"Test didn't complete successful, thread still running");
                }
                runnable.checkForExceptions();
                createSession.close();
                Assert.assertEquals((long)0L, (long)this.sf.numSessions());
                locator.close();
            }
            finally {
                locator.close();
                Assert.assertEquals((long)0L, (long)this.sf.numConnections());
            }
            if (i == 0) continue;
            this.tearDown();
            runnable.checkForExceptions();
            runnable.reset();
            this.setUp();
        }
    }

    protected void addPayload(ClientMessage msg) {
    }

    private void doTestNonTransactional(TestRunner runner) throws Exception {
        while (!runner.isFailed()) {
            ClientMessage message;
            boolean retry;
            log.debug((Object)"looping");
            ClientSession session = this.sf.createSession(true, true, 0);
            this.listener = new CountDownSessionFailureListener(session);
            session.addFailureListener((SessionFailureListener)this.listener);
            ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
            int numMessages = 1000;
            for (int i = 0; i < 1000; ++i) {
                retry = false;
                do {
                    try {
                        ClientMessage message2 = session.createMessage(true);
                        message2.getBodyBuffer().writeString("message" + i);
                        message2.putIntProperty("counter", i);
                        this.addPayload(message2);
                        producer.send((Message)message2);
                        retry = false;
                    }
                    catch (ActiveMQUnBlockedException ube) {
                        log.debug((Object)("exception when sending message with counter " + i));
                        ube.printStackTrace();
                        retry = true;
                    }
                    catch (ActiveMQException e) {
                        AsynchronousFailoverTest.fail((String)("Invalid Exception type:" + e.getType()));
                    }
                } while (retry);
            }
            ClientConsumer consumer = null;
            retry = false;
            do {
                try {
                    consumer = session.createConsumer(FailoverTestBase.ADDRESS);
                    retry = false;
                }
                catch (ActiveMQUnBlockedException ube) {
                    log.debug((Object)"exception when creating consumer");
                    retry = true;
                }
                catch (ActiveMQException e) {
                    AsynchronousFailoverTest.fail((String)("Invalid Exception type:" + e.getType()));
                }
            } while (retry);
            session.start();
            ArrayList<Integer> counts = new ArrayList<Integer>(1000);
            int lastCount = -1;
            boolean counterGap = false;
            while ((message = consumer.receive(500L)) != null) {
                int count = message.getIntProperty("counter");
                counts.add(count);
                if (count != lastCount + 1) {
                    if (counterGap) {
                        Assert.fail((String)("got another counter gap at " + count + ": " + counts));
                    } else if (lastCount != -1) {
                        log.debug((Object)("got first counter gap at " + count));
                        counterGap = true;
                    }
                }
                lastCount = count;
                message.acknowledge();
            }
            session.close();
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestTransactional(TestRunner runner) throws Throwable {
        int executionId = 0;
        if (!runner.isFailed()) {
            log.debug((Object)("#test doTestTransactional starting now. Execution " + ++executionId));
            try (ClientSession session = null;){
                boolean retry = false;
                int numMessages = 1000;
                int retryCreateSession = 4;
                while (session == null) {
                    try {
                        session = this.sf.createSession(true, false);
                    }
                    catch (ActiveMQException e) {
                        if (retryCreateSession == 0) {
                            throw e;
                        }
                        --retryCreateSession;
                        Thread.sleep(2000L);
                    }
                }
                this.listener = new CountDownSessionFailureListener(session);
                session.addFailureListener((SessionFailureListener)this.listener);
            }
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    abstract class TestRunner
    implements Runnable {
        volatile boolean failed;
        ArrayList<Throwable> errors = new ArrayList();

        TestRunner() {
        }

        boolean isFailed() {
            return this.failed;
        }

        void setFailed() {
            this.failed = true;
        }

        void reset() {
            this.failed = false;
        }

        synchronized void addException(Throwable e) {
            this.errors.add(e);
        }

        void checkForExceptions() throws Throwable {
            if (this.errors.size() > 0) {
                log.warn((Object)"Exceptions on test:");
                for (Throwable e : this.errors) {
                    log.warn((Object)e.getMessage(), e);
                }
                throw this.errors.get(0);
            }
        }
    }
}

