/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ClusterWithBackupFailoverTestBase;
import org.junit.Test;

public abstract class ClusterWithBackupFailoverTest
extends ClusterWithBackupFailoverTestBase {
    @Test
    public void testFailLiveNodes() throws Throwable {
        this.setupCluster();
        this.startServers(3, 4, 5, 0, 1, 2);
        for (int i = 0; i < 3; ++i) {
            ClusterWithBackupFailoverTest.waitForTopology((ActiveMQServer)this.servers[i], (int)3, (int)3);
        }
        this.waitForFailoverTopology(3, 0, 1, 2);
        this.waitForFailoverTopology(4, 0, 1, 2);
        this.waitForFailoverTopology(5, 0, 1, 2);
        this.setupSessionFactory(0, 3, this.isNetty(), false);
        this.setupSessionFactory(1, 4, this.isNetty(), false);
        this.setupSessionFactory(2, 5, this.isNetty(), false);
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings();
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        Thread.sleep(1000L);
        log.debug((Object)("######### Topology on client = " + this.locators[0].getTopology().describe() + " locator = " + this.locators[0]));
        log.debug((Object)("######### Crashing it........., sfs[0] = " + this.sfs[0]));
        this.failNode(0);
        this.waitForFailoverTopology(4, 3, 1, 2);
        this.waitForFailoverTopology(5, 3, 1, 2);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.waitForBindings(3, "queues.testaddress", 2, 2, false);
        ClusterWithBackupFailoverTestBase.log.debug((Object)"** now sending");
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.failNode(1);
        this.waitForFailoverTopology(5, 3, 4, 2);
        Thread.sleep(1000L);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.waitForBindings(3, "queues.testaddress", 2, 2, false);
        this.waitForBindings(4, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.failNode(2);
        Thread.sleep(1000L);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(5, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 2, 2, false);
        this.waitForBindings(4, "queues.testaddress", 2, 2, false);
        this.waitForBindings(5, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.removeConsumer(0);
        this.removeConsumer(1);
        this.removeConsumer(2);
    }

    @Test
    public void testFailBackupNodes() throws Exception {
        this.setupCluster();
        this.startServers(3, 4, 5, 0, 1, 2);
        for (int i = 0; i < 3; ++i) {
            ClusterWithBackupFailoverTest.waitForTopology((ActiveMQServer)this.servers[i], (int)3, (int)3);
        }
        this.setupSessionFactory(0, 3, this.isNetty(), false);
        this.setupSessionFactory(1, 4, this.isNetty(), false);
        this.setupSessionFactory(2, 5, this.isNetty(), false);
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings();
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.failNode(3);
        this.waitForBindings();
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.failNode(4);
        this.waitForBindings();
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.failNode(5);
        this.waitForBindings();
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.removeConsumer(0);
        this.removeConsumer(1);
        this.removeConsumer(2);
    }

    @Test
    public void testFailAllNodes() throws Exception {
        this.setupCluster();
        this.startServers(0, 1, 2, 3, 4, 5);
        this.setupSessionFactory(0, 3, this.isNetty(), false);
        this.setupSessionFactory(1, 4, this.isNetty(), false);
        this.setupSessionFactory(2, 5, this.isNetty(), false);
        this.waitForFailoverTopology(3, 0, 1, 2);
        this.waitForFailoverTopology(4, 0, 1, 2);
        this.waitForFailoverTopology(5, 0, 1, 2);
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings();
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.failNode(0);
        this.waitForFailoverTopology(4, 3, 1, 2);
        this.waitForFailoverTopology(5, 3, 1, 2);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.waitForBindings(3, "queues.testaddress", 2, 2, false);
        ClusterWithBackupFailoverTestBase.log.debug((Object)"** now sending");
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        this.removeConsumer(0);
        this.failNode(3);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.waitForBindings(2, "queues.testaddress", 1, 1, false);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 1, 2);
        this.failNode(1);
        this.waitForFailoverTopology(5, 2, 4);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, false);
        this.waitForBindings(4, "queues.testaddress", 1, 1, false);
        this.send(1, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 1, 2);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 1, 2);
        this.removeConsumer(1);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, false);
        this.failNode(4, 1);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 2);
        this.failNode(2);
        this.waitForBindings(5, "queues.testaddress", 1, 1, true);
        this.waitForBindings(5, "queues.testaddress", 0, 0, false);
        this.send(2, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 2);
        this.removeConsumer(2);
        this.failNode(5);
    }
}

