/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;

public abstract class MultipleBackupsFailoverTestBase
extends ActiveMQTestBase {
    protected abstract boolean isNetty();

    /*
     * Unable to fully structure code
     */
    protected int waitForNewLive(long seconds, boolean waitForNewBackup, Map<Integer, TestableServer> servers, int ... nodes) {
        time = System.currentTimeMillis();
        toWait = seconds * 1000L;
        newLive = -1;
        while (true) {
            for (int node : nodes) {
                backupServer = servers.get(node);
                if (newLive == -1 && backupServer.isActive()) {
                    newLive = node;
                    continue;
                }
                if (newLive == -1) continue;
                if (waitForNewBackup) {
                    if (node == newLive || !servers.get(node).isStarted()) continue;
                    return newLive;
                }
                return newLive;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException var11_9) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= time + toWait) ** continue;
            Assert.fail((String)"backup server never started");
        }
    }

    protected ClientSession sendAndConsume(ClientSessionFactory sf, boolean createQueue) throws Exception {
        ClientSession session = sf.createSession(false, true, true);
        if (createQueue) {
            session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive(10000L);
            Assert.assertNotNull((Object)message2);
            Assert.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            Assert.assertEquals((Object)i, (Object)message2.getObjectProperty(new SimpleString("count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        Assert.assertNull((Object)message3);
        return session;
    }

    protected ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, int topologyMembers) throws Exception {
        return this.createSessionFactoryAndWaitForTopology(locator, topologyMembers, null);
    }

    protected ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, int topologyMembers, ActiveMQServer server) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers);
        FailoverTestBase.LatchClusterTopologyListener topListener = new FailoverTestBase.LatchClusterTopologyListener(countDownLatch);
        locator.addClusterTopologyListener((ClusterTopologyListener)topListener);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.addSessionFactory((ClientSessionFactory)sf);
        boolean ok = countDownLatch.await(5L, TimeUnit.SECONDS);
        locator.removeClusterTopologyListener((ClusterTopologyListener)topListener);
        if (!ok && server != null) {
            this.instanceLog.warn((Object)("failed topology, Topology on server = " + server.getClusterManager().describe()));
        }
        Assert.assertTrue((String)("expected " + topologyMembers + " members"), (boolean)ok);
        return sf;
    }

    public ServerLocator getServerLocator(int ... nodes) {
        TransportConfiguration[] configs = new TransportConfiguration[nodes.length];
        int configsLength = configs.length;
        for (int i = 0; i < configsLength; ++i) {
            configs[i] = MultipleBackupsFailoverTestBase.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)MultipleBackupsFailoverTestBase.generateParams((int)nodes[i], (boolean)this.isNetty()));
        }
        return this.addServerLocator((ServerLocator)new ServerLocatorImpl(true, configs));
    }
}

