/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ReplicatedVotingFailoverTest
extends FailoverTestBase {
    boolean testBackupFailsVoteFails = false;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            ReplicatedVotingFailoverTest.this.testBackupFailsVoteFails = description.getMethodName().equals("testBackupFailsVoteFails");
        }
    };

    protected void beforeWaitForRemoteBackupSynchronization() {
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackupFailsVoteSuccess() throws Exception {
        try {
            this.beforeWaitForRemoteBackupSynchronization();
            ReplicatedVotingFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
            this.backupServer.stop();
            ServerLocator locator = this.createInVMLocator(0);
            ClientSessionFactory sessionFactory = locator.createSessionFactory();
            ClientSession session = sessionFactory.createSession();
            this.addClientSession(session);
            ClientProducer producer = session.createProducer("testAddress");
            producer.send((Message)session.createMessage(true));
            ReplicatedVotingFailoverTest.assertTrue((boolean)this.liveServer.isActive());
        }
        finally {
            try {
                this.liveServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackupFailsVoteFails() throws Exception {
        try {
            this.beforeWaitForRemoteBackupSynchronization();
            ReplicatedVotingFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
            this.backupServer.stop();
            try {
                ServerLocator locator = this.createInVMLocator(0);
                ClientSessionFactory sessionFactory = locator.createSessionFactory();
                ClientSession session = sessionFactory.createSession();
                this.addClientSession(session);
                ClientProducer producer = session.createProducer("testAddress");
                producer.send((Message)session.createMessage(true));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.waitForServerToStop(this.liveServer.getServer());
            ReplicatedVotingFailoverTest.assertFalse((boolean)this.liveServer.isStarted());
        }
        finally {
            try {
                this.liveServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicatedPolicyConfiguration)this.liveConfig.getHAPolicyConfiguration()).setCheckForLiveServer(true);
        ((ReplicatedPolicyConfiguration)this.liveConfig.getHAPolicyConfiguration()).setVoteOnReplicationFailure(true);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
        if (this.testBackupFailsVoteFails) {
            ((ReplicatedPolicyConfiguration)this.liveConfig.getHAPolicyConfiguration()).setQuorumSize(2);
        }
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                ReplicatedVotingFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            ReplicatedVotingFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                ReplicatedVotingFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            ReplicatedVotingFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(sessions);
    }
}

