/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.FakeQueue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.Assert;
import org.junit.Test;

public class RedeployTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAutoCreateAddress() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-test-autocreateaddress.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-test-autocreateaddress-reload.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession();
            jakarta.jms.Queue queue = session.createQueue("autoQueue");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("text"));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("autoQueue"));
            Assert.assertNotNull((String)"Address wasn't autocreated accordingly", (Object)consumer.receive(5000L));
        }
        Assert.assertNotNull((Object)this.getQueue(embeddedActiveMQ, "autoQueue"));
        embeddedActiveMQ.getActiveMQServer().getPostOffice().addBinding((Binding)new RemoteQueueBindingImpl(5L, new SimpleString("autoQueue"), new SimpleString("uniqueName"), new SimpleString("routingName"), Long.valueOf(6L), null, (Queue)new FakeQueue(new SimpleString("foo"), 6L), new SimpleString("bridge"), 1, MessageLoadBalancingType.OFF));
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)this.tryConsume());
            Assert.assertNotNull((Object)this.getQueue(embeddedActiveMQ, "autoQueue"));
            factory = new ActiveMQConnectionFactory();
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession();
                jakarta.jms.Queue queue = session.createQueue("autoQueue");
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text"));
                connection.start();
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("autoQueue"));
                Assert.assertNotNull((String)"autoQueue redeployed accordingly", (Object)consumer.receive(5000L));
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeploy() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-test-jms.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-test-updated-jms.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)"DLQ", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getDeadLetterAddress().toString());
            Assert.assertEquals((Object)"ExpiryQueue", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getExpiryAddress().toString());
            Assert.assertFalse((boolean)this.tryConsume());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)this.tryConsume());
            Assert.assertEquals((Object)"NewQueue", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getDeadLetterAddress().toString());
            Assert.assertEquals((Object)"NewQueue", (Object)((AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("jms")).getExpiryAddress().toString());
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession();
                jakarta.jms.Queue queue = session.createQueue("DivertQueue");
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text"));
                connection.start();
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("NewQueue"));
                Assert.assertNotNull((String)"Divert wasn't redeployed accordingly", (Object)consumer.receive(5000L));
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeploySecuritySettings() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-security-settings.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-security-settings-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Set roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            boolean found = false;
            for (Role role : roles) {
                if (!role.getName().equals("a")) continue;
                found = true;
            }
            RedeployTest.assertTrue((boolean)found);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            found = false;
            for (Role role : roles) {
                if (!role.getName().equals("b")) continue;
                found = true;
            }
            RedeployTest.assertTrue((boolean)found);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeploySecuritySettingsWithManagementChange() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-security-settings.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-security-settings-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Set roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            boolean found = false;
            for (Role role : roles) {
                if (!role.getName().equals("a")) continue;
                found = true;
            }
            RedeployTest.assertTrue((boolean)found);
            embeddedActiveMQ.getActiveMQServer().getActiveMQServerControl().addSecuritySettings("bar", "c", "c", "c", "c", "c", "c", "c", "c", "c", "c");
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("bar");
            for (Role role : roles) {
                if (!role.getName().equals("c")) continue;
                found = true;
            }
            RedeployTest.assertTrue((boolean)found);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("foo");
            found = false;
            for (Role role : roles) {
                if (!role.getName().equals("b")) continue;
                found = true;
            }
            RedeployTest.assertTrue((boolean)found);
            roles = (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch("bar");
            found = false;
            for (Role role : roles) {
                if (!role.getName().equals("c")) continue;
                found = true;
            }
            RedeployTest.assertTrue((boolean)found);
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAddressSettingsWithManagementChange() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-address-settings.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-address-settings-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            AddressSettings addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("foo");
            RedeployTest.assertEquals((Object)"a", (Object)addressSettings.getDeadLetterAddress().toString());
            embeddedActiveMQ.getActiveMQServer().getActiveMQServerControl().addAddressSettings("bar", "c", null, 0L, false, 0, 0L, 0, 0, 0L, 0.0, 0L, 0L, false, null, 0L, 0L, null, false, false, false, false);
            addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("bar");
            RedeployTest.assertEquals((Object)"c", (Object)addressSettings.getDeadLetterAddress().toString());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("foo");
            RedeployTest.assertEquals((Object)"b", (Object)addressSettings.getDeadLetterAddress().toString());
            addressSettings = (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch("bar");
            RedeployTest.assertEquals((Object)"c", (Object)addressSettings.getDeadLetterAddress().toString());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployDivertsWithManagementChange() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-diverts.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-diverts-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("a"));
            RedeployTest.assertNotNull((Object)divertBinding);
            RedeployTest.assertEquals((Object)"a", (Object)divertBinding.getDivert().getAddress().toString());
            embeddedActiveMQ.getActiveMQServer().getActiveMQServerControl().createDivert("c", "c", "c", "target", false, null, null);
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("b"));
            RedeployTest.assertNotNull((Object)divertBinding);
            RedeployTest.assertEquals((Object)"b", (Object)divertBinding.getDivert().getAddress().toString());
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("c"));
            RedeployTest.assertNotNull((Object)divertBinding);
            RedeployTest.assertEquals((Object)"c", (Object)divertBinding.getDivert().getAddress().toString());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployFilter() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-queue-filter.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-queue-filter-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            Message message;
            jakarta.jms.Queue queue4;
            Throwable throwable;
            Session session4;
            Connection connection4;
            MessageConsumer consumer;
            Message message2;
            MessageProducer producer;
            jakarta.jms.Queue queue22;
            Throwable throwable2;
            Session session22;
            Throwable throwable3;
            Connection connection2;
            latch.await(10L, TimeUnit.SECONDS);
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection2 = factory.createConnection();
                throwable3 = null;
                try {
                    session22 = connection2.createSession(1);
                    throwable2 = null;
                    try {
                        connection2.start();
                        queue22 = session22.createQueue("myFilterQueue");
                        producer = session22.createProducer((Destination)queue22);
                        message2 = session22.createMessage();
                        message2.setStringProperty("x", "x");
                        producer.send(message2);
                        consumer = session22.createConsumer((Destination)queue22);
                        RedeployTest.assertNotNull((Object)consumer.receive(5000L));
                        consumer.close();
                    }
                    catch (Throwable queue22) {
                        throwable2 = queue22;
                        throw queue22;
                    }
                    finally {
                        if (session22 != null) {
                            if (throwable2 != null) {
                                try {
                                    session22.close();
                                }
                                catch (Throwable queue22) {
                                    throwable2.addSuppressed(queue22);
                                }
                            } else {
                                session22.close();
                            }
                        }
                    }
                }
                catch (Throwable session22) {
                    throwable3 = session22;
                    throw session22;
                }
                finally {
                    if (connection2 != null) {
                        if (throwable3 != null) {
                            try {
                                connection2.close();
                            }
                            catch (Throwable session22) {
                                throwable3.addSuppressed(session22);
                            }
                        } else {
                            connection2.close();
                        }
                    }
                }
            }
            factory = new ActiveMQConnectionFactory();
            var8_8 = null;
            try {
                connection2 = factory.createConnection();
                throwable3 = null;
                try {
                    session22 = connection2.createSession(1);
                    throwable2 = null;
                    try {
                        connection2.start();
                        queue22 = session22.createQueue("myFilterQueue");
                        producer = session22.createProducer((Destination)queue22);
                        message2 = session22.createTextMessage("hello");
                        message2.setStringProperty("x", "x");
                        producer.send(message2);
                    }
                    catch (Throwable queue3) {
                        throwable2 = queue3;
                        throw queue3;
                    }
                    finally {
                        if (session22 != null) {
                            if (throwable2 != null) {
                                try {
                                    session22.close();
                                }
                                catch (Throwable queue3) {
                                    throwable2.addSuppressed(queue3);
                                }
                            } else {
                                session22.close();
                            }
                        }
                    }
                }
                catch (Throwable session3) {
                    throwable3 = session3;
                    throw session3;
                }
                finally {
                    if (connection2 != null) {
                        if (throwable3 != null) {
                            try {
                                connection2.close();
                            }
                            catch (Throwable session3) {
                                throwable3.addSuppressed(session3);
                            }
                        } else {
                            connection2.close();
                        }
                    }
                }
            }
            catch (Throwable connection3) {
                var8_8 = connection3;
                throw connection3;
            }
            finally {
                if (factory != null) {
                    if (var8_8 != null) {
                        try {
                            factory.close();
                        }
                        catch (Throwable connection3) {
                            var8_8.addSuppressed(connection3);
                        }
                    } else {
                        factory.close();
                    }
                }
            }
            Binding binding = embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.toSimpleString((String)"myFilterQueue"));
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Binding bindingAfterChange = embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.toSimpleString((String)"myFilterQueue"));
            RedeployTest.assertTrue((String)"Instance should be the same (as should be non destructive)", (binding == bindingAfterChange ? (byte)1 : 0) != 0);
            RedeployTest.assertEquals((Object)binding.getID(), (Object)bindingAfterChange.getID());
            throwable3 = null;
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection4 = factory.createConnection();
                throwable2 = null;
                try {
                    session4 = connection4.createSession(1);
                    throwable = null;
                    try {
                        connection4.start();
                        queue4 = session4.createQueue("myFilterQueue");
                        consumer = session4.createConsumer((Destination)queue4);
                        message = consumer.receive(5000L);
                        RedeployTest.assertNotNull((Object)message);
                        RedeployTest.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
                        consumer.close();
                    }
                    catch (Throwable queue4) {
                        throwable = queue4;
                        throw queue4;
                    }
                    finally {
                        if (session4 != null) {
                            if (throwable != null) {
                                try {
                                    session4.close();
                                }
                                catch (Throwable queue4) {
                                    throwable.addSuppressed(queue4);
                                }
                            } else {
                                session4.close();
                            }
                        }
                    }
                }
                catch (Throwable session4) {
                    throwable2 = session4;
                    throw session4;
                }
                finally {
                    if (connection4 != null) {
                        if (throwable2 != null) {
                            try {
                                connection4.close();
                            }
                            catch (Throwable session4) {
                                throwable2.addSuppressed(session4);
                            }
                        } else {
                            connection4.close();
                        }
                    }
                }
            }
            catch (Throwable connection4) {
                throwable3 = connection4;
                throw connection4;
            }
            factory = new ActiveMQConnectionFactory();
            throwable3 = null;
            try {
                connection4 = factory.createConnection();
                throwable2 = null;
                try {
                    session4 = connection4.createSession(1);
                    throwable = null;
                    try {
                        connection4.start();
                        queue4 = session4.createQueue("myFilterQueue");
                        MessageProducer producer2 = session4.createProducer((Destination)queue4);
                        message = session4.createMessage();
                        message.setStringProperty("x", "y");
                        producer2.send(message);
                        MessageConsumer consumer2 = session4.createConsumer((Destination)queue4);
                        RedeployTest.assertNotNull((Object)consumer2.receive(2000L));
                        consumer2.close();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (session4 != null) {
                            if (throwable != null) {
                                try {
                                    session4.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                session4.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (connection4 != null) {
                        if (throwable2 != null) {
                            try {
                                connection4.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                        } else {
                            connection4.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable3 = throwable8;
                throw throwable8;
            }
            finally {
                if (factory != null) {
                    if (throwable3 != null) {
                        try {
                            factory.close();
                        }
                        catch (Throwable throwable9) {
                            throwable3.addSuppressed(throwable9);
                        }
                    } else {
                        factory.close();
                    }
                }
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    private void deployBrokerConfig(EmbeddedActiveMQ server, URL configFile) throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        Files.copy(configFile.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
        brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        server.getActiveMQServer().getReloadManager().setTick(tick);
        latch.await(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestRemoveFilter(URL testConfiguration) throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL baseConfig = RedeployTest.class.getClassLoader().getResource("reload-queue-filter.xml");
        Files.copy(baseConfig.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        this.deployBrokerConfig(embeddedActiveMQ, baseConfig);
        try {
            MessageConsumer consumer;
            MessageProducer producer;
            LocalQueueBinding queueBinding;
            jakarta.jms.Queue queue2;
            Throwable throwable;
            Session session2;
            Throwable throwable2;
            Connection connection;
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection = factory.createConnection();
                throwable2 = null;
                try {
                    session2 = connection.createSession(1);
                    throwable = null;
                    try {
                        connection.start();
                        queue2 = session2.createQueue("myFilterQueue");
                        queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("myFilterQueue"));
                        RedeployTest.assertEquals((Object)"x = 'x'", (Object)queueBinding.getFilter().getFilterString().toString());
                        producer = session2.createProducer((Destination)queue2);
                        Message passingMessage = session2.createMessage();
                        passingMessage.setStringProperty("x", "x");
                        producer.send(passingMessage);
                        Message filteredMessage = session2.createMessage();
                        filteredMessage.setStringProperty("x", "y");
                        producer.send(filteredMessage);
                        consumer = session2.createConsumer((Destination)queue2);
                        Message receivedMessage = consumer.receive(2000L);
                        RedeployTest.assertNotNull((Object)receivedMessage);
                        RedeployTest.assertEquals((Object)"x", (Object)receivedMessage.getStringProperty("x"));
                        RedeployTest.assertNull((Object)consumer.receive(2000L));
                        consumer.close();
                    }
                    catch (Throwable queue2) {
                        throwable = queue2;
                        throw queue2;
                    }
                    finally {
                        if (session2 != null) {
                            if (throwable != null) {
                                try {
                                    session2.close();
                                }
                                catch (Throwable queue2) {
                                    throwable.addSuppressed(queue2);
                                }
                            } else {
                                session2.close();
                            }
                        }
                    }
                }
                catch (Throwable session2) {
                    throwable2 = session2;
                    throw session2;
                }
                finally {
                    if (connection != null) {
                        if (throwable2 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable session2) {
                                throwable2.addSuppressed(session2);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            this.deployBrokerConfig(embeddedActiveMQ, testConfiguration);
            factory = new ActiveMQConnectionFactory();
            var6_6 = null;
            try {
                connection = factory.createConnection();
                throwable2 = null;
                try {
                    session2 = connection.createSession(1);
                    throwable = null;
                    try {
                        connection.start();
                        queue2 = session2.createQueue("myFilterQueue");
                        queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("myFilterQueue"));
                        RedeployTest.assertNull((Object)queueBinding.getFilter());
                        producer = session2.createProducer((Destination)queue2);
                        Message message1 = session2.createMessage();
                        message1.setStringProperty("x", "x");
                        producer.send(message1);
                        Message message2 = session2.createMessage();
                        message2.setStringProperty("x", "y");
                        producer.send(message2);
                        consumer = session2.createConsumer((Destination)queue2);
                        RedeployTest.assertNotNull((Object)consumer.receive(2000L));
                        RedeployTest.assertNotNull((Object)consumer.receive(2000L));
                        consumer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (session2 != null) {
                            if (throwable != null) {
                                try {
                                    session2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                session2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (connection != null) {
                        if (throwable2 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                var6_6 = throwable7;
                throw throwable7;
            }
            finally {
                if (factory != null) {
                    if (var6_6 != null) {
                        try {
                            factory.close();
                        }
                        catch (Throwable throwable8) {
                            var6_6.addSuppressed(throwable8);
                        }
                    } else {
                        factory.close();
                    }
                }
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    @Test
    public void testRedeployRemoveFilter() throws Exception {
        this.doTestRemoveFilter(RedeployTest.class.getClassLoader().getResource("reload-queue-filter-updated-empty.xml"));
        this.doTestRemoveFilter(RedeployTest.class.getClassLoader().getResource("reload-queue-filter-removed.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueuePartialReconfiguration() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url = RedeployTest.class.getClassLoader().getResource("reload-empty.xml");
        Files.copy(url.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        try {
            embeddedActiveMQ.getActiveMQServer().createQueue(new QueueConfiguration("virtualQueue").setUser("bob"));
            embeddedActiveMQ.getActiveMQServer().updateQueue(new QueueConfiguration("virtualQueue").setFilterString("foo"));
            LocalQueueBinding queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("virtualQueue"));
            Queue queue = queueBinding.getQueue();
            RedeployTest.assertEquals((Object)new SimpleString("bob"), (Object)queue.getUser());
            RedeployTest.assertEquals((Object)new SimpleString("foo"), (Object)queue.getFilter().getFilterString());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployQueueDefaults() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL baseConfig = RedeployTest.class.getClassLoader().getResource("reload-queue-defaults-before.xml");
        URL newConfig = RedeployTest.class.getClassLoader().getResource("reload-queue-defaults-after.xml");
        Files.copy(baseConfig.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        try {
            LocalQueueBinding queueBinding = (LocalQueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("myQueue"));
            Queue queue = queueBinding.getQueue();
            RedeployTest.assertNotEquals((long)ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), (long)queue.getMaxConsumers());
            RedeployTest.assertNotEquals((Object)RoutingType.MULTICAST, (Object)queue.getRoutingType());
            RedeployTest.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), (Object)queue.isPurgeOnNoConsumers());
            RedeployTest.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultEnabled(), (Object)queue.isEnabled());
            RedeployTest.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultExclusive(), (Object)queue.isExclusive());
            RedeployTest.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupRebalance(), (Object)queue.isGroupRebalance());
            RedeployTest.assertNotEquals((long)ActiveMQDefaultConfiguration.getDefaultGroupBuckets(), (long)queue.getGroupBuckets());
            RedeployTest.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupFirstKey(), (Object)queue.getGroupFirstKey());
            RedeployTest.assertNotEquals((Object)ActiveMQDefaultConfiguration.getDefaultNonDestructive(), (Object)queue.isNonDestructive());
            RedeployTest.assertNotEquals((long)ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch(), (long)queue.getConsumersBeforeDispatch());
            RedeployTest.assertNotEquals((long)ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch(), (long)queue.getDelayBeforeDispatch());
            RedeployTest.assertNotNull((Object)queue.getFilter());
            RedeployTest.assertEquals((Object)new SimpleString("jdoe"), (Object)queue.getUser());
            RedeployTest.assertNotEquals((long)ActiveMQDefaultConfiguration.getDefaultRingSize(), (long)queue.getRingSize());
            this.deployBrokerConfig(embeddedActiveMQ, newConfig);
            RedeployTest.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), (long)queue.getMaxConsumers());
            RedeployTest.assertEquals((Object)RoutingType.MULTICAST, (Object)queue.getRoutingType());
            RedeployTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), (Object)queue.isPurgeOnNoConsumers());
            RedeployTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultEnabled(), (Object)queue.isEnabled());
            RedeployTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultExclusive(), (Object)queue.isExclusive());
            RedeployTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupRebalance(), (Object)queue.isGroupRebalance());
            RedeployTest.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultGroupBuckets(), (long)queue.getGroupBuckets());
            RedeployTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultGroupFirstKey(), (Object)queue.getGroupFirstKey());
            RedeployTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultNonDestructive(), (Object)queue.isNonDestructive());
            RedeployTest.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch(), (long)queue.getConsumersBeforeDispatch());
            RedeployTest.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch(), (long)queue.getDelayBeforeDispatch());
            RedeployTest.assertNull((Object)queue.getFilter());
            RedeployTest.assertNull((Object)queue.getUser());
            RedeployTest.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultRingSize(), (long)queue.getRingSize());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndeployDivert() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL baseConfig = RedeployTest.class.getClassLoader().getResource("reload-divert-undeploy-before.xml");
        URL newConfig = RedeployTest.class.getClassLoader().getResource("reload-divert-undeploy-after.xml");
        Files.copy(baseConfig.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        try {
            TextMessage message2;
            Throwable throwable;
            MessageConsumer targetConsumer2;
            Throwable throwable2;
            MessageConsumer sourceConsumer2;
            Throwable throwable3;
            MessageProducer sourceProducer2;
            Throwable throwable4;
            Session session2;
            Throwable throwable5;
            Connection connection;
            DivertBinding divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("divert"));
            RedeployTest.assertNotNull((Object)divertBinding);
            jakarta.jms.Queue sourceQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://source", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
            jakarta.jms.Queue targetQueue = (jakarta.jms.Queue)ActiveMQDestination.createDestination((String)"queue://target", (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
            try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();){
                connection = factory.createConnection();
                throwable5 = null;
                try {
                    session2 = connection.createSession(1);
                    throwable4 = null;
                    try {
                        sourceProducer2 = session2.createProducer((Destination)sourceQueue);
                        throwable3 = null;
                        try {
                            sourceConsumer2 = session2.createConsumer((Destination)sourceQueue);
                            throwable2 = null;
                            try {
                                targetConsumer2 = session2.createConsumer((Destination)targetQueue);
                                throwable = null;
                                try {
                                    connection.start();
                                    message2 = session2.createTextMessage("Hello world");
                                    sourceProducer2.send((Message)message2);
                                    RedeployTest.assertNotNull((Object)sourceConsumer2.receive(2000L));
                                    RedeployTest.assertNotNull((Object)targetConsumer2.receive(2000L));
                                }
                                catch (Throwable message2) {
                                    throwable = message2;
                                    throw message2;
                                }
                                finally {
                                    if (targetConsumer2 != null) {
                                        if (throwable != null) {
                                            try {
                                                targetConsumer2.close();
                                            }
                                            catch (Throwable message2) {
                                                throwable.addSuppressed(message2);
                                            }
                                        } else {
                                            targetConsumer2.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable targetConsumer2) {
                                throwable2 = targetConsumer2;
                                throw targetConsumer2;
                            }
                            finally {
                                if (sourceConsumer2 != null) {
                                    if (throwable2 != null) {
                                        try {
                                            sourceConsumer2.close();
                                        }
                                        catch (Throwable targetConsumer2) {
                                            throwable2.addSuppressed(targetConsumer2);
                                        }
                                    } else {
                                        sourceConsumer2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable sourceConsumer2) {
                            throwable3 = sourceConsumer2;
                            throw sourceConsumer2;
                        }
                        finally {
                            if (sourceProducer2 != null) {
                                if (throwable3 != null) {
                                    try {
                                        sourceProducer2.close();
                                    }
                                    catch (Throwable sourceConsumer2) {
                                        throwable3.addSuppressed(sourceConsumer2);
                                    }
                                } else {
                                    sourceProducer2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable sourceProducer2) {
                        throwable4 = sourceProducer2;
                        throw sourceProducer2;
                    }
                    finally {
                        if (session2 != null) {
                            if (throwable4 != null) {
                                try {
                                    session2.close();
                                }
                                catch (Throwable sourceProducer2) {
                                    throwable4.addSuppressed(sourceProducer2);
                                }
                            } else {
                                session2.close();
                            }
                        }
                    }
                }
                catch (Throwable session2) {
                    throwable5 = session2;
                    throw session2;
                }
                finally {
                    if (connection != null) {
                        if (throwable5 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable session2) {
                                throwable5.addSuppressed(session2);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            this.deployBrokerConfig(embeddedActiveMQ, newConfig);
            Wait.waitFor(() -> embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("divert")) == null);
            divertBinding = (DivertBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(new SimpleString("divert"));
            RedeployTest.assertNull((Object)divertBinding);
            factory = new ActiveMQConnectionFactory();
            var9_9 = null;
            try {
                connection = factory.createConnection();
                throwable5 = null;
                try {
                    session2 = connection.createSession(1);
                    throwable4 = null;
                    try {
                        sourceProducer2 = session2.createProducer((Destination)sourceQueue);
                        throwable3 = null;
                        try {
                            sourceConsumer2 = session2.createConsumer((Destination)sourceQueue);
                            throwable2 = null;
                            try {
                                targetConsumer2 = session2.createConsumer((Destination)targetQueue);
                                throwable = null;
                                try {
                                    connection.start();
                                    message2 = session2.createTextMessage("Hello world");
                                    sourceProducer2.send((Message)message2);
                                    RedeployTest.assertNotNull((Object)sourceConsumer2.receive(2000L));
                                    RedeployTest.assertNull((Object)targetConsumer2.receiveNoWait());
                                }
                                catch (Throwable throwable6) {
                                    throwable = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (targetConsumer2 != null) {
                                        if (throwable != null) {
                                            try {
                                                targetConsumer2.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            targetConsumer2.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable2 = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (sourceConsumer2 != null) {
                                    if (throwable2 != null) {
                                        try {
                                            sourceConsumer2.close();
                                        }
                                        catch (Throwable throwable9) {
                                            throwable2.addSuppressed(throwable9);
                                        }
                                    } else {
                                        sourceConsumer2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            throwable3 = throwable10;
                            throw throwable10;
                        }
                        finally {
                            if (sourceProducer2 != null) {
                                if (throwable3 != null) {
                                    try {
                                        sourceProducer2.close();
                                    }
                                    catch (Throwable throwable11) {
                                        throwable3.addSuppressed(throwable11);
                                    }
                                } else {
                                    sourceProducer2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable4 = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (session2 != null) {
                            if (throwable4 != null) {
                                try {
                                    session2.close();
                                }
                                catch (Throwable throwable13) {
                                    throwable4.addSuppressed(throwable13);
                                }
                            } else {
                                session2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable14) {
                    throwable5 = throwable14;
                    throw throwable14;
                }
                finally {
                    if (connection != null) {
                        if (throwable5 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable15) {
                                throwable5.addSuppressed(throwable15);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Throwable throwable16) {
                var9_9 = throwable16;
                throw throwable16;
            }
            finally {
                if (factory != null) {
                    if (var9_9 != null) {
                        try {
                            factory.close();
                        }
                        catch (Throwable throwable17) {
                            var9_9.addSuppressed(throwable17);
                        }
                    } else {
                        factory.close();
                    }
                }
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployWithFailover() throws Exception {
        HashSet<Role> original = new HashSet<Role>();
        original.add(new Role("a", false, true, false, false, false, false, false, false, false, false));
        HashSet<Role> changed = new HashSet<Role>();
        changed.add(new Role("b", false, true, false, false, false, false, false, false, false, false));
        EmbeddedActiveMQ live = new EmbeddedActiveMQ();
        EmbeddedActiveMQ backup = new EmbeddedActiveMQ();
        try {
            MessageProducer producer;
            jakarta.jms.Queue queue;
            Session session;
            System.setProperty("live-data-dir", this.getTestDirfile().toPath() + "/redeploy-live-data");
            System.setProperty("backup-data-dir", this.getTestDirfile().toPath() + "/redeploy-backup-data");
            Path liveBrokerXML = this.getTestDirfile().toPath().resolve("live.xml");
            Path backupBrokerXML = this.getTestDirfile().toPath().resolve("backup.xml");
            URL url1 = RedeployTest.class.getClassLoader().getResource("reload-live-original.xml");
            URL url2 = RedeployTest.class.getClassLoader().getResource("reload-live-changed.xml");
            URL url3 = RedeployTest.class.getClassLoader().getResource("reload-backup-original.xml");
            URL url4 = RedeployTest.class.getClassLoader().getResource("reload-backup-changed.xml");
            Files.copy(url1.openStream(), liveBrokerXML, new CopyOption[0]);
            Files.copy(url3.openStream(), backupBrokerXML, new CopyOption[0]);
            live.setConfigResourcePath(liveBrokerXML.toUri().toString());
            live.start();
            this.waitForServerToStart(live.getActiveMQServer());
            backup.setConfigResourcePath(backupBrokerXML.toUri().toString());
            backup.start();
            RedeployTest.assertTrue((boolean)Wait.waitFor(() -> backup.getActiveMQServer().isReplicaSync(), (long)15000L, (long)200L));
            RedeployTest.assertEquals((String)"Test address settings original - live", (Object)AddressFullMessagePolicy.BLOCK, (Object)((AddressSettings)live.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy());
            RedeployTest.assertEquals((String)"Test address settings original - backup", (Object)AddressFullMessagePolicy.BLOCK, (Object)((AddressSettings)backup.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy());
            RedeployTest.assertEquals((String)"Test security settings original - live", original, (Object)live.getActiveMQServer().getSecurityRepository().getMatch("myQueue"));
            RedeployTest.assertEquals((String)"Test security settings original - backup", original, (Object)backup.getActiveMQServer().getSecurityRepository().getMatch("myQueue"));
            ReusableLatch liveReloadLatch = new ReusableLatch(1);
            Runnable liveTick = () -> liveReloadLatch.countDown();
            live.getActiveMQServer().getReloadManager().setTick(liveTick);
            ReusableLatch backupReloadTickLatch = new ReusableLatch(1);
            Runnable backupTick = () -> backupReloadTickLatch.countDown();
            backup.getActiveMQServer().getReloadManager().setTick(backupTick);
            liveReloadLatch.await(10L, TimeUnit.SECONDS);
            Files.copy(url2.openStream(), liveBrokerXML, StandardCopyOption.REPLACE_EXISTING);
            liveBrokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            liveReloadLatch.countUp();
            live.getActiveMQServer().getReloadManager().setTick(liveTick);
            liveReloadLatch.await(10L, TimeUnit.SECONDS);
            backupReloadTickLatch.await(10L, TimeUnit.SECONDS);
            Files.copy(url4.openStream(), backupBrokerXML, StandardCopyOption.REPLACE_EXISTING);
            backupBrokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            backupReloadTickLatch.countUp();
            backup.getActiveMQServer().getReloadManager().setTick(backupTick);
            backupReloadTickLatch.await(10L, TimeUnit.SECONDS);
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://127.0.0.1:61616");
            try (Connection connection = factory.createConnection();){
                session = connection.createSession();
                queue = session.createQueue("myQueue2");
                producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text1"));
            }
            RedeployTest.assertFalse((boolean)backup.getActiveMQServer().isActive());
            RedeployTest.assertEquals((String)"Test address settings redeploy - live", (Object)AddressFullMessagePolicy.PAGE, (Object)((AddressSettings)live.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy());
            RedeployTest.assertEquals((String)"Test security settings redeploy - live", changed, (Object)live.getActiveMQServer().getSecurityRepository().getMatch("myQueue"));
            live.stop();
            RedeployTest.assertTrue((boolean)Wait.waitFor(() -> backup.getActiveMQServer().isActive(), (long)5000L, (long)100L));
            factory = new ActiveMQConnectionFactory("tcp://127.0.0.1:61617");
            connection = factory.createConnection();
            var17_17 = null;
            try {
                session = connection.createSession();
                queue = session.createQueue("myQueue2");
                producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("text"));
                connection.start();
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("myQueue2"));
                Assert.assertNotNull((String)"Queue wasn't deployed accordingly", (Object)consumer.receive(5000L));
                Assert.assertNotNull((Object)consumer.receive(5000L));
            }
            catch (Throwable throwable) {
                var17_17 = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (var17_17 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            var17_17.addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
            RedeployTest.assertEquals((String)"Test security settings redeploy - backup", changed, (Object)backup.getActiveMQServer().getSecurityRepository().getMatch("myQueue"));
            RedeployTest.assertEquals((String)"Test address settings redeploy - backup", (Object)AddressFullMessagePolicy.PAGE, (Object)((AddressSettings)backup.getActiveMQServer().getAddressSettingsRepository().getMatch("myQueue")).getAddressFullMessagePolicy());
        }
        finally {
            live.stop();
            backup.stop();
            System.clearProperty("live-data-dir");
            System.clearProperty("backup-data-dir");
        }
    }

    /*
     * Exception decompiling
     */
    private boolean tryConsume() throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAddressQueue() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-address-queues.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-address-queues-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        try (JMSContext jmsContext = connectionFactory.createContext();){
            jmsContext.createSharedDurableConsumer(jmsContext.createTopic("config_test_consumer_created_queues"), "mySub").receive(100L);
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_consumer_created_queues").contains("mySub"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_1"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assert.assertEquals((long)10L, (long)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_consumer_created_queues").contains("mySub"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assert.assertFalse((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_1"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assert.assertEquals((long)1L, (long)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change_queue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal_queue_1"));
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployChangeQueueRoutingType() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-queue-routingtype.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-queue-routingtype-updated.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(() -> ((ReusableLatch)latch).countDown());
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://0.0.0.0:61616");
            try (JMSContext context = connectionFactory.createContext();){
                context.createProducer().send((Destination)context.createQueue("myAddress"), "hello");
            }
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "myAddress"));
            Assert.assertEquals((Object)RoutingType.ANYCAST, (Object)this.getQueue(embeddedActiveMQ, "myQueue").getRoutingType());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(() -> ((ReusableLatch)latch).countDown());
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "myAddress"));
            Assert.assertEquals((Object)RoutingType.MULTICAST, (Object)this.getQueue(embeddedActiveMQ, "myQueue").getRoutingType());
            context = connectionFactory.createContext();
            var8_8 = null;
            try {
                Message message = context.createSharedDurableConsumer(context.createTopic("myAddress"), "myQueue").receive();
                RedeployTest.assertEquals((Object)"hello", (Object)((TextMessage)message).getText());
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var8_8 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployStopAndRestart() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = RedeployTest.class.getClassLoader().getResource("reload-original.xml");
        URL url2 = RedeployTest.class.getClassLoader().getResource("reload-changed.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ReusableLatch latch = new ReusableLatch(1);
        Runnable tick = () -> ((ReusableLatch)latch).countDown();
        embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
        try {
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)this.getSecurityRoles(embeddedActiveMQ, "security_address").size(), (long)1L);
            Assert.assertEquals((Object)this.getSecurityRoles(embeddedActiveMQ, "security_address").iterator().next().getName(), (Object)"b");
            Assert.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getDeadLetterAddress(), (Object)SimpleString.toSimpleString((String)"OriginalDLQ"));
            Assert.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getExpiryAddress(), (Object)SimpleString.toSimpleString((String)"OriginalExpiryQueue"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assert.assertEquals((long)10L, (long)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isEnabled());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isPurgeOnNoConsumers());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isEnabled());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            latch.setCount(1);
            embeddedActiveMQ.getActiveMQServer().getReloadManager().setTick(tick);
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)this.getSecurityRoles(embeddedActiveMQ, "security_address").size(), (long)1L);
            Assert.assertEquals((Object)this.getSecurityRoles(embeddedActiveMQ, "security_address").iterator().next().getName(), (Object)"c");
            Assert.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getDeadLetterAddress(), (Object)SimpleString.toSimpleString((String)"NewDLQ"));
            Assert.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getExpiryAddress(), (Object)SimpleString.toSimpleString((String)"NewExpiryQueue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assert.assertFalse((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assert.assertEquals((long)1L, (long)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isEnabled());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isPurgeOnNoConsumers());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isEnabled());
        }
        finally {
            embeddedActiveMQ.stop();
        }
        try {
            embeddedActiveMQ.start();
            Assert.assertEquals((long)this.getSecurityRoles(embeddedActiveMQ, "security_address").size(), (long)1L);
            Assert.assertEquals((Object)this.getSecurityRoles(embeddedActiveMQ, "security_address").iterator().next().getName(), (Object)"c");
            Assert.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getDeadLetterAddress(), (Object)SimpleString.toSimpleString((String)"NewDLQ"));
            Assert.assertEquals((Object)this.getAddressSettings(embeddedActiveMQ, "address_settings_address").getExpiryAddress(), (Object)SimpleString.toSimpleString((String)"NewExpiryQueue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assert.assertFalse((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assert.assertEquals((long)1L, (long)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isEnabled());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isPurgeOnNoConsumers());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue_defaults").isEnabled());
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    private AddressSettings getAddressSettings(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return (AddressSettings)embeddedActiveMQ.getActiveMQServer().getAddressSettingsRepository().getMatch(address);
    }

    private Set<Role> getSecurityRoles(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return (Set)embeddedActiveMQ.getActiveMQServer().getSecurityRepository().getMatch(address);
    }

    private AddressInfo getAddressInfo(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)address));
    }

    private Queue getQueue(EmbeddedActiveMQ embeddedActiveMQ, String queueName) throws Exception {
        QueueBinding queueBinding = (QueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName));
        return queueBinding == null ? null : queueBinding.getQueue();
    }

    private List<String> listQueuesNamesForAddress(EmbeddedActiveMQ embeddedActiveMQ, String address) throws Exception {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().listQueuesForAddress(SimpleString.toSimpleString((String)address)).stream().map(Queue::getName).map(SimpleString::toString).collect(Collectors.toList());
    }
}

