/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.IllegalStateException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Test;

public class SessionTest
extends JMSTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegalStateException() throws Exception {
        Connection defaultConn = null;
        QueueConnection qConn = null;
        Connection connClientID = null;
        ActiveMQConnectionFactory activeMQConnectionFactory = (ActiveMQConnectionFactory)this.cf;
        try {
            String clientID = "somethingElse" + this.name.getMethodName();
            defaultConn = this.cf.createConnection();
            qConn = activeMQConnectionFactory.createQueueConnection();
            connClientID = this.cf.createConnection();
            connClientID.setClientID(clientID);
            Topic topic = this.createTopic("topic");
            QueueSession qSess = qConn.createQueueSession(false, 1);
            try {
                qSess.createDurableConsumer(topic, "mySub1");
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                qSess.createDurableConsumer(topic, "mySub1", "TEST = 'test'", false);
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                qSess.createSharedConsumer(topic, "mySub1");
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                qSess.createSharedConsumer(topic, "mySub1", "TEST = 'test'");
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                qSess.createSharedDurableConsumer(topic, "mySub1");
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                qSess.createSharedDurableConsumer(topic, "mySub1", "TEST = 'test'");
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Session defaultSess = defaultConn.createSession();
            try {
                defaultSess.createDurableSubscriber(topic, "mySub1");
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                defaultSess.createDurableSubscriber(topic, "mySub1", "TEST = 'test'", true);
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                defaultSess.createDurableConsumer(topic, "mySub1");
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                defaultSess.createDurableConsumer(topic, "mySub1", "TEST = 'test'", true);
                SessionTest.fail((String)"exception expected");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            if (defaultConn != null) {
                defaultConn.close();
            }
            if (qConn != null) {
                qConn.close();
            }
            if (connClientID != null) {
                connClientID.close();
            }
        }
    }
}

