/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.tests.integration.jms.server.management.JMSUtil;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.InVMNodeManagerServer;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMSFailoverListenerTest
extends ActiveMQTestBase {
    protected Configuration backupConf;
    protected Configuration liveConf;
    protected ActiveMQServer liveServer;
    protected ActiveMQServer backupServer;
    protected Map<String, Object> backupParams = new HashMap<String, Object>();
    private TransportConfiguration backuptc;
    private TransportConfiguration livetc;
    private TransportConfiguration liveAcceptortc;
    private TransportConfiguration backupAcceptortc;

    @Test
    public void testAutomaticFailover() throws Exception {
        BytesMessage bm;
        int i;
        ActiveMQConnectionFactory jbcf = ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.livetc});
        jbcf.setReconnectAttempts(-1);
        jbcf.setRetryInterval(100L);
        jbcf.setConnectionTTL(500L);
        jbcf.setClientFailureCheckPeriod(100L);
        jbcf.setBlockOnDurableSend(true);
        jbcf.setBlockOnNonDurableSend(true);
        jbcf.setCallTimeout(1000L);
        int numMessages = 10;
        int bodySize = 1000;
        jbcf.setConsumerWindowSize(1000);
        ActiveMQConnection conn = JMSUtil.createConnectionAndWaitForTopology(jbcf, 2, 5);
        MyFailoverListener listener = new MyFailoverListener();
        conn.setFailoverListener((FailoverEventListener)listener);
        Session sess = conn.createSession(false, 1);
        ClientSession coreSession = ((ActiveMQSession)sess).getCoreSession();
        SimpleString jmsQueueName = new SimpleString("myqueue");
        coreSession.createQueue(new QueueConfiguration(jmsQueueName).setRoutingType(RoutingType.ANYCAST));
        jakarta.jms.Queue queue = sess.createQueue("myqueue");
        MessageProducer producer = sess.createProducer((Destination)queue);
        producer.setDeliveryMode(2);
        MessageConsumer consumer = sess.createConsumer((Destination)queue);
        byte[] body = RandomUtil.randomBytes((int)1000);
        for (i = 0; i < 10; ++i) {
            bm = sess.createBytesMessage();
            bm.writeBytes(body);
            producer.send((Message)bm);
        }
        Wait.assertEquals((long)10L, () -> ((Queue)this.liveServer.locateQueue(jmsQueueName)).getMessageCount());
        conn.start();
        this.instanceLog.debug((Object)"sent messages and started connection");
        JMSUtil.crash(this.liveServer, ((ActiveMQSession)sess).getCoreSession());
        Wait.assertTrue(() -> FailoverEventType.FAILURE_DETECTED == listener.get(0));
        for (i = 0; i < 10; ++i) {
            this.instanceLog.debug((Object)("got message " + i));
            bm = (BytesMessage)consumer.receive(1000L);
            Assert.assertNotNull((Object)bm);
            Assert.assertEquals((long)body.length, (long)bm.getBodyLength());
        }
        TextMessage tm = (TextMessage)consumer.receiveNoWait();
        Assert.assertNull((Object)tm);
        Assert.assertEquals((Object)FailoverEventType.FAILOVER_COMPLETED, (Object)listener.get(1));
        conn.close();
        Assert.assertEquals((String)"Expected 2 FailoverEvents to be triggered", (long)2L, (long)listener.size());
    }

    @Test
    public void testManualFailover() throws Exception {
        ActiveMQConnectionFactory jbcfLive = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        jbcfLive.setBlockOnNonDurableSend(true);
        jbcfLive.setBlockOnDurableSend(true);
        jbcfLive.setCallTimeout(1000L);
        ActiveMQConnectionFactory jbcfBackup = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY, this.backupParams)});
        jbcfBackup.setBlockOnNonDurableSend(true);
        jbcfBackup.setBlockOnDurableSend(true);
        jbcfBackup.setInitialConnectAttempts(-1);
        jbcfBackup.setReconnectAttempts(-1);
        jbcfBackup.setRetryInterval(100L);
        ActiveMQConnection connLive = (ActiveMQConnection)jbcfLive.createConnection();
        MyFailoverListener listener = new MyFailoverListener();
        connLive.setFailoverListener((FailoverEventListener)listener);
        Session sessLive = connLive.createSession(false, 1);
        ClientSession coreSessionLive = ((ActiveMQSession)sessLive).getCoreSession();
        SimpleString jmsQueueName = new SimpleString("myqueue");
        coreSessionLive.createQueue(new QueueConfiguration(jmsQueueName).setRoutingType(RoutingType.ANYCAST));
        jakarta.jms.Queue queue = sessLive.createQueue("myqueue");
        int numMessages = 1000;
        MessageProducer producerLive = sessLive.createProducer((Destination)queue);
        for (int i = 0; i < 1000; ++i) {
            TextMessage tm = sessLive.createTextMessage("message" + i);
            producerLive.send((Message)tm);
        }
        JMSUtil.crash(this.liveServer, coreSessionLive);
        Assert.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.get(0));
        connLive.close();
        Connection connBackup = jbcfBackup.createConnection();
        Session sessBackup = connBackup.createSession(false, 1);
        MessageConsumer consumerBackup = sessBackup.createConsumer((Destination)queue);
        connBackup.start();
        for (int i = 0; i < 1000; ++i) {
            TextMessage tm = (TextMessage)consumerBackup.receive(1000L);
            Assert.assertNotNull((Object)tm);
            Assert.assertEquals((Object)("message" + i), (Object)tm.getText());
        }
        TextMessage tm = (TextMessage)consumerBackup.receiveNoWait();
        Assert.assertEquals((Object)FailoverEventType.FAILOVER_FAILED, (Object)listener.get(1));
        Assert.assertEquals((String)"Expected 2 FailoverEvents to be triggered", (long)2L, (long)listener.size());
        Assert.assertNull((Object)tm);
        connBackup.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startServers();
    }

    protected void startServers() throws Exception {
        InVMNodeManager nodeManager = new InVMNodeManager(false);
        this.backuptc = new TransportConfiguration(INVM_CONNECTOR_FACTORY, this.backupParams);
        this.livetc = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        this.liveAcceptortc = new TransportConfiguration(INVM_ACCEPTOR_FACTORY);
        this.backupAcceptortc = new TransportConfiguration(INVM_ACCEPTOR_FACTORY, this.backupParams);
        this.backupParams.put("serverId", 1);
        this.backupConf = this.createBasicConfig().addAcceptorConfiguration(this.backupAcceptortc).addConnectorConfiguration(this.livetc.getName(), this.livetc).addConnectorConfiguration(this.backuptc.getName(), this.backuptc).setJournalType(JMSFailoverListenerTest.getDefaultJournalType()).addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, this.backupParams)).setBindingsDirectory(this.getBindingsDir()).setJournalMinFiles(2).setJournalDirectory(this.getJournalDir()).setPagingDirectory(this.getPageDir()).setLargeMessagesDirectory(this.getLargeMessagesDir()).setPersistenceEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).addClusterConfiguration(JMSFailoverListenerTest.basicClusterConnectionConfig((String)this.backuptc.getName(), (String[])new String[]{this.livetc.getName()}));
        this.backupConf.setConnectionTtlCheckInterval(100L);
        this.backupServer = this.addServer((ActiveMQServer)new InVMNodeManagerServer(this.backupConf, (NodeManager)nodeManager));
        this.backupServer.setIdentity("JMSBackup");
        this.instanceLog.debug((Object)"Starting backup");
        this.backupServer.start();
        this.liveConf = this.createBasicConfig().setJournalDirectory(this.getJournalDir()).setBindingsDirectory(this.getBindingsDir()).addAcceptorConfiguration(this.liveAcceptortc).setJournalType(JMSFailoverListenerTest.getDefaultJournalType()).setBindingsDirectory(this.getBindingsDir()).setJournalMinFiles(2).setJournalDirectory(this.getJournalDir()).setPagingDirectory(this.getPageDir()).setLargeMessagesDirectory(this.getLargeMessagesDir()).addConnectorConfiguration(this.livetc.getName(), this.livetc).setPersistenceEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addClusterConfiguration(JMSFailoverListenerTest.basicClusterConnectionConfig((String)this.livetc.getName(), (String[])new String[0]));
        this.liveConf.setConnectionTtlCheckInterval(100L);
        this.liveServer = this.addServer((ActiveMQServer)new InVMNodeManagerServer(this.liveConf, (NodeManager)nodeManager));
        this.liveServer.setIdentity("JMSLive");
        this.instanceLog.debug((Object)"Starting life");
        this.liveServer.start();
        JMSUtil.waitForServer(this.backupServer);
    }

    private static class MyFailoverListener
    implements FailoverEventListener {
        private List<FailoverEventType> eventTypeList = new ArrayList<FailoverEventType>();

        private MyFailoverListener() {
        }

        public FailoverEventType get(int element) {
            this.waitForElements(element + 1);
            return this.eventTypeList.get(element);
        }

        public int size() {
            return this.eventTypeList.size();
        }

        private void waitForElements(int elements) {
            long timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && this.eventTypeList.size() < elements) {
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            Assert.assertTrue((this.eventTypeList.size() >= elements ? (byte)1 : 0) != 0);
        }

        public void failoverEvent(FailoverEventType eventType) {
            this.eventTypeList.add(eventType);
        }
    }
}

