/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CloseConnectionOnGCTest
extends JMSTestBase {
    private ActiveMQConnectionFactory cf;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.cf.setBlockOnDurableSend(true);
        this.cf.setPreAcknowledge(true);
    }

    @Test
    public void testCloseOneConnectionOnGC() throws Exception {
        int initialConns = this.server.getRemotingService().getConnections().size();
        Assert.assertEquals((long)0L, (long)initialConns);
        Connection conn = this.cf.createConnection();
        WeakReference<Connection> wr = new WeakReference<Connection>(conn);
        Assert.assertEquals((long)1L, (long)this.server.getRemotingService().getConnections().size());
        final CountDownLatch latch = new CountDownLatch(1);
        Iterator connectionIterator = this.server.getRemotingService().getConnections().iterator();
        ((RemotingConnection)connectionIterator.next()).addCloseListener(new CloseListener(){

            public void connectionClosed() {
                latch.countDown();
            }
        });
        conn = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{wr});
        latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.server.getRemotingService().getConnections().size());
    }

    @Test
    public void testCloseSeveralConnectionOnGC() throws Exception {
        Connection conn1 = this.cf.createConnection();
        Connection conn2 = this.cf.createConnection();
        Connection conn3 = this.cf.createConnection();
        WeakReference<Connection> wr1 = new WeakReference<Connection>(conn1);
        WeakReference<Connection> wr2 = new WeakReference<Connection>(conn2);
        WeakReference<Connection> wr3 = new WeakReference<Connection>(conn3);
        Assert.assertEquals((long)3L, (long)this.server.getRemotingService().getConnections().size());
        final CountDownLatch latch = new CountDownLatch(3);
        for (RemotingConnection remotingConnection : this.server.getRemotingService().getConnections()) {
            remotingConnection.addCloseListener(new CloseListener(){

                public void connectionClosed() {
                    latch.countDown();
                }
            });
        }
        conn1 = null;
        conn2 = null;
        conn3 = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{wr1, wr2, wr3});
        latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.server.getRemotingService().getConnections().size());
    }

    @Test
    public void testCloseSeveralConnectionsWithSessionsOnGC() throws Exception {
        Connection conn1 = this.cf.createConnection();
        Connection conn2 = this.cf.createConnection();
        Connection conn3 = this.cf.createConnection();
        WeakReference<Connection> wr1 = new WeakReference<Connection>(conn1);
        WeakReference<Connection> wr2 = new WeakReference<Connection>(conn2);
        WeakReference<Connection> wr3 = new WeakReference<Connection>(conn3);
        Session sess1 = conn1.createSession(false, 1);
        Session sess2 = conn1.createSession(false, 1);
        Session sess3 = conn2.createSession(false, 1);
        Session sess4 = conn2.createSession(false, 1);
        Session sess5 = conn3.createSession(false, 1);
        Session sess6 = conn3.createSession(false, 1);
        Session sess7 = conn3.createSession(false, 1);
        final CountDownLatch latch = new CountDownLatch(3);
        for (RemotingConnection remotingConnection : this.server.getRemotingService().getConnections()) {
            remotingConnection.addCloseListener(new CloseListener(){

                public void connectionClosed() {
                    latch.countDown();
                }
            });
        }
        sess7 = null;
        sess6 = null;
        sess5 = null;
        sess4 = null;
        sess3 = null;
        sess2 = null;
        sess1 = null;
        conn1 = null;
        conn2 = null;
        conn3 = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{wr1, wr2, wr3});
        latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.server.getRemotingService().getConnections().size());
    }
}

