/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.JournalImplTestUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

public class AIOJournalImplTest
extends JournalImplTestUnit {
    @BeforeClass
    public static void hasAIO() {
        Assume.assumeTrue((String)"Test case needs AIO to run", (boolean)AIOSequentialFileFactory.isSupported());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (!LibaioContext.isLoaded()) {
            Assert.fail((String)String.format("libAIO is not loaded on %s %s %s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        }
    }

    @Override
    protected SequentialFileFactory getFileFactory() throws Exception {
        File file = new File(this.getTestDir());
        AIOJournalImplTest.deleteDirectory((File)file);
        file.mkdir();
        return new AIOSequentialFileFactory(this.getTestDirfile(), 501760, 1000000, 10, false).setAlignment(512);
    }

    @Override
    protected int getAlignment() {
        return 512;
    }
}

