/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.Parameter;
import org.apache.activemq.artemis.tests.integration.management.ActiveMQServerControlTest;
import org.apache.activemq.artemis.tests.integration.management.CoreMessagingProxy;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActiveMQServerControlUsingCoreTest
extends ActiveMQServerControlTest {
    public ActiveMQServerControlUsingCoreTest(boolean legacyCreateQueue) {
        super(legacyCreateQueue);
    }

    @Override
    public void testScaleDownWithOutConnector() throws Exception {
    }

    @Override
    public void testScaleDownWithConnector() throws Exception {
    }

    @Override
    protected ActiveMQServerControl createManagementControl() throws Exception {
        return new ActiveMQServerControl(){
            private final CoreMessagingProxy proxy;
            {
                this.proxy = new CoreMessagingProxy(ActiveMQServerControlUsingCoreTest.this.addServerLocator(ActiveMQServerControlUsingCoreTest.this.createInVMNonHALocator()), "broker");
            }

            public String listBrokerConnections() {
                try {
                    return (String)this.proxy.invokeOperation("listBrokerConnections", new Object[0]);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return null;
                }
            }

            public void startBrokerConnection(String name) throws Exception {
                this.proxy.invokeOperation("startBrokerConnection", name);
            }

            public void stopBrokerConnection(String name) throws Exception {
                this.proxy.invokeOperation("stopBrokerConnection", name);
            }

            public String updateAddress(String name, String routingTypes) throws Exception {
                return (String)this.proxy.invokeOperation("updateAddress", name, routingTypes);
            }

            public void updateDuplicateIdCache(String address, Object[] ids) {
            }

            public void scaleDown(String connector) throws Exception {
                throw new UnsupportedOperationException();
            }

            public boolean isSharedStore() {
                return (Boolean)this.proxy.retrieveAttributeValue("sharedStore");
            }

            public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
                return (Boolean)this.proxy.invokeOperation("closeConnectionsForAddress", ipAddress);
            }

            public boolean closeConsumerConnectionsForAddress(String address) throws Exception {
                return (Boolean)this.proxy.invokeOperation("closeConsumerConnectionsForAddress", address);
            }

            public boolean closeConnectionsForUser(String userName) throws Exception {
                return (Boolean)this.proxy.invokeOperation("closeConnectionsForUser", userName);
            }

            public boolean closeConnectionWithID(String ID) throws Exception {
                return (Boolean)this.proxy.invokeOperation("closeConnectionWithID", ID);
            }

            public boolean closeSessionWithID(String connectionID, String ID) throws Exception {
                return (Boolean)this.proxy.invokeOperation("closeSessionWithID", connectionID, ID);
            }

            public boolean closeConsumerWithID(String sessionID, String ID) throws Exception {
                return (Boolean)this.proxy.invokeOperation("closeConsumerWithID", sessionID, ID);
            }

            public boolean commitPreparedTransaction(String transactionAsBase64) throws Exception {
                return (Boolean)this.proxy.invokeOperation("commitPreparedTransaction", transactionAsBase64);
            }

            public void createQueue(String address, String name) throws Exception {
                this.proxy.invokeOperation("createQueue", address, name);
            }

            public boolean isActive() {
                return (Boolean)this.proxy.retrieveAttributeValue("active");
            }

            public String createQueue(String address, String routingType, String name, String filterStr, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
                return (String)this.proxy.invokeOperation("createQueue", address, routingType, name, filterStr, durable, maxConsumers, purgeOnNoConsumers, autoCreateAddress);
            }

            public String createQueue(String queueConfiguration) throws Exception {
                return (String)this.proxy.invokeOperation("createQueue", queueConfiguration);
            }

            public String createQueue(String queueConfiguration, boolean ignoreIfExists) throws Exception {
                return (String)this.proxy.invokeOperation("createQueue", queueConfiguration, ignoreIfExists);
            }

            public String updateQueue(String queueConfiguration) throws Exception {
                return (String)this.proxy.invokeOperation("updateQueue", queueConfiguration);
            }

            public String updateQueue(@Parameter(name="name", desc="Name of the queue") String name, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String routingType, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer maxConsumers, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean purgeOnNoConsumers) throws Exception {
                return (String)this.proxy.invokeOperation("updateQueue", name, routingType, maxConsumers, purgeOnNoConsumers);
            }

            public String updateQueue(@Parameter(name="name", desc="Name of the queue") String name, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String routingType, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer maxConsumers, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean purgeOnNoConsumers, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean exclusive) throws Exception {
                return (String)this.proxy.invokeOperation("updateQueue", name, routingType, maxConsumers, purgeOnNoConsumers, exclusive);
            }

            public String updateQueue(@Parameter(name="name", desc="Name of the queue") String name, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String routingType, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer maxConsumers, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean purgeOnNoConsumers, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean exclusive, @Parameter(name="user", desc="The user associated with this queue") String user) throws Exception {
                return (String)this.proxy.invokeOperation("updateQueue", name, routingType, maxConsumers, purgeOnNoConsumers, exclusive, user);
            }

            public String updateQueue(@Parameter(name="name", desc="Name of the queue") String name, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String routingType, @Parameter(name="filter", desc="The filter to use on the queue") String filter, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer maxConsumers, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean purgeOnNoConsumers, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean exclusive, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") Boolean groupRebalance, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") Integer groupBuckets, @Parameter(name="nonDestructive", desc="If the queue should be nonDestructive") Boolean nonDestructive, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") Integer consumersBeforeDispatch, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") Long delayBeforeDispatch, @Parameter(name="user", desc="The user associated with this queue") String user) throws Exception {
                return (String)this.proxy.invokeOperation("updateQueue", name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user);
            }

            public String updateQueue(String name, String routingType, String filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, String groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user) throws Exception {
                return (String)this.proxy.invokeOperation("updateQueue", name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user);
            }

            public String updateQueue(String name, String routingType, String filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, String groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user, Long ringSize) throws Exception {
                return (String)this.proxy.invokeOperation("updateQueue", name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, ringSize);
            }

            public void deleteAddress(@Parameter(name="name", desc="The name of the address") String name) throws Exception {
                this.proxy.invokeOperation("deleteAddress", name);
            }

            public void deleteAddress(@Parameter(name="name", desc="The name of the address") String name, @Parameter(name="force", desc="Force everything out!") boolean force) throws Exception {
                this.proxy.invokeOperation("deleteAddress", name, force);
            }

            public void createQueue(String address, String name, String filter, boolean durable) throws Exception {
                this.proxy.invokeOperation("createQueue", address, name, filter, durable);
            }

            public void createQueue(String address, String name, String routingType) throws Exception {
                this.proxy.invokeOperation("createQueue", address, name, routingType);
            }

            public void createQueue(String address, String name, boolean durable, String routingType) throws Exception {
                this.proxy.invokeOperation("createQueue", address, name, durable, routingType);
            }

            public void createQueue(String address, String name, String filter, boolean durable, String routingType) throws Exception {
                this.proxy.invokeOperation("createQueue", address, name, filter, durable, routingType);
            }

            public String createQueue(String address, String routingType, String name, String filter, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, String lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoCreateAddress) throws Exception {
                return (String)this.proxy.invokeOperation("createQueue", address, routingType, name, filter, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoCreateAddress);
            }

            public String createQueue(String address, String routingType, String name, String filter, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, String lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
                return (String)this.proxy.invokeOperation("createQueue", address, routingType, name, filter, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
            }

            public String createQueue(String address, String routingType, String name, String filter, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, String groupFirstKey, boolean lastValue, String lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
                return (String)this.proxy.invokeOperation("createQueue", address, routingType, name, filter, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
            }

            public String createQueue(String address, String routingType, String name, String filter, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, String groupFirstKey, boolean lastValue, String lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress, long ringSize) throws Exception {
                return (String)this.proxy.invokeOperation("createQueue", address, routingType, name, filter, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, ringSize);
            }

            public void createQueue(String address, String name, boolean durable) throws Exception {
                this.proxy.invokeOperation("createQueue", address, name, durable);
            }

            public void deployQueue(String address, String name, String filter, boolean durable) throws Exception {
                this.proxy.invokeOperation("deployQueue", address, name, filter, durable);
            }

            public void deployQueue(String address, String name, String filterString) throws Exception {
                this.proxy.invokeOperation("deployQueue", address, name);
            }

            public void destroyQueue(String name) throws Exception {
                this.proxy.invokeOperation("destroyQueue", name);
            }

            public void destroyQueue(String name, boolean removeConsumers) throws Exception {
                this.proxy.invokeOperation("destroyQueue", name, removeConsumers);
            }

            public void destroyQueue(String name, boolean removeConsumers, boolean autoDeleteAddress) throws Exception {
                this.proxy.invokeOperation("destroyQueue", name, removeConsumers, autoDeleteAddress);
            }

            public void disableMessageCounters() throws Exception {
                this.proxy.invokeOperation("disableMessageCounters", new Object[0]);
            }

            public void enableMessageCounters() throws Exception {
                this.proxy.invokeOperation("enableMessageCounters", new Object[0]);
            }

            public String getBindingsDirectory() {
                return (String)this.proxy.retrieveAttributeValue("bindingsDirectory");
            }

            public int getConnectionCount() {
                return (Integer)this.proxy.retrieveAttributeValue("connectionCount", Integer.class);
            }

            public long getTotalConnectionCount() {
                return (Long)this.proxy.retrieveAttributeValue("totalConnectionCount", Long.class);
            }

            public long getTotalMessageCount() {
                return (Long)this.proxy.retrieveAttributeValue("totalMessageCount", Long.class);
            }

            public long getTotalMessagesAdded() {
                return (Long)this.proxy.retrieveAttributeValue("totalMessagesAdded", Long.class);
            }

            public long getTotalMessagesAcknowledged() {
                return (Long)this.proxy.retrieveAttributeValue("totalMessagesAcknowledged", Long.class);
            }

            public long getTotalConsumerCount() {
                return (Long)this.proxy.retrieveAttributeValue("totalConsumerCount", Long.class);
            }

            public long getConnectionTTLOverride() {
                return (Long)this.proxy.retrieveAttributeValue("connectionTTLOverride", Long.class);
            }

            public Object[] getConnectors() throws Exception {
                return (Object[])this.proxy.retrieveAttributeValue("connectors");
            }

            public String getConnectorsAsJSON() throws Exception {
                return (String)this.proxy.retrieveAttributeValue("connectorsAsJSON");
            }

            public int getAddressCount() {
                return (Integer)this.proxy.retrieveAttributeValue("addressCount", Integer.class);
            }

            public String[] getAddressNames() {
                return (String[])this.proxy.retrieveAttributeValue("addressNames", String.class);
            }

            public int getQueueCount() {
                return (Integer)this.proxy.retrieveAttributeValue("queueCount", Integer.class);
            }

            public String[] getQueueNames() {
                return (String[])this.proxy.retrieveAttributeValue("queueNames", String.class);
            }

            public String[] getQueueNames(String routingType) {
                try {
                    return (String[])this.proxy.invokeOperation(String.class, "getQueueNames", routingType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public String[] getClusterConnectionNames() {
                try {
                    return (String[])this.proxy.invokeOperation(String.class, "getClusterConnectionNames", new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public void addUser(String username, String password, String role, boolean plaintext) throws Exception {
                this.proxy.invokeOperation("addUser", username, password, role, plaintext);
            }

            public String listUser(String username) throws Exception {
                return (String)this.proxy.invokeOperation("listUser", username, String.class);
            }

            public void removeUser(String username) throws Exception {
                this.proxy.invokeOperation("removeUser", username);
            }

            public void resetUser(String username, String password, String roles) throws Exception {
                this.proxy.invokeOperation("resetUser", username, password, roles);
            }

            public void resetUser(String username, String password, String roles, boolean plaintext) throws Exception {
                this.proxy.invokeOperation("resetUser", username, password, roles, plaintext);
            }

            public void reloadConfigurationFile() throws Exception {
                this.proxy.invokeOperation("reloadConfigurationFile", new Object[0]);
            }

            public String getUptime() {
                return null;
            }

            public long getUptimeMillis() {
                return 0L;
            }

            public boolean isReplicaSync() {
                return false;
            }

            public int getIDCacheSize() {
                return (Integer)this.proxy.retrieveAttributeValue("IDCacheSize", Integer.class);
            }

            public String[] getInterceptorClassNames() {
                return (String[])this.proxy.retrieveAttributeValue("incomingInterceptorClassNames", String.class);
            }

            public String[] getIncomingInterceptorClassNames() {
                return (String[])this.proxy.retrieveAttributeValue("incomingInterceptorClassNames", String.class);
            }

            public String[] getOutgoingInterceptorClassNames() {
                return (String[])this.proxy.retrieveAttributeValue("outgoingInterceptorClassNames", String.class);
            }

            public String getJournalDirectory() {
                return (String)this.proxy.retrieveAttributeValue("journalDirectory");
            }

            public int getJournalFileSize() {
                return (Integer)this.proxy.retrieveAttributeValue("journalFileSize", Integer.class);
            }

            public int getJournalMaxIO() {
                return (Integer)this.proxy.retrieveAttributeValue("journalMaxIO", Integer.class);
            }

            public int getJournalMinFiles() {
                return (Integer)this.proxy.retrieveAttributeValue("journalMinFiles", Integer.class);
            }

            public String getJournalType() {
                return (String)this.proxy.retrieveAttributeValue("journalType");
            }

            public String getLargeMessagesDirectory() {
                return (String)this.proxy.retrieveAttributeValue("largeMessagesDirectory");
            }

            public String getNodeID() {
                return (String)this.proxy.retrieveAttributeValue("nodeID");
            }

            public long getActivationSequence() {
                return (Long)this.proxy.retrieveAttributeValue("activationSequence");
            }

            public String getManagementAddress() {
                return (String)this.proxy.retrieveAttributeValue("managementAddress");
            }

            public String getManagementNotificationAddress() {
                return (String)this.proxy.retrieveAttributeValue("managementNotificationAddress");
            }

            public int getMessageCounterMaxDayCount() {
                return (Integer)this.proxy.retrieveAttributeValue("messageCounterMaxDayCount", Integer.class);
            }

            public long getMessageCounterSamplePeriod() {
                return (Long)this.proxy.retrieveAttributeValue("messageCounterSamplePeriod", Long.class);
            }

            public long getMessageExpiryScanPeriod() {
                return (Long)this.proxy.retrieveAttributeValue("messageExpiryScanPeriod", Long.class);
            }

            public long getMessageExpiryThreadPriority() {
                return (Long)this.proxy.retrieveAttributeValue("messageExpiryThreadPriority", Long.class);
            }

            public String getPagingDirectory() {
                return (String)this.proxy.retrieveAttributeValue("pagingDirectory");
            }

            public int getScheduledThreadPoolMaxSize() {
                return (Integer)this.proxy.retrieveAttributeValue("scheduledThreadPoolMaxSize", Integer.class);
            }

            public int getThreadPoolMaxSize() {
                return (Integer)this.proxy.retrieveAttributeValue("threadPoolMaxSize", Integer.class);
            }

            public long getSecurityInvalidationInterval() {
                return (Long)this.proxy.retrieveAttributeValue("securityInvalidationInterval", Long.class);
            }

            public long getTransactionTimeout() {
                return (Long)this.proxy.retrieveAttributeValue("transactionTimeout", Long.class);
            }

            public long getTransactionTimeoutScanPeriod() {
                return (Long)this.proxy.retrieveAttributeValue("transactionTimeoutScanPeriod", Long.class);
            }

            public String getVersion() {
                return this.proxy.retrieveAttributeValue("version").toString();
            }

            public boolean isBackup() {
                return (Boolean)this.proxy.retrieveAttributeValue("backup");
            }

            public boolean isClustered() {
                return (Boolean)this.proxy.retrieveAttributeValue("clustered");
            }

            public boolean isCreateBindingsDir() {
                return (Boolean)this.proxy.retrieveAttributeValue("createBindingsDir");
            }

            public boolean isCreateJournalDir() {
                return (Boolean)this.proxy.retrieveAttributeValue("createJournalDir");
            }

            public boolean isJournalSyncNonTransactional() {
                return (Boolean)this.proxy.retrieveAttributeValue("journalSyncNonTransactional");
            }

            public boolean isJournalSyncTransactional() {
                return (Boolean)this.proxy.retrieveAttributeValue("journalSyncTransactional");
            }

            public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) throws Exception {
                this.proxy.invokeOperation("setFailoverOnServerShutdown", failoverOnServerShutdown);
            }

            public boolean isFailoverOnServerShutdown() {
                return (Boolean)this.proxy.retrieveAttributeValue("failoverOnServerShutdown");
            }

            public void setScaleDown(boolean scaleDown) throws Exception {
                this.proxy.invokeOperation("setEnabled", scaleDown);
            }

            public boolean isScaleDown() {
                return (Boolean)this.proxy.retrieveAttributeValue("scaleDown");
            }

            public boolean isMessageCounterEnabled() {
                return (Boolean)this.proxy.retrieveAttributeValue("messageCounterEnabled");
            }

            public boolean isPersistDeliveryCountBeforeDelivery() {
                return (Boolean)this.proxy.retrieveAttributeValue("persistDeliveryCountBeforeDelivery");
            }

            public boolean isAsyncConnectionExecutionEnabled() {
                return (Boolean)this.proxy.retrieveAttributeValue("asyncConnectionExecutionEnabled");
            }

            public boolean isPersistIDCache() {
                return (Boolean)this.proxy.retrieveAttributeValue("persistIDCache");
            }

            public boolean isSecurityEnabled() {
                return (Boolean)this.proxy.retrieveAttributeValue("securityEnabled");
            }

            public boolean isStarted() {
                return (Boolean)this.proxy.retrieveAttributeValue("started");
            }

            public boolean isWildcardRoutingEnabled() {
                return (Boolean)this.proxy.retrieveAttributeValue("wildcardRoutingEnabled");
            }

            public String[] listConnectionIDs() throws Exception {
                return (String[])this.proxy.invokeOperation("listConnectionIDs", new Object[0]);
            }

            public String[] listPreparedTransactions() throws Exception {
                return (String[])this.proxy.invokeOperation("listPreparedTransactions", new Object[0]);
            }

            public String listPreparedTransactionDetailsAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listPreparedTransactionDetailsAsJSON", new Object[0]);
            }

            public String listPreparedTransactionDetailsAsHTML() throws Exception {
                return (String)this.proxy.invokeOperation("listPreparedTransactionDetailsAsHTML", new Object[0]);
            }

            public String[] listHeuristicCommittedTransactions() throws Exception {
                return (String[])this.proxy.invokeOperation("listHeuristicCommittedTransactions", new Object[0]);
            }

            public String[] listHeuristicRolledBackTransactions() throws Exception {
                return (String[])this.proxy.invokeOperation("listHeuristicRolledBackTransactions", new Object[0]);
            }

            public String[] listRemoteAddresses() throws Exception {
                return (String[])this.proxy.invokeOperation("listRemoteAddresses", new Object[0]);
            }

            public String[] listRemoteAddresses(String ipAddress) throws Exception {
                return (String[])this.proxy.invokeOperation("listRemoteAddresses", ipAddress);
            }

            public String[] listSessions(String connectionID) throws Exception {
                return (String[])this.proxy.invokeOperation("listSessions", connectionID);
            }

            public void resetAllMessageCounterHistories() throws Exception {
                this.proxy.invokeOperation("resetAllMessageCounterHistories", new Object[0]);
            }

            public void resetAllMessageCounters() throws Exception {
                this.proxy.invokeOperation("resetAllMessageCounters", new Object[0]);
            }

            public boolean rollbackPreparedTransaction(String transactionAsBase64) throws Exception {
                return (Boolean)this.proxy.invokeOperation("rollbackPreparedTransaction", transactionAsBase64);
            }

            public void sendQueueInfoToQueue(String queueName, String address) throws Exception {
                this.proxy.invokeOperation("sendQueueInfoToQueue", queueName, address);
            }

            public void setMessageCounterMaxDayCount(int count) throws Exception {
                this.proxy.invokeOperation("setMessageCounterMaxDayCount", count);
            }

            public void setMessageCounterSamplePeriod(long newPeriod) throws Exception {
                this.proxy.invokeOperation("setMessageCounterSamplePeriod", newPeriod);
            }

            public int getJournalBufferSize() {
                return (Integer)this.proxy.retrieveAttributeValue("JournalBufferSize", Integer.class);
            }

            public int getJournalPoolFiles() {
                return (Integer)this.proxy.retrieveAttributeValue("JournalPoolFiles", Integer.class);
            }

            public int getJournalBufferTimeout() {
                return (Integer)this.proxy.retrieveAttributeValue("JournalBufferTimeout", Integer.class);
            }

            public int getJournalCompactMinFiles() {
                return (Integer)this.proxy.retrieveAttributeValue("JournalCompactMinFiles", Integer.class);
            }

            public int getJournalCompactPercentage() {
                return (Integer)this.proxy.retrieveAttributeValue("JournalCompactPercentage", Integer.class);
            }

            public boolean isPersistenceEnabled() {
                return (Boolean)this.proxy.retrieveAttributeValue("PersistenceEnabled");
            }

            public int getDiskScanPeriod() {
                return (Integer)this.proxy.retrieveAttributeValue("DiskScanPeriod", Integer.class);
            }

            public int getMaxDiskUsage() {
                return (Integer)this.proxy.retrieveAttributeValue("MaxDiskUsage", Integer.class);
            }

            public long getGlobalMaxSize() {
                return (Long)this.proxy.retrieveAttributeValue("GlobalMaxSize", Long.class);
            }

            public long getAddressMemoryUsage() {
                try {
                    return (Long)this.proxy.invokeOperation("getAddressMemoryUsage", new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0L;
                }
            }

            public int getAddressMemoryUsagePercentage() {
                try {
                    return (Integer)this.proxy.invokeOperation(Integer.TYPE, "getAddressMemoryUsagePercentage", new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }

            public long getAuthenticationCacheSize() {
                return (Long)this.proxy.retrieveAttributeValue("AuthenticationCacheSize", Long.class);
            }

            public long getAuthorizationCacheSize() {
                return (Long)this.proxy.retrieveAttributeValue("AuthorizationCacheSize", Long.class);
            }

            public double getDiskStoreUsage() {
                try {
                    return (Double)this.proxy.invokeOperation("getDiskStoreUsage", new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0.0;
                }
            }

            public String getHAPolicy() {
                return null;
            }

            public boolean freezeReplication() {
                return false;
            }

            public String createAddress(String name, String routingTypes) throws Exception {
                return (String)this.proxy.invokeOperation("createAddress", name, routingTypes);
            }

            public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles) throws Exception {
                this.proxy.invokeOperation("addSecuritySettings", addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles);
            }

            public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles) throws Exception {
                this.proxy.invokeOperation("addSecuritySettings", addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles, browseRoles);
            }

            public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddress, String deleteAddress) throws Exception {
                this.proxy.invokeOperation("addSecuritySettings", addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles, browseRoles, createAddress, deleteAddress);
            }

            public void removeSecuritySettings(String addressMatch) throws Exception {
                this.proxy.invokeOperation("removeSecuritySettings", addressMatch);
            }

            public Object[] getRoles(String addressMatch) throws Exception {
                return (Object[])this.proxy.invokeOperation("getRoles", addressMatch);
            }

            public String getRolesAsJSON(String addressMatch) throws Exception {
                return (String)this.proxy.invokeOperation("getRolesAsJSON", addressMatch);
            }

            public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String addressMatch, @Parameter(desc="the dead letter address setting", name="DLA") String DLA, @Parameter(desc="the expiry address setting", name="expiryAddress") String expiryAddress, @Parameter(desc="the expiry delay setting", name="expiryDelay") long expiryDelay, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean lastValueQueue, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int deliveryAttempts, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long maxSizeBytes, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int pageSizeBytes, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int pageMaxCacheSize, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long redeliveryDelay, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double redeliveryMultiplier, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long maxRedeliveryDelay, @Parameter(desc="the redistribution delay", name="redistributionDelay") long redistributionDelay, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean sendToDLAOnNoRoute, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String addressFullMessagePolicy, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long slowConsumerThreshold, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long slowConsumerCheckPeriod, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String slowConsumerPolicy, @Parameter(desc="allow queues to be created automatically", name="autoCreateJmsQueues") boolean autoCreateJmsQueues, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteJmsQueues") boolean autoDeleteJmsQueues, @Parameter(desc="allow topics to be created automatically", name="autoCreateJmsTopics") boolean autoCreateJmsTopics, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteJmsTopics") boolean autoDeleteJmsTopics) throws Exception {
                this.proxy.invokeOperation("addAddressSettings", addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics);
            }

            public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String addressMatch, @Parameter(desc="the dead letter address setting", name="DLA") String DLA, @Parameter(desc="the expiry address setting", name="expiryAddress") String expiryAddress, @Parameter(desc="the expiry delay setting", name="expiryDelay") long expiryDelay, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean lastValueQueue, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int deliveryAttempts, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long maxSizeBytes, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int pageSizeBytes, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int pageMaxCacheSize, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long redeliveryDelay, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double redeliveryMultiplier, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long maxRedeliveryDelay, @Parameter(desc="the redistribution delay", name="redistributionDelay") long redistributionDelay, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean sendToDLAOnNoRoute, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String addressFullMessagePolicy, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long slowConsumerThreshold, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long slowConsumerCheckPeriod, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String slowConsumerPolicy, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean autoCreateJmsQueues, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean autoDeleteJmsQueues, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean autoCreateJmsTopics, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean autoDeleteJmsTopics, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean autoCreateQueues, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean autoDeleteQueues, @Parameter(desc="allow topics to be created automatically", name="autoCreateAddresses") boolean autoCreateAddresses, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteAddresses") boolean autoDeleteAddresses) throws Exception {
                this.proxy.invokeOperation("addAddressSettings", addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses);
            }

            public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String addressMatch, @Parameter(desc="the dead letter address setting", name="DLA") String DLA, @Parameter(desc="the expiry address setting", name="expiryAddress") String expiryAddress, @Parameter(desc="the expiry delay setting", name="expiryDelay") long expiryDelay, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean lastValueQueue, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int deliveryAttempts, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long maxSizeBytes, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int pageSizeBytes, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int pageMaxCacheSize, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long redeliveryDelay, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double redeliveryMultiplier, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long maxRedeliveryDelay, @Parameter(desc="the redistribution delay", name="redistributionDelay") long redistributionDelay, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean sendToDLAOnNoRoute, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String addressFullMessagePolicy, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long slowConsumerThreshold, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long slowConsumerCheckPeriod, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String slowConsumerPolicy, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean autoCreateJmsQueues, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean autoDeleteJmsQueues, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean autoCreateJmsTopics, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean autoDeleteJmsTopics, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean autoCreateQueues, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean autoDeleteQueues, @Parameter(desc="allow topics to be created automatically", name="autoCreateAddresses") boolean autoCreateAddresses, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteAddresses") boolean autoDeleteAddresses, @Parameter(desc="how to deal with queues deleted from XML at runtime", name="configDeleteQueues") String configDeleteQueues, @Parameter(desc="how to deal with addresses deleted from XML at runtime", name="configDeleteAddresses") String configDeleteAddresses, @Parameter(desc="used with `BLOCK`, the max size an address can reach before messages are rejected; works in combination with `max-size-bytes` for AMQP clients only", name="maxSizeBytesRejectThreshold") long maxSizeBytesRejectThreshold, @Parameter(desc="last-value-key value if none is set on the queue", name="defaultLastValueKey") String defaultLastValueKey, @Parameter(desc="non-destructive value if none is set on the queue", name="defaultNonDestructive") boolean defaultNonDestructive, @Parameter(desc="exclusive value if none is set on the queue", name="defaultExclusiveQueue") boolean defaultExclusiveQueue, @Parameter(desc="group-rebalance value if none is set on the queue", name="defaultGroupRebalance") boolean defaultGroupRebalance, @Parameter(desc="group-buckets value if none is set on the queue", name="defaultGroupBuckets") int defaultGroupBuckets, @Parameter(desc="group-first-key value if none is set on the queue", name="defaultGroupFirstKey") String defaultGroupFirstKey, @Parameter(desc="max-consumers value if none is set on the queue", name="defaultMaxConsumers") int defaultMaxConsumers, @Parameter(desc="purge-on-no-consumers value if none is set on the queue", name="defaultPurgeOnNoConsumers") boolean defaultPurgeOnNoConsumers, @Parameter(desc="consumers-before-dispatch value if none is set on the queue", name="defaultConsumersBeforeDispatch") int defaultConsumersBeforeDispatch, @Parameter(desc="delay-before-dispatch value if none is set on the queue", name="defaultDelayBeforeDispatch") long defaultDelayBeforeDispatch, @Parameter(desc="routing-type value if none is set on the queue", name="defaultQueueRoutingType") String defaultQueueRoutingType, @Parameter(desc="routing-type value if none is set on the address", name="defaultAddressRoutingType") String defaultAddressRoutingType, @Parameter(desc="consumer-window-size value if none is set on the queue", name="defaultConsumerWindowSize") int defaultConsumerWindowSize, @Parameter(desc="ring-size value if none is set on the queue", name="defaultRingSize") long defaultRingSize, @Parameter(desc="allow created queues to be deleted automatically", name="autoDeleteCreatedQueues") boolean autoDeleteCreatedQueues, @Parameter(desc="delay for deleting auto-created queues", name="autoDeleteQueuesDelay") long autoDeleteQueuesDelay, @Parameter(desc="the message count the queue must be at or below before it can be auto deleted", name="autoDeleteQueuesMessageCount") long autoDeleteQueuesMessageCount, @Parameter(desc="delay for deleting auto-created addresses", name="autoDeleteAddressesDelay") long autoDeleteAddressesDelay, @Parameter(desc="factor by which to modify the redelivery delay slightly to avoid collisions", name="redeliveryCollisionAvoidanceFactor") double redeliveryCollisionAvoidanceFactor, @Parameter(desc="the number of messages to preserve for future queues created on the matching address", name="retroactiveMessageCount") long retroactiveMessageCount) throws Exception {
                this.proxy.invokeOperation("addAddressSettings", addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount);
            }

            public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String addressMatch, @Parameter(desc="the dead letter address setting", name="DLA") String DLA, @Parameter(desc="the expiry address setting", name="expiryAddress") String expiryAddress, @Parameter(desc="the expiry delay setting", name="expiryDelay") long expiryDelay, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean lastValueQueue, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int deliveryAttempts, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long maxSizeBytes, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int pageSizeBytes, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int pageMaxCacheSize, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long redeliveryDelay, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double redeliveryMultiplier, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long maxRedeliveryDelay, @Parameter(desc="the redistribution delay", name="redistributionDelay") long redistributionDelay, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean sendToDLAOnNoRoute, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String addressFullMessagePolicy, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long slowConsumerThreshold, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long slowConsumerCheckPeriod, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String slowConsumerPolicy, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean autoCreateJmsQueues, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean autoDeleteJmsQueues, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean autoCreateJmsTopics, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean autoDeleteJmsTopics, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean autoCreateQueues, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean autoDeleteQueues, @Parameter(desc="allow topics to be created automatically", name="autoCreateAddresses") boolean autoCreateAddresses, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteAddresses") boolean autoDeleteAddresses, @Parameter(desc="how to deal with queues deleted from XML at runtime", name="configDeleteQueues") String configDeleteQueues, @Parameter(desc="how to deal with addresses deleted from XML at runtime", name="configDeleteAddresses") String configDeleteAddresses, @Parameter(desc="used with `BLOCK`, the max size an address can reach before messages are rejected; works in combination with `max-size-bytes` for AMQP clients only", name="maxSizeBytesRejectThreshold") long maxSizeBytesRejectThreshold, @Parameter(desc="last-value-key value if none is set on the queue", name="defaultLastValueKey") String defaultLastValueKey, @Parameter(desc="non-destructive value if none is set on the queue", name="defaultNonDestructive") boolean defaultNonDestructive, @Parameter(desc="exclusive value if none is set on the queue", name="defaultExclusiveQueue") boolean defaultExclusiveQueue, @Parameter(desc="group-rebalance value if none is set on the queue", name="defaultGroupRebalance") boolean defaultGroupRebalance, @Parameter(desc="group-buckets value if none is set on the queue", name="defaultGroupBuckets") int defaultGroupBuckets, @Parameter(desc="group-first-key value if none is set on the queue", name="defaultGroupFirstKey") String defaultGroupFirstKey, @Parameter(desc="max-consumers value if none is set on the queue", name="defaultMaxConsumers") int defaultMaxConsumers, @Parameter(desc="purge-on-no-consumers value if none is set on the queue", name="defaultPurgeOnNoConsumers") boolean defaultPurgeOnNoConsumers, @Parameter(desc="consumers-before-dispatch value if none is set on the queue", name="defaultConsumersBeforeDispatch") int defaultConsumersBeforeDispatch, @Parameter(desc="delay-before-dispatch value if none is set on the queue", name="defaultDelayBeforeDispatch") long defaultDelayBeforeDispatch, @Parameter(desc="routing-type value if none is set on the queue", name="defaultQueueRoutingType") String defaultQueueRoutingType, @Parameter(desc="routing-type value if none is set on the address", name="defaultAddressRoutingType") String defaultAddressRoutingType, @Parameter(desc="consumer-window-size value if none is set on the queue", name="defaultConsumerWindowSize") int defaultConsumerWindowSize, @Parameter(desc="ring-size value if none is set on the queue", name="defaultRingSize") long defaultRingSize, @Parameter(desc="allow created queues to be deleted automatically", name="autoDeleteCreatedQueues") boolean autoDeleteCreatedQueues, @Parameter(desc="delay for deleting auto-created queues", name="autoDeleteQueuesDelay") long autoDeleteQueuesDelay, @Parameter(desc="the message count the queue must be at or below before it can be auto deleted", name="autoDeleteQueuesMessageCount") long autoDeleteQueuesMessageCount, @Parameter(desc="delay for deleting auto-created addresses", name="autoDeleteAddressesDelay") long autoDeleteAddressesDelay, @Parameter(desc="factor by which to modify the redelivery delay slightly to avoid collisions", name="redeliveryCollisionAvoidanceFactor") double redeliveryCollisionAvoidanceFactor, @Parameter(desc="the number of messages to preserve for future queues created on the matching address", name="retroactiveMessageCount") long retroactiveMessageCount, @Parameter(desc="allow dead-letter address & queue to be created automatically", name="autoCreateDeadLetterResources") boolean autoCreateDeadLetterResources, @Parameter(desc="prefix to use on auto-create dead-letter queue", name="deadLetterQueuePrefix") String deadLetterQueuePrefix, @Parameter(desc="suffix to use on auto-create dead-letter queue", name="deadLetterQueueSuffix") String deadLetterQueueSuffix, @Parameter(desc="allow expiry address & queue to be created automatically", name="autoCreateExpiryResources") boolean autoCreateExpiryResources, @Parameter(desc="prefix to use on auto-create expiry queue", name="expiryQueuePrefix") String expiryQueuePrefix, @Parameter(desc="suffix to use on auto-create expiry queue", name="expiryQueueSuffix") String expiryQueueSuffix) throws Exception {
                this.proxy.invokeOperation("addAddressSettings", addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix);
            }

            public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String addressMatch, @Parameter(desc="the dead letter address setting", name="DLA") String DLA, @Parameter(desc="the expiry address setting", name="expiryAddress") String expiryAddress, @Parameter(desc="the expiry delay setting", name="expiryDelay") long expiryDelay, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean lastValueQueue, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int deliveryAttempts, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long maxSizeBytes, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int pageSizeBytes, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int pageMaxCacheSize, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long redeliveryDelay, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double redeliveryMultiplier, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long maxRedeliveryDelay, @Parameter(desc="the redistribution delay", name="redistributionDelay") long redistributionDelay, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean sendToDLAOnNoRoute, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String addressFullMessagePolicy, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long slowConsumerThreshold, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long slowConsumerCheckPeriod, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String slowConsumerPolicy, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean autoCreateJmsQueues, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean autoDeleteJmsQueues, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean autoCreateJmsTopics, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean autoDeleteJmsTopics, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean autoCreateQueues, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean autoDeleteQueues, @Parameter(desc="allow topics to be created automatically", name="autoCreateAddresses") boolean autoCreateAddresses, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteAddresses") boolean autoDeleteAddresses, @Parameter(desc="how to deal with queues deleted from XML at runtime", name="configDeleteQueues") String configDeleteQueues, @Parameter(desc="how to deal with addresses deleted from XML at runtime", name="configDeleteAddresses") String configDeleteAddresses, @Parameter(desc="used with `BLOCK`, the max size an address can reach before messages are rejected; works in combination with `max-size-bytes` for AMQP clients only", name="maxSizeBytesRejectThreshold") long maxSizeBytesRejectThreshold, @Parameter(desc="last-value-key value if none is set on the queue", name="defaultLastValueKey") String defaultLastValueKey, @Parameter(desc="non-destructive value if none is set on the queue", name="defaultNonDestructive") boolean defaultNonDestructive, @Parameter(desc="exclusive value if none is set on the queue", name="defaultExclusiveQueue") boolean defaultExclusiveQueue, @Parameter(desc="group-rebalance value if none is set on the queue", name="defaultGroupRebalance") boolean defaultGroupRebalance, @Parameter(desc="group-buckets value if none is set on the queue", name="defaultGroupBuckets") int defaultGroupBuckets, @Parameter(desc="group-first-key value if none is set on the queue", name="defaultGroupFirstKey") String defaultGroupFirstKey, @Parameter(desc="max-consumers value if none is set on the queue", name="defaultMaxConsumers") int defaultMaxConsumers, @Parameter(desc="purge-on-no-consumers value if none is set on the queue", name="defaultPurgeOnNoConsumers") boolean defaultPurgeOnNoConsumers, @Parameter(desc="consumers-before-dispatch value if none is set on the queue", name="defaultConsumersBeforeDispatch") int defaultConsumersBeforeDispatch, @Parameter(desc="delay-before-dispatch value if none is set on the queue", name="defaultDelayBeforeDispatch") long defaultDelayBeforeDispatch, @Parameter(desc="routing-type value if none is set on the queue", name="defaultQueueRoutingType") String defaultQueueRoutingType, @Parameter(desc="routing-type value if none is set on the address", name="defaultAddressRoutingType") String defaultAddressRoutingType, @Parameter(desc="consumer-window-size value if none is set on the queue", name="defaultConsumerWindowSize") int defaultConsumerWindowSize, @Parameter(desc="ring-size value if none is set on the queue", name="defaultRingSize") long defaultRingSize, @Parameter(desc="allow created queues to be deleted automatically", name="autoDeleteCreatedQueues") boolean autoDeleteCreatedQueues, @Parameter(desc="delay for deleting auto-created queues", name="autoDeleteQueuesDelay") long autoDeleteQueuesDelay, @Parameter(desc="the message count the queue must be at or below before it can be auto deleted", name="autoDeleteQueuesMessageCount") long autoDeleteQueuesMessageCount, @Parameter(desc="delay for deleting auto-created addresses", name="autoDeleteAddressesDelay") long autoDeleteAddressesDelay, @Parameter(desc="factor by which to modify the redelivery delay slightly to avoid collisions", name="redeliveryCollisionAvoidanceFactor") double redeliveryCollisionAvoidanceFactor, @Parameter(desc="the number of messages to preserve for future queues created on the matching address", name="retroactiveMessageCount") long retroactiveMessageCount, @Parameter(desc="allow dead-letter address & queue to be created automatically", name="autoCreateDeadLetterResources") boolean autoCreateDeadLetterResources, @Parameter(desc="prefix to use on auto-create dead-letter queue", name="deadLetterQueuePrefix") String deadLetterQueuePrefix, @Parameter(desc="suffix to use on auto-create dead-letter queue", name="deadLetterQueueSuffix") String deadLetterQueueSuffix, @Parameter(desc="allow expiry address & queue to be created automatically", name="autoCreateExpiryResources") boolean autoCreateExpiryResources, @Parameter(desc="prefix to use on auto-create expiry queue", name="expiryQueuePrefix") String expiryQueuePrefix, @Parameter(desc="suffix to use on auto-create expiry queue", name="expiryQueueSuffix") String expiryQueueSuffix, @Parameter(desc="the min expiry delay setting", name="minExpiryDelay") long minExpiryDelay, @Parameter(desc="the max expiry delay setting", name="maxExpiryDelay") long maxExpiryDelay, @Parameter(desc="whether or not to enable metrics", name="enableMetrics") boolean enableMetrics) throws Exception {
                this.proxy.invokeOperation("addAddressSettings", addressMatch, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses, configDeleteQueues, configDeleteAddresses, maxSizeBytesRejectThreshold, defaultLastValueKey, defaultNonDestructive, defaultExclusiveQueue, defaultGroupRebalance, defaultGroupBuckets, defaultGroupFirstKey, defaultMaxConsumers, defaultPurgeOnNoConsumers, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch, defaultQueueRoutingType, defaultAddressRoutingType, defaultConsumerWindowSize, defaultRingSize, autoDeleteCreatedQueues, autoDeleteQueuesDelay, autoDeleteQueuesMessageCount, autoDeleteAddressesDelay, redeliveryCollisionAvoidanceFactor, retroactiveMessageCount, autoCreateDeadLetterResources, deadLetterQueuePrefix, deadLetterQueueSuffix, autoCreateExpiryResources, expiryQueuePrefix, expiryQueueSuffix, minExpiryDelay, maxExpiryDelay, enableMetrics);
            }

            public String listNetworkTopology() throws Exception {
                return (String)this.proxy.invokeOperation("listNetworkTopology", new Object[0]);
            }

            public String getAddressInfo(String address) throws ActiveMQAddressDoesNotExistException {
                return null;
            }

            public String listBindingsForAddress(String address) throws Exception {
                return "";
            }

            public void removeAddressSettings(String addressMatch) throws Exception {
                this.proxy.invokeOperation("removeAddressSettings", addressMatch);
            }

            public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName) throws Exception {
                this.proxy.invokeOperation("createDivert", name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName);
            }

            public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName, String routingType) throws Exception {
                this.proxy.invokeOperation("createDivert", name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName, routingType);
            }

            public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName, Map<String, String> transformerProperties, String routingType) throws Exception {
                this.proxy.invokeOperation("createDivert", name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName, transformerProperties, routingType);
            }

            public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName, String transformerPropertiesAsJSON, String routingType) throws Exception {
                this.proxy.invokeOperation("createDivert", name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName, transformerPropertiesAsJSON, routingType);
            }

            public void updateDivert(String name, String forwardingAddress, String filterString, String transformerClassName, Map<String, String> transformerProperties, String routingType) throws Exception {
                this.proxy.invokeOperation("updateDivert", name, forwardingAddress, filterString, transformerClassName, transformerProperties, routingType);
            }

            public void destroyDivert(String name) throws Exception {
                this.proxy.invokeOperation("destroyDivert", name);
            }

            public String[] getBridgeNames() {
                return (String[])this.proxy.retrieveAttributeValue("bridgeNames", String.class);
            }

            public void destroyBridge(String name) throws Exception {
                this.proxy.invokeOperation("destroyBridge", name);
            }

            public void createConnectorService(String name, String factoryClass, Map<String, Object> parameters) throws Exception {
                this.proxy.invokeOperation("createConnectorService", name, factoryClass, parameters);
            }

            public void destroyConnectorService(String name) throws Exception {
                this.proxy.invokeOperation("destroyConnectorService", name);
            }

            public String[] getConnectorServices() {
                return (String[])this.proxy.retrieveAttributeValue("connectorServices", String.class);
            }

            public void forceFailover() throws Exception {
                this.proxy.invokeOperation("forceFailover", new Object[0]);
            }

            public String getLiveConnectorName() throws Exception {
                return (String)this.proxy.retrieveAttributeValue("liveConnectorName");
            }

            public String getAddressSettingsAsJSON(String addressMatch) throws Exception {
                return (String)this.proxy.invokeOperation("getAddressSettingsAsJSON", addressMatch);
            }

            public String[] getDivertNames() {
                return (String[])this.proxy.retrieveAttributeValue("divertNames", String.class);
            }

            public String[] listDivertNames() {
                return new String[0];
            }

            public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, int producerWindowSize, long clientFailureCheckPeriod, String connectorNames, boolean useDiscovery, boolean ha, String user, String password) throws Exception {
                this.proxy.invokeOperation("createBridge", name, queueName, forwardingAddress, filterString, transformerClassName, retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, producerWindowSize, clientFailureCheckPeriod, connectorNames, useDiscovery, ha, user, password);
            }

            public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, Map<String, String> transformerProperties, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, int producerWindowSize, long clientFailureCheckPeriod, String connectorNames, boolean useDiscovery, boolean ha, String user, String password) throws Exception {
                this.proxy.invokeOperation("createBridge", name, queueName, forwardingAddress, filterString, transformerClassName, transformerProperties, retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, producerWindowSize, clientFailureCheckPeriod, connectorNames, useDiscovery, ha, user, password);
            }

            public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, String transformerPropertiesAsJSON, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, int producerWindowSize, long clientFailureCheckPeriod, String connectorNames, boolean useDiscovery, boolean ha, String user, String password) throws Exception {
                this.proxy.invokeOperation("createBridge", name, queueName, forwardingAddress, filterString, transformerClassName, transformerPropertiesAsJSON, retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, producerWindowSize, clientFailureCheckPeriod, connectorNames, useDiscovery, ha, user, password);
            }

            public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, long clientFailureCheckPeriod, String connectorNames, boolean useDiscovery, boolean ha, String user, String password) throws Exception {
                this.proxy.invokeOperation("createBridge", name, queueName, forwardingAddress, filterString, transformerClassName, retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, clientFailureCheckPeriod, connectorNames, useDiscovery, ha, user, password);
            }

            public void createBridge(String bridgeConfiguration) throws Exception {
                this.proxy.invokeOperation("createBridge", bridgeConfiguration);
            }

            public String listProducersInfoAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listProducersInfoAsJSON", new Object[0]);
            }

            public String listConsumersAsJSON(String connectionID) throws Exception {
                return (String)this.proxy.invokeOperation("listConsumersAsJSON", connectionID);
            }

            public String listAllConsumersAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listAllConsumersAsJSON", new Object[0]);
            }

            public String listConnectionsAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listConnectionsAsJSON", new Object[0]);
            }

            public String listSessionsAsJSON(@Parameter(desc="a connection ID", name="connectionID") String connectionID) throws Exception {
                return (String)this.proxy.invokeOperation("listSessionsAsJSON", connectionID);
            }

            public String listAllSessionsAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listAllSessionsAsJSON", new Object[0]);
            }

            public String listAddresses(@Parameter(name="separator", desc="Separator used on the string listing") String separator) throws Exception {
                return (String)this.proxy.invokeOperation("listAddresses", separator);
            }

            public String listConnections(String filter, int page, int pageSize) throws Exception {
                return (String)this.proxy.invokeOperation("listConnections", filter, page, pageSize);
            }

            public String listSessions(@Parameter(name="Filter String") String filter, @Parameter(name="Page Number") int page, @Parameter(name="Page Size") int pageSize) throws Exception {
                return (String)this.proxy.invokeOperation("listSessions", filter, page, pageSize);
            }

            public String listConsumers(@Parameter(name="Options") String options, @Parameter(name="Page Number") int page, @Parameter(name="Page Size") int pageSize) throws Exception {
                return (String)this.proxy.invokeOperation("listConsumers", options, page, pageSize);
            }

            public String listProducers(@Parameter(name="Options") String options, @Parameter(name="Page Number") int page, @Parameter(name="Page Size") int pageSize) throws Exception {
                return (String)this.proxy.invokeOperation("listProducers", options, page, pageSize);
            }

            public String listAddresses(@Parameter(name="Options") String options, @Parameter(name="Page Number") int page, @Parameter(name="Page Size") int pageSize) throws Exception {
                return (String)this.proxy.invokeOperation("listAddresses", options, page, pageSize);
            }

            public String listQueues(@Parameter(name="Options") String options, @Parameter(name="Page Number") int page, @Parameter(name="Page Size") int pageSize) throws Exception {
                return (String)this.proxy.invokeOperation("listQueues", options, page, pageSize);
            }

            public void replay(String address, String target, String filter) throws Exception {
                this.proxy.invokeOperation("replay", address, target, filter);
            }

            public void replay(String startScan, String endScan, String address, String target, String filter) throws Exception {
                this.proxy.invokeOperation("replay", startScan, endScan, address, target, filter);
            }
        };
    }

    @Override
    public boolean usingCore() {
        return true;
    }
}

